/*
 setup-flood.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "setup-int.h"

static gboolean sig_setup_apply(void)
{
    setup_write("flood", flood_options);
    return TRUE;
}

static GtkWidget *create_spin(GtkWidget *box, GtkAdjustment *adj, gchar *prefix, gchar *suffix, SETUP_REC *option)
{
    GtkWidget *hbox, *label, *spin;

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 0);

    label = gtk_label_new(prefix);
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    spin = gtk_spin_button_new(adj, 0, 0);
    option->widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 0);

    label = gtk_label_new(suffix);
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    return spin;
}

static gboolean setup_flood(GtkWidget *dialog)
{
    GtkWidget *mainvbox, *vbox, *frame, *spin;
    GtkAdjustment *adj;

    g_return_val_if_fail(dialog != NULL, FALSE);

    mainvbox = gtk_vbox_new(FALSE, 7);
    gtk_container_border_width(GTK_CONTAINER(mainvbox), 7);

    /* --- */
    frame = gtk_frame_new(_("Flood protection"));
    gtk_box_pack_start(GTK_BOX(mainvbox), frame, FALSE, FALSE, 0);

    vbox = gtk_vbox_new(FALSE, 2);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) flood_options[OPTION_FLOOD_TIMECHECK].data),
                                                0, G_MAXINT, 100, 1000, 0);
    spin = create_spin(vbox, adj, _("Check for flood every"), _("milliseconds"), &flood_options[OPTION_FLOOD_TIMECHECK]);
    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) flood_options[OPTION_FLOOD_MAX_MSGS].data),
                                                0, G_MAXINT, 1, 5, 0);
    spin = create_spin(vbox, adj, _("Flooding declared after"), _("messages"), &flood_options[OPTION_FLOOD_MAX_MSGS]);
    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) flood_options[OPTION_AUTOIGNORE_TIME].data),
                                                0, G_MAXINT, 1, 60, 0);
    spin = create_spin(vbox, adj, _("Autoignore flooders for"), _("seconds"), &flood_options[OPTION_AUTOIGNORE_TIME]);
    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) flood_options[OPTION_CTCP_FLOODCHECK].data),
                                                0, G_MAXINT, 1, 60, 0);
    spin = create_spin(vbox, adj, _("Timeout between replying to CTCPs"), _("seconds"), &flood_options[OPTION_CTCP_FLOODCHECK]);
    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) flood_options[OPTION_CTCP_MAX_QUEUE].data),
                                                0, G_MAXINT, 1, 10, 0);
    spin = create_spin(vbox, adj, _("Max. CTCP requests to keep in buffer"), "", &flood_options[OPTION_CTCP_MAX_QUEUE]);
    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) flood_options[OPTION_CMD_QUEUE_SPEED].data),
                                                0, G_MAXINT, 100, 1000, 0);
    spin = create_spin(vbox, adj, _("Timeout between sending commands to server"), _("milliseconds"), &flood_options[OPTION_CMD_QUEUE_SPEED]);

    setup_finish_init(dialog, flood_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   mainvbox, gtk_label_new(_("Flood")));
    return TRUE;
}

void init_flood(void)
{
    signal_add("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_add("setup preferences", (SIGNAL_FUNC) setup_flood);
}

void deinit_flood(void)
{
    signal_remove("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_remove("setup preferences", (SIGNAL_FUNC) setup_flood);
}
