/**************************************************************************** 
** File: slip.c
**
** Author: Michael S. Borella
**
** Comments: Dump slip packets
**
*****************************************************************************/

#include <stdio.h>
#include <pcap.h>
#include <unistd.h>
#include "config.h"
#include "slip.h"

#define SLIP_HDRLEN 16

u_char *packet_ptr;
u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_slip()
**
** Process packets from the DLT_RAW interface type
**
**----------------------------------------------------------------------------
*/

void dump_slip(u_char *user, const struct pcap_pkthdr *h, u_char *p)
{
  u_int length; 
  u_int caplen;
  struct ip *ip;
  void dump_ip(u_char *, u_int);

  /*
   * Get total packet length and length of the captured section
   */

  length = h->len;
  caplen = h->caplen;

  /*
   * Some printers want to get back at the link level addresses,
   * and/or check that they're not walking off the end of the packet.
   * Rather than pass them all the way down, we set these globals.
   */
   
  packet_ptr = p;
  packet_end = p + caplen;

  /*
   * Dump raw header
   */

  printf("==========================================================\n");
  printf("                        Slip Header (%u.%06u)\n",
	 (u_int32_t) h->ts.tv_sec, (u_int32_t) h->ts.tv_usec);

  /*
   * Check for a truncated packet 
   */

  if (caplen < SLIP_HDRLEN)
    {
      printf("Truncated slip header\n");
      return;
    }

  /* 
   * Calculate length of IP header on out
   */

  length -= SLIP_HDRLEN;
  
  /*
   * XXX write something to dump SLIP fields here!
   */
  
  ip = (struct ip *) (p + SLIP_HDRLEN);
  dump_ip((u_char *) ip, length);

}
