/**************************************************************************** 
 **
 ** File: loopback.c
 **
 ** Author: Mike Borella
 **
 ** Comments: Dump loopback packets
 **
 *****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <pcap.h>
#include "config.h"
#include "loopback.h"
#include "ip.h"

#define INET_FAMILY 524288

u_char *packet_ptr;
u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_loopback()
**
** Process packets from DLT_NULL device
**
**----------------------------------------------------------------------------
*/

void dump_loopback(u_char *user, const struct pcap_pkthdr *h, u_char *p)
{
  int length; 
  int caplen;
  u_int32_t family;

  /*
   * Get total packet length and length of the captured section
   */

  length = h->len;
  caplen = h->caplen;

  /*
   * Dump header announcement
   */

  printf("=================================================================\n");
  printf("                        Loopback Header(%u.%06u)\n",
	 (u_int32_t) h->ts.tv_sec, (u_int32_t) h->ts.tv_usec);
  printf("-----------------------------------------------------------------\n");

  /*
   * Check for truncated header 
   */

  if (caplen < LOOPBACK_HEADER_LEN) 
    {
      printf("Loopback header too short! (%d bytes)\n", length);
      return;
    }

  /*
   * Dump header field
   */

  printf("Address family          ");
  memcpy((void *) &family, (void *) p, LOOPBACK_HEADER_LEN);
  if (family == INET_FAMILY)
    printf("Internet\n");
  else
    {
      printf("Unknown (%d)\n", family);
      return;
    }

  /*
   * Some printers want to get back at the link level addresses,
   * and/or check that they're not walking off the end of the packet.
   * Rather than pass them all the way down, we set these globals.
   */
   
  packet_ptr = p;
  packet_end = p + caplen;


  /*
   * Check for IEEE 802 (LLC) encapsulation.  If not, assume regular ethernet
   */

  p += LOOPBACK_HEADER_LEN;

  dump_ip(p, length);
  
  return;

}

