/**************************************************************************** 
** File: utils.c
**
** Author: Mike Borella
**
** Comments: Misc ipgrab utilities
**
*****************************************************************************/

#include <stdio.h>
#include "config.h"

/*----------------------------------------------------------------------------
**
** get_next_line()
**
** Grab the next line terminated by a <CR><LF>
**
** ptr - points to the beginning of the section of the packet to parse
** ep  - points to the last char of the packet
** line - we put the line in here
**
**----------------------------------------------------------------------------
*/

int get_next_line(u_char *ptr, u_char *ep, char *line)
{
  int cnt = 0;

  while (*ptr != '\r' && ptr != ep)
    {
      line[cnt] = *ptr;
      cnt ++;
      ptr ++;

      /*
       * Make sure we don't run off the end of the packet
       */

      if (ptr == ep)
	{
	  line[cnt] = '\0';
	  return cnt-1;
	}
      
    }
  line[cnt] = '\0';
  cnt = cnt + 2;
  if (cnt == 2)
    return 0;
  else 
    return cnt;

}
