#include <gnome.h>
#include <stdio.h>
#include "songinfo.h"

#include "../pixmaps/arleftsm.xpm"
#include "../pixmaps/arrightsm.xpm"

ssong_info* 
songinfo_new(void) {
	ssong_info* i;
	i = g_new0(ssong_info, 1);
	return i;
}

gint
songinfo_compare_size(GtkCList *clist, gconstpointer row1, gconstpointer row2) {
	ssong_info* s1 = ((GtkCListRow*)row1)->data; 
	ssong_info* s2 = ((GtkCListRow*)row2)->data; 
	if(s1 != NULL && s2 != NULL) {
		if (s1->size < s2->size) return -1;
		if (s1->size > s2->size) return 1;
	}
	return 0;
}

gint
songinfo_compare_time(GtkCList *clist, gconstpointer row1, gconstpointer row2) {
	ssong_info* s1 = ((GtkCListRow*)row1)->data; 
	ssong_info* s2 = ((GtkCListRow*)row2)->data; 
	if(s1 != NULL && s2 != NULL) {
		if (s1->time < s2->time) return -1;
		if (s1->time > s2->time) return 1;
	}
	return 0;
}


gint
songinfo_compare_bitrate(GtkCList *clist, gconstpointer row1, gconstpointer row2) {
	ssong_info* s1 = ((GtkCListRow*)row1)->data; 
	ssong_info* s2 = ((GtkCListRow*)row2)->data; 
	if(s1 != NULL && s2 != NULL) {
		if (s1->bitrate < s2->bitrate) return -1;
		if (s1->bitrate > s2->bitrate) return 1;
	}
	return 0;
}

gint
songinfo_compare_connection(GtkCList *clist, gconstpointer row1, gconstpointer row2) {
	ssong_info* s1 = ((GtkCListRow*)row1)->data; 
	ssong_info* s2 = ((GtkCListRow*)row2)->data; 
	if(s1 != NULL && s2 != NULL) {
		if (s1->conn < s2->conn) return -1;
		if (s1->conn > s2->conn) return 1;
	}
	return 0;
}

GtkWidget* songinfo_arrow_button_new(GtkWidget *base, int left) {
	GtkWidget *pixmap, *b = gtk_button_new();
	gtk_button_set_relief(GTK_BUTTON(b), GTK_RELIEF_NONE);
	GTK_WIDGET_UNSET_FLAGS(b, GTK_CAN_FOCUS);
		pixmap = gnome_pixmap_new_from_xpm_d(left ? arleftsm_xpm : arrightsm_xpm);
		gtk_container_add(GTK_CONTAINER(b), pixmap);
	return b;
}


