#ifndef __NETWORK_H
#define __NETWORK_H

/* Connect to socket */
gint net_connect(gchar *server, gint port);
/* Disconnect socket */
void net_disconnect(gint fh);

/* Listen for connections on a socket */
gint net_listen(gchar *addr, gint *port);
/* Accept a connection on a socket */
gint net_accept(gint handle, gchar *addr, gint *port);

/* Read data from socket */
gint net_receive(gint fh, gchar *buf, gint len);
/* Transmit data */
gint net_transmit(gint fh, gchar *data, gint len);

/* Get socket address/port */
gint net_getsockname(gint handle, gchar *addr, gint *port);

gint read_line(gint handle, GString *output, GString *buffer);

#endif
