#ifndef DAEMON_FILES_H
#define DAEMON_FILES_H

#include <sys/stat.h>

#include "global.h"

#define BASENAME(x)	(strrchr((x), '/') ? strrchr((x), '/') + 1 : (x))
#define MAKEPATH(x) {                                   \
    char path_buf[256];                                 \
    if ((*(x) != '/') && (*(x) != '~'))                 \
    {                                                   \
        sprintf(path_buf, "%s/%s", DX_HomeDir, (x));    \
        strcpy((x), path_buf);                          \
    }                                                   \
}

// All functions which modify the on-disk batch must obtain this mutex.
MUTEX(BatchMutex)

FileInfo *AddFileToBatch(BOOL add_to_file, char *file_line,
                         struct _clientInfo *client);
ServerInfo *AddServer(BOOL add_to_file, const char *url, const char *alias,
                      const char *comment, const char *user_name,
                      const char *password, const char *flags);
BOOL AddServerToFile(ServerInfo *server);
void ClearFileInfo(FileInfo *file);
void FindServerMirrors(ServerInfo *server, char *mirror_string);
ServerInfo *FindServer(char *serv_name, BOOL add_to_file);
int ReadBatchFile(const char *batch_file);
int ReadServersFile(const char *servers_file);
void ReadDataFiles(void);
void RewriteFileInfo(FileInfo *file, const char *new_line);
void RemoveFromBatch(FileInfo *file);
void FileComplete(FileInfo *file, const char *reason);
char *RemoveFlag(char *old_flags, char to_remove);

BOOL CopyFile(const char *dst, const char *src, BOOL append);
void *ThreadedMoveFile(FileInfo *file);
void *ThreadedMassiveComplete(FileInfo *file);
BOOL ExpandPath(char *path, int path_max);
BOOL CreatePath(const char *path);

#endif
