/* Gnome Darxite Control
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

/* Main function and Session Management */

#include <signal.h>

#include "global.h"
#include "main.h"
#include "control-page.h"
#include "batch-status.h"
#include "file-log.h"
#include "functions.h"
#include "preferences.h"
#include "../common/dnd.h"
#include "../common/callbacks.h"
#include "../common/connect.h"
#include "../common/prefs-daemon.h"
#include "../common/prefs-dnd.h"

static void add_control_batch_child_cb (GtkWidget *obj, gpointer type);
static void add_control_filelog_child_cb (GtkWidget *obj, gpointer type);
//#ifdef DEBUG_CODE
//static void add_view_cb (void);
//#endif

void customize_app_cb(GnomeMDI *mdi, GnomeApp *app);
void update_app_cb(GnomeMDI *mdi, GnomeMDIChild *mdi_child);


/* Menu definitions */
static GnomeUIInfo new_window_menu[]= {
//#ifdef DEBUG_CODE
//  GNOMEUIINFO_ITEM_NONE(N_("Add View"),
//     N_("Add a new view of the current child"),
//     add_view_cb),
//#endif
  GNOMEUIINFO_ITEM_STOCK(N_("Batch Status"),
     N_("New Batch Status window"),
     add_control_batch_child_cb, GNOME_STOCK_MENU_EXEC),
  GNOMEUIINFO_ITEM_STOCK(N_("History"),
     N_("New History window"),
     add_control_filelog_child_cb, GNOME_STOCK_MENU_BOOK_OPEN),
  GNOMEUIINFO_END
};

static GnomeUIInfo file_menu[]= {
  GNOMEUIINFO_SUBTREE(_("New Window"), new_window_menu),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_NEW_ITEM(N_("New download..."),
     N_("Show the download window"), pop_window_d, NULL),
//  GNOMEUIINFO_MENU_NEW_ITEM(N_("New upload..."),
//     N_("Show the download window"), pop_window_u, NULL),
//  GNOMEUIINFO_MENU_NEW_ITEM(N_("New advanced..."),
//     N_("Show the download window"), pop_window_a, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_NONE(N_("Local Daemon"),
     N_("Connect to a local daemon"), local_connection_cb),
  GNOMEUIINFO_ITEM_NONE(N_("Remote Daemon..."),
     N_("Connect to a remote daemon"), remote_connection_cb),
  GNOMEUIINFO_ITEM_NONE(N_("Disconnect"),
     N_("Disconnect from the daemon"), DisconnectClient),
//  GNOMEUIINFO_SEPARATOR,
//  GNOMEUIINFO_ITEM_NONE(N_("Import List..."),
//     N_("Import a List of files"), NULL),
//  GNOMEUIINFO_ITEM_NONE(N_("Export List..."),
//     N_("Export a List of files"), NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM(quit_cb, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo edit_menu[]= {
  GNOMEUIINFO_MENU_SELECT_ALL_ITEM(select_all_cb, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo programs_menu[]= {
  GNOMEUIINFO_ITEM_STOCK(N_("Control Centre"),
     N_("Darxite Daemon Configuration"),
     control_centre_cb, GNOME_STOCK_MENU_PREF),
  { 
    GNOME_APP_UI_ITEM,
    N_("Noct FTP"), N_("Run Noct FTP"),
    run_noctftp_cb, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType)0, NULL
  },
  { 
    GNOME_APP_UI_ITEM,
    N_("dx FTP"), N_("Command line FTP"),
    run_dxftp_cb, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType)0, NULL
  },
  { 
    GNOME_APP_UI_ITEM,
    N_("darxite status"), N_("Status of files being downloaded"),
    run_dsgtk_cb, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType)0, NULL
  },
  { 
    GNOME_APP_UI_ITEM,
    N_("darxite monitor"), N_("darxite monitor applet"),
    run_darxite_monitor_cb, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType)0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK(N_("Start Darxite Daemon"),
     N_(" "),
     start_stop_daemon_cb, GNOME_STOCK_MENU_TIMER),
  GNOMEUIINFO_ITEM_STOCK(N_("Stop Darxite Daemon"),
     N_(" "),
     start_stop_daemon_cb, GNOME_STOCK_MENU_TIMER_STOP),
  GNOMEUIINFO_END
};


static GnomeUIInfo preferences_menu[]=
{
  GNOMEUIINFO_MENU_PREFERENCES_ITEM(prefs_cb, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo help_menu[]=
{
/*
  GNOMEUIINFO_HELP("darxite-control"),
*/
  GNOMEUIINFO_MENU_ABOUT_ITEM(about_cb, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo windows_menu[] = {
  GNOMEUIINFO_MENU_CLOSE_WINDOW_ITEM(remove_child_cb, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_END
};


/****************************************************************/

static GnomeUIInfo main_menu[]= 
{
  GNOMEUIINFO_MENU_FILE_TREE(file_menu),
  GNOMEUIINFO_MENU_EDIT_TREE(edit_menu),
  GNOMEUIINFO_SUBTREE(N_("Programs"), programs_menu),
  GNOMEUIINFO_MENU_SETTINGS_TREE(preferences_menu),
  GNOMEUIINFO_MENU_WINDOWS_TREE(windows_menu),
  GNOMEUIINFO_MENU_HELP_TREE(help_menu),
  GNOMEUIINFO_END
};


/****************************************************************/

/* Toolbar definitions */
static GnomeUIInfo main_toolbar[] = {
    GNOMEUIINFO_ITEM_STOCK (N_("New"),
			    N_ ("Show the download window"),
			    pop_window_d, GNOME_STOCK_PIXMAP_NEW),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Play"), 
			    N_ ("Play"),
			    play_cb, GNOME_STOCK_PIXMAP_FORWARD),
    GNOMEUIINFO_ITEM_STOCK (N_ ("Pause"), 
			    N_ ("Pause"),
			    pause_cb, GNOME_STOCK_PIXMAP_PAUSE),
    GNOMEUIINFO_ITEM_STOCK (N_ ("Cancel"),
			    N_ ("Cancel"),
			    cancel_cb, GNOME_STOCK_PIXMAP_STOP),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Get Again"),
			    N_ ("Get Again"),
			    reget_cb, GNOME_STOCK_PIXMAP_REFRESH),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Clear List"),
			    N_ ("Clear List"),
			    clear_list_cb, GNOME_STOCK_PIXMAP_CLEAR),
    GNOMEUIINFO_ITEM_STOCK (N_ ("Clear Log"),
			    N_ ("Clear Log"),
			    clear_log_cb, GNOME_STOCK_PIXMAP_TRASH),
			    
/*
    GNOMEUIINFO_ITEM_STOCK (N_ ("Properties"),
			    N_ ("Set properties"),
			    NULL, GNOME_STOCK_PIXMAP_PROPERTIES),
*/
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Prefs"), N_ ("Preferences"), prefs_cb,
			    GNOME_STOCK_PIXMAP_PREFERENCES),
//    GNOMEUIINFO_ITEM_STOCK (N_ ("Help"), N_ ("Help"), help_cb,
//			    GNOME_STOCK_PIXMAP_HELP),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Quit"), N_ ("Quit"), quit_cb,
			    GNOME_STOCK_PIXMAP_QUIT),
    GNOMEUIINFO_END
};

static gint save_state      (GnomeClient        *client,
			     gint                phase,
			     GnomeRestartStyle   save_style,
			     gint                shutdown,
			     GnomeInteractStyle  interact_style,
			     gint                fast,
			     gpointer            client_data);

static gint die             (GnomeClient        *client,
			     gpointer            client_data);



/***********************************************************/

void flash_logo()
{
}

/***********************************************************/

static void
add_control_batch_child_cb (GtkWidget *obj, gpointer type)
{
        ControlPage *page;

	if (clists)
	{
	   show_warning(_("Batch already showed"));
	   return;
	}
		
        page = control_page_new (CONTROL_PAGE_BATCH);

        gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (page));
        gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (page));
}

static void
add_control_filelog_child_cb (GtkWidget *obj, gpointer type)
{
        ControlPage *page;

	if (flogs)
	{
	   show_warning(_("History already showed"));
	   return;
	}
        page = control_page_new (CONTROL_PAGE_FILELOG);

        gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (page));
        gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (page));
}

//#ifdef DEBUG_CODE
//static void
//add_view_cb (void)
//{
//        GnomeMDIChild *child = gnome_mdi_get_active_child (mdi);
//        if (child) gnome_mdi_add_view (mdi, child);
//}
//#endif

/************************* M A I N *************************/

int
main(int argc, char *argv[])
{
	GnomeClient *client;

	/*To begin, eat some memory :)*/
	control = g_malloc(sizeof(ControlApp));

	startup = TRUE; //we are in the startup process
	updated = FALSE; //history has not been read
	shutdown_app = FALSE;
	
	/* Initialize the i18n stuff */
//FIXME: autoconf macro
//  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
//  textdomain (PACKAGE);

	gnome_init ("darxite-control", VERSION, argc, argv);

	/* Get the master client, that was hopefully connected to the
	   session manager int the 'gnome_init' call.  All communication to
	   the session manager will be done with this master client.
	 */
	client = gnome_master_client ();
  
	/* Arrange to be told when something interesting happens.  */
	gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
		      GTK_SIGNAL_FUNC (save_state), (gpointer) argv[0]);
	gtk_signal_connect (GTK_OBJECT (client), "die",
		      GTK_SIGNAL_FUNC (die), NULL);

	create_pause_pixmap();

	mdi = GNOME_MDI(gnome_mdi_new("darxite-control", "Gnome Darxite Control"));

	/* Some initializations */
	daemon_tab_initializations();
	clists = NULL;
	batch = NULL;
	completions = NULL;

        gnome_mdi_set_menubar_template(mdi, main_menu);
        gnome_mdi_set_toolbar_template(mdi, main_toolbar);

        gnome_mdi_set_child_menu_path(mdi, _("File"));
        gnome_mdi_set_child_list_path(mdi, GNOME_MENU_WINDOWS_PATH);
 
	gtk_signal_connect(GTK_OBJECT(mdi), "destroy",
		            GTK_SIGNAL_FUNC(cleanup_cb), NULL);
        gtk_signal_connect(GTK_OBJECT(mdi), "remove_child",
					GTK_SIGNAL_FUNC(remove_child_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(mdi), "app_created",
					GTK_SIGNAL_FUNC(customize_app_cb), NULL);

//FIXME: Perhaps I should bind this later... yes, after the startup process
//	 is finished, so then check if history is the active child (and read
//	 file-log) or wait for a child_changed signal, and then I need only
//	 to check for the update (should be history_up_to_date) to read it.
	gtk_signal_connect(GTK_OBJECT(mdi), "child_changed",
					GTK_SIGNAL_FUNC(update_app_cb), NULL);

	/* Darxite Daemon */
        g_print("Gnome Darxite Control %s by %s, linked against Darxite %s (%s)\n",
          	 GDCONTROL_VERSION, AUTHOR, RELEASE_VER, RELEASE_NAME);
        connected = FALSE;	//We will try this later
        DX_ReadConfigFiles(); /* Read .darxiterc values :) */
	sprintf(TargetDir, "%s/", DX_OutputDir); /* Always use it the first time */
        darxite_client = "darxite-control"; //This is the client to connect :)

	/* End Darxite Daemon */

	load_configuration();

	gnome_mdi_set_mode((GnomeMDI *)mdi, mdi_mode);

//FIXME: Put this stuff in load_configuration();

	gnome_config_push_prefix("darxite-control/");
	restarted = gnome_mdi_restore_state (mdi, "Session",
	   (GnomeMDIChildCreator)control_page_create_from_config);
	gnome_config_pop_prefix ();

        if (!restarted)
	{
	   gnome_mdi_open_toplevel(mdi);
	   
	   add_control_batch_child_cb (NULL, NULL);
	   add_control_filelog_child_cb (NULL, NULL);
	   gnome_mdi_set_active_view(mdi,
		GNOME_MDI_CHILD((GnomeMDI *)mdi->children->data)->views->data);	
	}

	/*Configure Menus*/
	update_menus();

// Configure needed SIGNALS
	if (signal(SIGPIPE, SIG_IGN) == SIG_ERR)
            g_error("Can''t ignore signal SIGPIPE");

	// Connection Configuration...
	if (startup_connect)
	{
	   local = startup_local;

	   if (startup_local)
	   {
	      //connect to local daemon!
	      local_connection_cb();
	   }
	   else //startup_local == FALSE ==> startup_remote :)
	   {
	      //connect to remote daemon!
	      if (remote_connection(host, port, password))
	         gnome_app_flash(mdi->active_window,
	            "Remote daemon connection failed!");

	      if (!connected && retry_connect_remote)
	         retry_connect_timeout = gtk_timeout_add
				(retry_timeout_remote*1000, retry_connect_cb, NULL);
	   }
	}

//FIXME: This was to solve problems with the unstable branch of gnome-libs
//	GTK_WINDOW(control->app)->use_uposition = FALSE;
//	GTK_WINDOW(control->app)->handling_resize = FALSE;

	startup = FALSE; //startup process finished, now the main loop...

	gtk_main();	

	DisconnectClient();

	return 0;
}

/********************** E N D  M A I N ***********************/


/* Session management */

static gint
save_state (GnomeClient        *client,
	    gint                phase,
	    GnomeRestartStyle   save_style,
	    gint                shutdown,
	    GnomeInteractStyle  interact_style,
	    gint                fast,
	    gpointer            client_data)
{
  gchar *prefix= gnome_client_get_config_prefix (client);
  gchar *argv[]= { "rm", "-r", NULL };


  /* Save the state using gnome-config stuff. */
	gnome_config_push_prefix (prefix);

	gnome_mdi_save_state(mdi, "Session");

	gnome_config_pop_prefix ();
	gnome_config_sync();

  /* Here is the real SM code. We set the argv to the parameters needed
     to restart/discard the session that we've just saved and call
     the gnome_session_set_*_command to tell the session manager it. */
  argv[2]= gnome_config_get_real_path (prefix);
  gnome_client_set_discard_command (client, 3, argv);

  /* Set commands to clone and restart this application.  Note that we
     use the same values for both -- the session management code will
     automatically add whatever magic option is required to set the
     session id on startup.  */
  argv[0]= (gchar*) client_data;
  gnome_client_set_clone_command (client, 1, argv);
  gnome_client_set_restart_command (client, 1, argv);

  return TRUE;
}


static gint
die (GnomeClient        *client,
     gpointer            client_data)
{
  /* Just exit in a friendly way.  We don't need to save any state
     here, because the session manager should have sent us a
     save_yourself-message before.  */

	DisconnectClient();
	
	gtk_exit (0);

	return FALSE;
}

void
customize_app_cb(GnomeMDI *mdi, GnomeApp *app)
{
        GtkWidget *appbar;
	GtkWidget *power_button;
	GtkWidget *hbox;
	GtkWidget *files_button;
	GtkWidget *files_label;
        static GtkTargetEntry drop_types [] = {
           	{ "text/uri-list", 0, TARGET_URI_LIST },
                { "x-url/http",    0, TARGET_NETSCAPE_URL },
                { "x-url/ftp",     0, TARGET_NETSCAPE_URL },
                { "_NETSCAPE_URL", 0, TARGET_NETSCAPE_URL },
        };
        static gint n_drop_types = sizeof (drop_types) / sizeof(drop_types[0]);

        gtk_drag_dest_set (GTK_WIDGET(app), GTK_DEST_DEFAULT_MOTION |
       		   GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
                   drop_types, n_drop_types, GDK_ACTION_COPY);
        gtk_signal_connect (GTK_OBJECT(app), "drag_data_received",
           		    GTK_SIGNAL_FUNC (drag_data_received), NULL);

	control->app = app;
        appbar = gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_USER);
        gnome_app_set_statusbar(app, appbar);
        control->appbar = GNOME_APPBAR(appbar);
        control->progress = GTK_PROGRESS(GNOME_APPBAR(appbar)->progress);
	gtk_progress_set_show_text(GTK_PROGRESS(control->progress), TRUE);
	gtk_progress_set_format_string(GTK_PROGRESS(control->progress),
		"Not connected");
	
        power_button = gtk_button_new();
        gtk_button_set_relief(GTK_BUTTON(power_button), GTK_RELIEF_NONE);
	gtk_widget_set_usize(GTK_WIDGET(power_button), 25, 10);
       	gtk_box_pack_start (GTK_BOX(appbar), power_button, FALSE, TRUE, 0);
        gtk_box_reorder_child (GTK_BOX(appbar), power_button, 2);
        gtk_signal_connect(GTK_OBJECT(power_button), "clicked",
	       		GTK_SIGNAL_FUNC (start_stop_daemon_cb), NULL);
        gtk_widget_show(power_button);

	hbox = gtk_hbox_new(TRUE, 0);
       	gtk_container_add (GTK_CONTAINER(power_button), hbox);
        gtk_widget_show(hbox);

        pixmap_green = gnome_stock_new_with_icon(GNOME_STOCK_BUTTON_YES);
//	pixmap_green = gnome_stock_pixmap_widget_at_size
//					(NULL, GNOME_STOCK_BUTTON_YES, 20, 20);
       	gtk_box_pack_start (GTK_BOX(hbox), pixmap_green, FALSE, TRUE, 0);
        pixmap_red = gnome_stock_new_with_icon(GNOME_STOCK_BUTTON_NO);
//	pixmap_red = gnome_stock_pixmap_widget_at_size
//					(NULL, GNOME_STOCK_BUTTON_NO, 20, 20);
       	gtk_box_pack_start (GTK_BOX(hbox), pixmap_red, FALSE, TRUE, 0);

	if (connected)
		gtk_widget_show(pixmap_green);
	else
		gtk_widget_show(pixmap_red);

	files_button = gtk_button_new();
        gtk_button_set_relief(GTK_BUTTON(files_button), GTK_RELIEF_NONE);
//	gtk_widget_set_usize(GTK_WIDGET(files_button), 130, 0);
       	gtk_box_pack_start (GTK_BOX(appbar), files_button, FALSE, TRUE, 0);
        gtk_signal_connect(GTK_OBJECT(files_button), "clicked",
	       		GTK_SIGNAL_FUNC (run_dsgtk_cb), NULL);
        gtk_widget_show(files_button);
        
        files_label = gtk_label_new(" Trans. - of - files ");
       	gtk_container_add (GTK_CONTAINER(files_button), files_label);
        gtk_widget_show(files_label);

	control->files_label = files_label;
	
	{
/*
	GtkWidget *label;
	GtkWidget *proc;
	guint val[10] = {100, 100, 80, 80, 60, 60, 40, 40, 20, 0};
	
	label = gtk_label_new(_("Activity: "));
        gtk_widget_show(label);
	proc = gnome_proc_bar_new(label, 1, &White, NULL);
	gtk_box_pack_start (GTK_BOX(bar), proc, FALSE, TRUE, GNOME_PAD);
	gtk_widget_set_usize(GTK_WIDGET(proc), 200, 0);
	gnome_proc_bar_set_values((GnomeProcBar *)proc, val);
        gtk_widget_show(proc);
*/
	}
        gtk_widget_show(appbar);

        gnome_app_install_menu_hints(app, gnome_mdi_get_menubar_info(app));

	/*Configure Toolbar*/
	{
        	GnomeUIInfo *uiinfo_toolbar;

		uiinfo_toolbar = gnome_mdi_get_toolbar_info(app);
		control->toolbar = GTK_TOOLBAR(uiinfo_toolbar->widget->parent);
		gtk_toolbar_set_style(GTK_TOOLBAR(control->toolbar),
					  			toolbar_mode);
	}

/*	toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, toolbar_mode);
	gtk_widget_show(GTK_WIDGET(toolbar));
	gnome_app_fill_toolbar(GTK_TOOLBAR(toolbar), main_toolbar, NULL);
	gnome_app_add_toolbar (app, GTK_TOOLBAR(toolbar), "main_toolbar",
			GNOME_DOCK_ITEM_BEH_EXCLUSIVE, GNOME_DOCK_TOP, 1, 1, 1);
*/

	gnome_preferences_set_statusbar_dialog(FALSE);

}

void
save_configuration()
{
   	gnome_config_push_prefix("darxite-control/");

        gnome_config_set_int("options/show_flash", show_flash);

//FIXME: put this two options in "Daemon"
        gnome_config_set_int("daemon/autostart_daemon", autostart_daemon);
        gnome_config_set_string("daemon/flags", flags);

	gnome_config_set_int("Appearance/MDI_Mode", mdi_mode);
	gnome_config_set_int("Appearance/TOOLBAR_Mode", toolbar_mode);

	gnome_config_set_int("History/Read", history_read);

	dnd_tab_save_config();
	daemon_tab_save_config();

//FIXME: We also need default_host, default_port, etc...
	gnome_config_set_string("Daemon/host", host);
	gnome_config_set_int("Daemon/port", port);
//FIXME: I think we don't want this:
//	gnome_config_set_string("Daemon/password", password);

/*FIXME: needs to be done here and in save state?*/
	gnome_mdi_save_state(mdi, "Session");

   	gnome_config_pop_prefix();
        gnome_config_sync();
        gnome_config_drop_all();
}

void
load_configuration()
{
  	gnome_config_push_prefix("darxite-control/");

        show_flash = gnome_config_get_int("options/show_flash=1");

        autostart_daemon = gnome_config_get_int("daemon/autostart_daemon=0");
        strcpy(flags, gnome_config_get_string("daemon/flags=PrSmB"));

	mdi_mode = gnome_config_get_int("Appearance/MDI_Mode=42");
	toolbar_mode = gnome_config_get_int("Appearance/TOOLBAR_Mode=2");

	history_read = gnome_config_get_int("History/Read=0");

	dnd_tab_load_config();
	daemon_tab_load_config();

//FIXME: We also need default_host, default_port, etc...
	host = gnome_config_get_string("Daemon/host=localhost");
	port = gnome_config_get_int("Daemon/port=5678");
//FIXME: We haven't saved any password, so set it to ""
	password = "";

   	gnome_config_pop_prefix();
}

void update_app_cb(GnomeMDI *mdi, GnomeMDIChild *child)
{
	if (child == NULL)
	   return;

	update_menus();

//FIXME: VERY ugly, I'll remake this when I have the time.
	if ((CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_FILELOG) &&
		((!startup) && (!updated)) && (!shutdown_app))
	{
//FIXME: Show a sorry dialog ;) so we can parse while user reads :D
	   GtkWidget *window;
	   GtkWidget *label;
	   
	   window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	   gtk_container_set_border_width (GTK_CONTAINER (window), 10);
	   label = gtk_label_new("Reading the history file\nplease wait...");
       	   gtk_container_add (GTK_CONTAINER(window), label);
	   gtk_widget_show(label);
	   gtk_widget_show(window);
	   if (gtk_events_pending())
	      gtk_main_iteration();
	   parse_logfile(CONTROL_PAGE(mdi->active_child)->main_widget);
	   updated = TRUE;
	   gtk_widget_destroy(window);
	}
	
#ifdef DEBUG_MESSAGES
	g_print("Child changed signal received!\n");
#endif
}






