/*
 * Undo the packetizing of messages on 163.35 MHz
 * in order to feed the kd9kx afosd.
 */
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<string.h>
#include<signal.h>
#include<ctype.h>
#include<syslog.h>
#include"version.h"

int fserial_port_setup(FILE *fp,char *settings);
int serial_port_setup(int fd,char *settings);

typedef struct {
  char header[82];
  char filename[13];
  int  pn; /* This is part pn */
  int  pt; /* of pt parts */
  unsigned short checksum;
  unsigned short ourchecksum;
  char timestamp[80];
  unsigned char body[1024];
} emwindata;

struct {
  int good;
  int bad;
} emwin;

int
scanhdr(FILE *emwinstream,emwindata *pd)
{
  char *chp;
  int i;

  while(1) {
    chp = pd->header;
    *chp = fgetc(emwinstream);
    if (*chp == '/') {
      chp++;
      *chp = fgetc(emwinstream);
      if (*chp == 'P') {
	chp++;
	*chp = fgetc(emwinstream);
	if (*chp == 'F') {
	  for(i=3; (i<80)&&(*chp!=0x0A); i++) {
	    chp++;
	    *chp = fgetc(emwinstream);
	    /*printf("%2d: %2X %c\n",i,*chp,*chp);*/
	  }
	  chp++; *chp=0;
	  sscanf(pd->header,"%*3c%12c%*3c %d %*3c %d %*3c %7hu/FD%20c",
		 pd->filename,&(pd->pn),&(pd->pt),&(pd->checksum),
		 pd->timestamp);
	  pd->filename[12]=0; pd->timestamp[20]=0;
	  for (i=0; i<12; i++)
	    if (!(isalnum(pd->filename[i]) || pd->filename[i] == '.'))
		    pd->filename[i]='_';  /* Squash non-printable filenames */
	  return(1); /* Header ended with linefeed, maybe valid? */
	}
      }
    }
  }
  return(0);
}

int
readpkt(FILE *emwinstream, emwindata *pd)
{
  int i;
  unsigned char *chp;
  unsigned short checksum;

  checksum=0;
  /* We seem to have no nulls, and noise, .... so this won't work 
  cnt = fread(pd->body,1,1024,emwinstream);
  if (cnt!=1024) {
    printf("Error reading packet body\n");
    return(1);
  }
  */

  chp = (unsigned char *) pd->body;
  for (i=0;i<1024;i++) {
    *chp = fgetc(emwinstream);
    if (*chp == '/') {
      chp++;
      *chp = fgetc(emwinstream);
      if (*chp == 'P') {
	chp++;
	*chp = fgetc(emwinstream);
	if (*chp == 'F') {
	    ungetc(*chp,emwinstream); chp--; /* put back F */
	    ungetc(*chp,emwinstream); chp--; /* put back P */
	    ungetc(*chp,emwinstream); chp--; /* put back / */
	    /* printf("%d byte checksum: %d\n",i,checksum);*/
	    pd->ourchecksum=checksum;
	    return(i); /* return body byte count */
	}
      }
    }
    checksum += *chp;
    chp++;
  }
  pd->ourchecksum=checksum;
  return(i);
}

/* This one's for catching signals */
void
time_to_die(int why)
{
  /* Before quitting, clean up our act....*/
  printf("Time_to_Die called (%d)\n",why);
  printf("Processed %d valid packets, %d invalid packets\n",emwin.good,emwin.bad);
  exit(0);
}

/* Reads an EMWIN QBT packet from the datastream
   Returns 0 if successful. */
int
getserpacket(const int s, const struct QBT *qbtpacket)
{
  return(0);
}

int
main(int argc,char *argv[])
{
  int length;
  emwindata pkt;
  FILE *fp, *datastream;
  char logname[80];
  pid_t pid;

  /* Signal Handling */
  signal(SIGQUIT, time_to_die);
  signal(SIGINT, time_to_die);

  if (argc<2)
	  datastream = stdin;
  else {
    datastream = fopen(argv[1],"r");
    if (!datastream) { perror(argv[1]); return(1); }
    if (argc>2) fserial_port_setup(datastream,argv[2]);

    if((pid=fork()) < 0) {
	    perror("Can't fork daemon process");
	    exit(EXIT_FAILURE);
    }
    else if (pid != 0) exit(EXIT_SUCCESS); /* Parent goes bye-bye */

    /* Child continues */

    /* become session leader */
    if (setsid() < 0) {
	    perror("main, setsid");
	    exit(EXIT_FAILURE);
    }
    openlog("emwind",LOG_PID,LOG_USER);
    syslog(LOG_INFO,"EMWIN serial receiver daemon starting");
  }

  emwin.good=0; emwin.bad=0;
  while(1) {
    if(scanhdr(datastream,&pkt)) {
#ifdef DEBUG
      printf("%s %d/%d\t(%hu)\t%s\n",
	     pkt.filename,pkt.pn,pkt.pt,pkt.checksum,pkt.timestamp);
#endif
      length = readpkt(datastream,&pkt);

      if (pkt.checksum==pkt.ourchecksum)
	emwin.good++;
      else
	emwin.bad++;

      /*if (length==0) break; */
#ifdef DEBUG
      if (strstr(pkt.filename,".TXT")) {
	fwrite(pkt.body,length,1,stdout);
	printf("\n");
      }
#endif
      if (pkt.ourchecksum==pkt.checksum) {
      sprintf(logname,"%s",pkt.filename);
      fp = fopen(logname,"w");
      fseek(fp,1024*(pkt.pn-1),SEEK_SET);
      fwrite(pkt.body,length,1,fp);
      fclose(fp);
      sprintf(logname,"%s.stat",pkt.filename);
      fp = fopen(logname,"a");
      fprintf(fp,"%s %d/%d\t(%hu,%hu)\t%s\n",
	     pkt.filename,pkt.pn,pkt.pt,pkt.checksum,pkt.ourchecksum,
	     pkt.timestamp);      
      fclose(fp);
      }
    }
  }
    
  return(0);
}
