;; chasen.el
;;
;; Author: Masanao Izumo <masana-i@is.aist-nara.ac.jp>
;;         Keiji Yonezawa <keiji-y@is.aist-nara.ac.jp>
;;         Akira Kitauchi <akira-k@is.aist-nara.ac.jp>
;; Create: Mon Jan 27 1997
;; Last modify: Sun May 18 1997
;; Version: 1.3
;;
;; Description
;;
;; chasen.el ϡ䥥Ф̿뤿 Mule ѤΥ饤֥Ǥ
;; chasen.el Ѥˤϡ䥥ФΥۥ̾ȥݡֹꤷ
;; Ѥؿ˱ autoload λԤäƲ
;; 
;; (setq chasen-server-host "kyusu")
;; (setq chasen-server-port 31234)    ; ǥեȤ 31000
;;
;; (autoload 'chasen-region "chasen" "ChaSen client" t)
;; (autoload 'chasen-line "chasen" "ChaSen client" t)
;; (autoload 'chasen-highlight-class-region "chasen" "ChaSen client" t)
;; (autoload 'chasen-property-class-region "chasen" "ChaSen client" t)
;;
;; ʴؿʲ˼ޤ
;;
;; chasen-region start end &optional arg
;; ȥХåե start  end ǥ꡼ꤵ줿ƥȤ
;; Ϥ*Chasen Network* Хåե˲Ϸ̤ɽޤ
;;
;; chasen-line &optional arg
;; ȥХåեΥȹԤΥƥȤϤ*Chasen Network* Х
;; ե˲Ϸ̤ɽޤ
;;
;; chasen-highlight-class-region start end
;; ȥХåե start  end ǥ꡼ꤵ줿ƥȤ
;; Ϥʻ줴Ȥ˿ʬ򤷤ޤ
;;
;; chasen-property-class-region start end
;; : δؿϥȥХåեƤѹޤ
;; ȥХåե start  end ǥ꡼ꤵ줿ƥȤ
;; Ϥʻ줴Ȥ˿ʬ򤷤ޤchasen-highlight-class-region 
;; äơݥȰ֤դȤäƤȡߥ˥Хåե
;; ˤʻʬɽޤ
;;
;; chasen-open-connection
;; 䥥Ф³ޤ³ۥȤ TCP ݡֹϡѿ
;; chasen-server-host, chasen-server-port ˻ꤷޤ
;; ³ȡchasen-server ˥ͥåȥץꤷ
;; ֤ͤޤˡ³ƤСñ³Ƥ
;; ͥåȥץ֤Ǥ
;; Mule λȡ䥥ФȤ³ϼưŪڤޤ
;;
;; chasen-close-connection
;; 䥥ФȤ³ڤޤ(FIXMEХåե kill 줿Ȥ˥Х)
;;
;; chasen-send-command &rest args
;; ޥɤϤޤ̤ϡХåե chasen-network-buffer-name 
;; Ϥޤ
;;
;; chasen-run text &optional format
;; 䥥Ф˥ƥ text ꡢη̤ʸΥꥹȤȤ֤ޤ
;; 䥥Ф³ƤʤС³ޤ
;; text ϡ䥤Τ˽Ǥ褦ˡưŪƤ顢Ф
;; ޤ
;; format ˤϡ̤η򵭽Ҥޤܤϡchasen ޥɤ -F
;; ץ򻲾ȤƤformat άȡ"%m" Ʊ̤
;; ʤޤ
;;
;; chasen-scan-region start end fn &optional format
;; ȥХåե start  end ǥ꡼ꤵ줿ƥȤ
;; chasen-run ϤβϷ̤򸵤ˡХåե򥹥󤷤ޤ
;; б֤κǸ˥ݥ󥿤ưǡؿ fn ƤӽФޤ
;; ϡñλϤޤ֡ñνλ֡Ϸ̤ΣǸƤӽФޤ
;;

(defvar chasen-server-host "localhost")
(defvar chasen-server-port 31000)

(defvar chasen-network-buffer-name "*Chasen Network*")
(defvar chasen-proc-name "*Chasen*")
(defvar temp-buffer-name " *Temporary Buffer*")
(defvar chasen-server nil)
(defvar chasen-default-format "%m\\n")

(defvar chasen-default-class-table
;;   class-name  class-type     fg              bg
  '(("ư"   . (verb          "white"         "black"))
    ("ƻ" . (adj           "springgreen"   "black"))
    ("Ƚ" . (assert        "orange"        "black"))
    ("ư" . (aux           "tomato"        "black"))
    ("̾"   . (noun          "cyan"          "black"))    
    ("ؼ" . (demonstrative "orchid"        "black"))
    (""   . (adverb        "yellow"        "black"))
    (""   . (postp         "rosybrown1"    "black"))
    ("³" . (conjunction   "pink"          "black"))
    ("Ϣλ" . (adnoun        "brown"         "black"))
    ("ư" . (interjection  "gray"          "black"))
    ("Ƭ" . (prefix        "seagreen"      "black"))
    ("" . (postfix       "lightskyblue3" "black"))))



(defun chasen-type-face-name (type)
  (let (face)
    (setq face (intern (concat "chasen-" (symbol-name type) "-face")))
    (if (boundp face)
	(symbol-value face)
      face)))

(if (not (fboundp 'facep))
  (defun facep (f)
    (if (memq f (face-list)) t)))

;; chasen-*-face ν
;; chasen-face-table ν
(let (face type fg bg)
  (setq chasen-face-table nil)
  (mapcar (function (lambda (class)
		      (setq type (nth 0 (cdr class))
		            fg   (nth 1 (cdr class))
			    bg   (nth 2 (cdr class)))
		      (setq face (chasen-type-face-name type))
		      (setq chasen-face-table
			    (cons (cons type face) chasen-face-table))
		      (if (facep face)
			  nil
			(copy-face 'default face)
			(set-face-foreground face fg)
			(set-face-background face bg))))
	  chasen-default-class-table))

;;
;; property
;;
(defun chasen-property-class-region (start end)
  (interactive "r")
  (let (class type face)
    (chasen-unhighlight-region start end)
    (set-text-properties start end nil)
    (chasen-scan-region
     start end
     (function (lambda (start end arg)
		 (setq arg (chasen-split-space arg))
		 (setq class (assoc (car arg) chasen-default-class-table))
		 (setq face
		       (if class
			   (cdr (assq (car (cdr class)) chasen-face-table))))
		 (chasen-set-property-region face start end (car (cdr arg)))))
     "%H %BM\\n")))

(defun chasen-set-property-region (face start end msg)
  (let ((props (list 'face          face
		     'point-entered 'chasen-prop-point-enterd
;		     'point-left    'chasen-prop-point-left
		     'chasen-class msg)))
    (set-text-properties start end props)))

(defun chasen-prop-point-enterd (prev cur)
  (let ((msg (get-text-property cur 'chasen-class)))
;    (message "%s %s %s" prev cur msg)))
    (message msg)))
;(defun chasen-prop-point-left (prev cur))

;;
;; highlighting
;;
(defun chasen-highlight-class-region (start end)
  (interactive "r")
  (let (class type)
    (chasen-unhighlight-region start end)
    (set-text-properties start end nil)
    (chasen-scan-region
     start end
     (function (lambda (start end arg)
		 (setq class (assoc arg chasen-default-class-table))
		 (if class
		     (progn
		       (setq type (car (cdr class)))
		       (chasen-highlight-region
			(cdr (assq type chasen-face-table))
			start end type)))))
     "%H\\n")))

(defun chasen-highlight-scan-region (start end class face &optional type)
  (chasen-unhighlight-region start end type)
  (chasen-scan-region
   start end
   (function (lambda (start end arg)
	       (if (string= arg class)
		   (chasen-highlight-region face start end type))))
   "%H\\n"))

(defun chasen-highlight-region (face start end &optional type)
  (let ((overlay (make-overlay start end)))
    (overlay-put overlay 'face face)
    (if type
	(overlay-put overlay 'chasen type))
    ))

(defun chasen-unhighlight-region (start end &optional type)
  (while (progn
	   (mapcar (function (lambda (ovr)
			       (if type
				   (if (eq (overlay-get ovr 'chasen) type)
				       (delete-overlay ovr))
				 (delete-overlay ovr))))
		   (overlays-at start))
	   (setq start (next-overlay-change start))
	   (< start end))))

(defun chasen-scan-region (start end fn &optional format)
  (let (words w word warg pos)
    (if format
	(setq format (concat "%m " format))
      (setq format chasen-default-format))
    (setq words (chasen-run (buffer-substring start end) format))
    (goto-char start)
    (skip-chars-forward " \t\n")
    (setq pos (point))
    (while words
      (setq w (car words))
      (string-match "\\([^ ]+\\) ?\\(.*\\)" w)
      (setq word (substring w (match-beginning 1) (match-end 1))
	    warg (substring w (match-beginning 2) (match-end 2)))
      (chasen-scan-region-1 word)
      (funcall fn pos (point) warg)
      (skip-chars-forward " \t\n")
      (setq pos (point))
      (setq words (cdr words)))))

(defun chasen-scan-region-1 (word)
  (if (looking-at (regexp-quote word))
      (goto-char (+ (point)  (length word)))
    (mapcar (function (lambda (c) (search-forward c)))
	    (chasen-split-chars word))))

(defun chasen-join-string (sep strings)
  (apply 'concat (chasen-join-list sep strings)))

(defun chasen-join-list (sep list)
  (let ((ret nil))
    (if (null list)
	nil
      (while list
	(setq ret (cons (car list)  (cons sep ret)))
	(setq list (cdr list)))
      (cdr (nreverse ret)))))

(defun chasen-split-chars (string)
  (let (ret end1 end2 reg)
    (while (string-match "\\(.\\)\\(.\\)" string)
      (setq end1 (match-end 1))
      (setq end2 (match-end 2))
      (setq ret (cons (substring string end1 end2)
		      (cons (substring string 0 end1)
			    ret)))
      (setq string (substring string end2)))
    (or (string= "" string)
	(setq ret (cons string ret)))
    (nreverse ret)))

;(defun chasen-split-chars (string)
;    (save-excursion
;      (let (chars)
;	(set-buffer (get-buffer-create temp-buffer-name))
;	(erase-buffer)
;	(insert string)
;	(goto-char (point-min))
;	(while (not (eobp))
;	  (setq chars (cons (following-char) chars))
;	  (forward-char 1))
;	(mapcar (function (lambda (c) (char-to-string c)))
;		(nreverse chars)))))

(defun chasen-split-space (string)
  (let (ret)
    (save-excursion
      (set-buffer (get-buffer-create temp-buffer-name))
      (erase-buffer)
      (insert string)
      (goto-char (point-min))
      (while (re-search-forward "[^ ]+" nil t)
	(setq ret (cons (buffer-substring (match-beginning 0) (match-end 0))
			ret)))
      (nreverse ret))))

(defun chasen-run (text &optional format remain-EOS)
  (save-excursion
    (chasen-open-connection)
    (set-buffer chasen-network-buffer-name)
    (erase-buffer)
    (if format
	(chasen-send-command "RUN" "-F" (chasen-escape-space format))
      (chasen-send-command "RUN"))
    (process-send-string chasen-server (chasen-escape-dot
					(chasen-normalize-text text)))
    (chasen-send-command ".")
    (while (progn
	     (accept-process-output chasen-server)
	     (goto-char (point-min))
	     (not (re-search-forward "^[0-9].*\n" nil t))))
    (goto-char (point-min))
    (if (not (looking-at "200.*"))
	(let (err)
	  (end-of-line)
	  (setq err (buffer-substring (point-min) (point)))
	  (erase-buffer)
	  (error "%s" err)))
    (kill-line t)
    (while (not (re-search-forward "^\\.$" nil t))
      (accept-process-output chasen-server)
      (goto-char (point-min)))
    (if remain-EOS
	(chasen-split-text-lines
	 (chasen-unescape-dot (buffer-substring (point-min) (1- (point)))))
      (chasen-remove-EOS
       (chasen-split-text-lines
	(chasen-unescape-dot (buffer-substring (point-min) (1- (point)))))))))

(defun chasen-line (&optional arg)
  (interactive "P")
  (save-excursion
    (let (start end)
      (beginning-of-line)
      (setq start (point))
      (end-of-line)
      (setq end (point))
      (chasen-region start end arg))))

(defun chasen-region (start end &optional arg)
  (interactive "r\nP")
  (if arg
      (setq arg (read-from-minibuffer "Option: ")))
  (chasen-region-format start end arg))

(defun chasen-region-format (start end &optional option remain-EOS)
  (save-excursion
;  (get-buffer-create "*chasen output*")
    (let ((text (buffer-substring start end))
	  bottom)
      (chasen-open-connection)
      (set-buffer chasen-network-buffer-name)
;      (erase-buffer)
      (setq bottom (point-max))
      (if option
	  (chasen-send-command "RUN" (chasen-escape-space option))
	(chasen-send-command "RUN"))
      (process-send-string chasen-server
			   (chasen-escape-dot
			    (chasen-normalize-text text)))
      (chasen-send-command ".")

;      (while (progn
;	       (accept-process-output chasen-server)
;	       (goto-char bottom)
;	       (not (re-search-forward "^[0-9].*\n" nil t))))

      ;; wait a status message
      (accept-process-output chasen-server)
      (goto-char bottom)
      (while (not (re-search-forward "^[0-9].*\n" nil t))
	(accept-process-output chasen-server))
      (forward-line -1)
      (kill-line t)

      ;; wait "."
      (goto-char bottom)
      (while (not (re-search-forward "^\\.\n" nil t))
	(accept-process-output chasen-server))
      (forward-line -1)
      (kill-line t)

      (display-buffer chasen-network-buffer-name)
      (end-of-buffer-other-window 0)
    )))

;    (goto-char (point-min))
;    (if (not (looking-at "200.*"))
;	(let (err)
;	  (end-of-line)
;	  (setq err (buffer-substring (point-min) (point)))
;	  (erase-buffer)
;	  (error "%s" err)))
;    (kill-line t)
;    (while (not (re-search-forward "^\\.$" nil t))
;      (accept-process-output chasen-server)
;      (goto-char (point-min)))
;    (if remain-EOS
;	(chasen-split-text-lines
;	 (chasen-unescape-dot (buffer-substring (point-min) (1- (point)))))
;      (chasen-remove-EOS
;       (chasen-split-text-lines
;	(chasen-unescape-dot (buffer-substring (point-min) (1- (point)))))))))

(defun chasen-split-text-lines (text)
  (let ((lines nil) pos)
  (save-excursion
    (set-buffer (get-buffer-create temp-buffer-name))
    (erase-buffer)
    (insert text)
    (goto-char (point-min))
    (while (not (eobp))
      (setq pos (point))
      (end-of-line)
      (setq lines (cons (buffer-substring pos (point))
			lines))
      (forward-line 1)))
  (nreverse lines)))

(defun chasen-remove-EOS (lines)
  (let ((ret nil))
    (while lines
      (or (string= (car lines) "EOS")
	  (setq ret (cons (car lines) ret)))
      (setq lines (cdr lines)))
    (nreverse ret)))

(defun chasen-normalize-text (text)
  (save-excursion
    (set-buffer (get-buffer-create temp-buffer-name))
    (erase-buffer)
    (insert text)

    ;; פʶκ
    (goto-char (point-min))
    (and (looking-at "[ \n\t]+")
	 (delete-region (match-beginning 0) (match-end 0)))
    (while (re-search-forward "[ \n\t]+" nil t)
      (delete-region (match-beginning 0) (match-end 0))
      (backward-char 1)
      (if (looking-at "[\041-\176][\041-\176]")
	  (progn
	    (forward-char 1)
	    (insert-char ?  1))))

    ;; ʸνǲ
    (goto-char (point-min))
    (while (re-search-forward "[]\\|\\cj\\." nil t)
      (insert-char ?\n 1))

    ;; ǸϲԤǽ뤳Ȥݾ
    (goto-char (point-max))
    (or (bolp)
	(insert-char ?\n 1))

    (buffer-string)))

(defun chasen-escape-dot (text)
  (if text
      (save-excursion
	(set-buffer (get-buffer-create temp-buffer-name))
	(erase-buffer)
	(insert text)
	(goto-char (point-min))
	(while (re-search-forward "^\\." nil t)
	  (insert-char ?. 1))
	(buffer-string))))

(defun chasen-unescape-dot (text)
  (save-excursion
    (set-buffer (get-buffer-create temp-buffer-name))
    (erase-buffer)
    (insert text)
    (goto-char (point-min))
    (while (re-search-forward "^\\.\\." nil t)
      (backward-delete-char 1))
    (buffer-string)))

(defun chasen-escape-space (text)
  (save-excursion
    (set-buffer (get-buffer-create temp-buffer-name))
    (erase-buffer)
    (insert text)
    (goto-char (point-min))
    (while (search-forward " " nil t)
      (backward-char 1)
      (insert-char ?\\ 1)
      (forward-char 1))
    (buffer-string)))

(defun chasen-open-connection ()
  (interactive)
  (if (and chasen-server
	   (null (buffer-name (process-buffer chasen-server))))	;killed buffer
      (setq chasen-server nil))
  (if chasen-server
      chasen-server
    (setq chasen-server
	  (open-network-stream chasen-proc-name
			       chasen-network-buffer-name
			       chasen-server-host
			       chasen-server-port))
    (set-process-coding-system chasen-server *euc-japan*unix *euc-japan*unix)
    (process-kill-without-query chasen-server)
    (set-buffer chasen-network-buffer-name)
    (erase-buffer)
    (while (not (looking-at "200.*\n"))
      (accept-process-output chasen-server)
      (goto-char (point-min)))
    (end-of-line)
    (message "%s" (buffer-substring (point-min) (point)))
    (goto-char (point-min))
    (kill-line t)
    chasen-server))

(defun chasen-close-connection ()
  (interactive)
  (if (not chasen-server)
      nil
    (chasen-send-command "QUIT")
    (while (eq (process-status chasen-server) 'open)
      (accept-process-output chasen-server))
    (setq chasen-server nil)
    (message "Connection closed.")))

(defun chasen-send-command (&rest args)
  (if (null args)
      nil ;; do nothing
    (process-send-string chasen-server (chasen-join-string " " args))
    (process-send-string chasen-server "\n")))

(defun chasen-read-class-type (prompt)
  (let (type)
    (while (zerop (length type))
      (setq type (completing-read prompt
				  (mapcar '(lambda (x)
					     (list (symbol-name (car (cdr x)))))
					  chasen-default-class-table)
				  nil t)))
    (intern type)))

(defun chasen-set-class-foreground (type color)
  (interactive (chasen-internal-face-interactive "foreground"))
  (set-face-background (cdr (assq type chasen-face-table)) color))

(defun chasen-set-class-foreground (type color)
  (interactive (chasen-internal-face-interactive "foreground"))
  (set-face-background (cdr (assq type chasen-face-table)) color))

(defun chasen-internal-face-interactive (what)
  (let* ((fn (intern (concat "face-" what)))
	 (prompt (concat "Set " what " of class"))
	 (type (chasen-read-class-type (concat prompt ": ")))
	 (color (read-string (concat prompt " " (symbol-name type) " to: "))))
    (list face (if (equal value "") nil value))))

(defvar chasen-format-help-string "%m    Ф(ѷ)
%M    Ф(ܷ)
%y    ɤ
%Y    ɤ(̤ʤ\"̤\"ɽ)
%i    ̣
%Ic   ̣(NILʤʸcɽ)
%h    ʻ(ֹ)
%H    ʻ(ʸ)
%b    ʻʬ(ֹ)
%BB   ʻʬ(ʸ)(ʤʻɽ)
%BM   ʻʬ(ʸ)(ʤʻޤ\"̤\"ɽ)
%Bc   ʻʬ(ʸ)(ʤʸcɽ)
%t    ѷ(ֹ)
%Tc   ѷ(ʸ)(ʤʸcɽ)
%f    ѷ(ֹ)
%Fc   ѷ(ʸ)(ʤʸcɽ)
%c    ǤΥ
%%    % Τ
.     ե
-     ե
1-9   ե
\\n    ʸ
\\t    
\\\\    \\ Τ
\\'    ' Τ
\\\"    \" Τ")

(defun chasen-yomi-region (start end)
  (interactive "r")
  (chasen-scan-region start end
		      (function (lambda (start end yomi)
				  (delete-region start end)
				  (insert yomi)))
		      "%y\\n"))

(provide 'chasen-utils)
