#!/usr/bin/perl
#  rep-txn-list.pl - Prints a report of the transactions sorted by date
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: miss-check.pl,v 1.1.1.1 1999/12/18 02:07:08 curt Exp $


package CBB;

use strict;    # don't take no guff


my($temp, $cbb_incl_dir);
my($start, $end, $last, $misstart, $misend);
my($date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total);
my($date_fmt, $todate, $fromdate, $trans, $result, $account, $name);
my(%BYCHECK, @account_list, @CHECKS);

# specify the installed location of the necessary pieces.
$CBB::cbb_incl_dir = "..";
unshift(@INC, $CBB::cbb_incl_dir);


require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || 
    die "Usage: report [ -from mm/dd/[yy]yy ] [ -to mm/dd/[yy]yy ] accounts";


# process arguments

($date_fmt, $fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

%BYCHECK = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
	($trans, $date, $check, $desc, $debit, $credit, $cat, $com,
	 $cleared, $total) = split(/\t/, $result);

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {

	    if ( $check ne "" ) {
		if ( defined($BYCHECK{$check}) ) {
		    $BYCHECK{$check} .= "\t$date";
		} else {
		    $BYCHECK{$check} = $date;
		}
	    }
	}

        $result = &next_trans();
    }
}


$last = "";
$start = "";
$end = "";

@CHECKS = (sort (keys %BYCHECK) );

while ( $check = shift(@CHECKS) ) {

    # first check for duplicate check numbers
    if ( $BYCHECK{$check} =~ m/\t/ ) {
	print " *** DUPLICATED CHECK ***  #$check ($BYCHECK{$check})\n";
	print "\n";
    }

    if ( $start eq "" ) {
	$start = $check;
    }

    if ( ($last ne "") && ($check != ($last + 1)) ) {
	# ok, we have a break in the action
	print "Continuous range #$start ($BYCHECK{$start}) - " .
	    "#$last ($BYCHECK{$last})\n\n";

	$misstart = $last + 1;
	$misend = $check - 1;
	if ( $misstart == $misend ) {
	    print " *** MISSING CHECK ***  #$misstart\n\n";
	} else {
	    print " *** MISSING CHECKS ***  #$misstart - #$misend\n\n";
	}
	$start = $check;
    }

    $last = $check;
}

if ( $start ne "" ) {
    print "Continuous range #$start ($BYCHECK{$start}) - " .
	"#$last ($BYCHECK{$last})\n\n";
}
