
#include "triage.h"
#include "render.h"
#include "lispassert.h"
#include "pixels.h"
#include "transforms.h"
#include "line2d.h"

void CTriageGraphics::DrawLine2d(int x0,int y0,int x1, int y1)
{
    CVector vv0(x0,y0,0);
    PlatPixel c0 = Pixel(0,0,0,255);
    CVector vv1(x1,y1,0);
    PlatPixel c1 = Pixel(0,0,0,255);

    CVector v0,v1;
    PlatInt xx0,yy0,zz0,xx1,yy1,zz1;
    iTriage.Transform().Transform(v0,vv0);
    iTriage.Transform().Transform(v1,vv1);

    UnFixVector(xx0, yy0, zz0, v0);
    UnFixVector(xx1, yy1, zz1, v1);
    ClampPosition<ZBuffer<AlphaBlend<WritePixel> > > pixelize(iTriage);
    ::Line(xx0, yy0, zz0, c0, xx1, yy1, zz1, c1, pixelize);
}
