

#include "interpolator.h"

void CInterpolator::Initialize(PlatInt x0, PlatInt y0, PlatInt x1, PlatInt y1)
{
    iX0=x0;
    iY0=y0;
    iX =x0;
    iY =y0;
    iX1=x1;
    iY1=y1;
    iDeltaX=x1-x0;
    iDeltaY=y1-y0;
    iStepX=1;
    iStepY=1;
    if (iDeltaX<0)
    {
        iStepX=-1;
        iDeltaX=-iDeltaX;
    }
    if (iDeltaY<0)
    {
        iStepY=-1;
        iDeltaY=-iDeltaY;
    }


    if (iDeltaX >= iDeltaY)
    {
        iNrSteps=iDeltaX+1;
        iPivot = KPivotX;

        e  = iDeltaY+iDeltaY-iDeltaX;
        e1 = e-iDeltaX;
        e2 = iDeltaY+iDeltaY;
    }
    else
    {
        iNrSteps = iDeltaY+1;
        iPivot = KPivotY;

        e  = iDeltaX+iDeltaX-iDeltaY;
        e1 = e-iDeltaY;
        e2 = iDeltaX+iDeltaX;
    }
}

void CInterpolator::Next()
{
    switch (iPivot)
    {
    case KPivotX:
        iX+=iStepX;
        if ( e > 0 )
        {
          iY += iStepY;
          e += e1;
        }
        else
        {
          e += e2;
        }
        break;
    case KPivotY:
        iY+=iStepY;

        if ( e > 0 )
        {
          iX += iStepX;
          e += e1;
        }
        else
        {
          e += e2;
        }
        break;
    }
}


