
#include <stdio.h> //@@@
#include <stdlib.h>
#include <string.h>
#include <math.h>


#include "hershey.h"

#include "fontarrays.inc"

CHersheyFont::CHersheyFont(PlatCharPtr aFontFileName)
{
    X=0;
    Y=1;

   hersheyWidth = 1;
   hersheyHeight = 1;
   hersheyLineWidth = 1;
   hersheyHorizontalAlignment = HORIZONTAL_NORMAL;
   herhseyVerticalAlignment = VERTICAL_NORMAL;
//   hersheyTheta = 0;
   hersheyItalics = 0;
   hersheyItalicSlant = 0.75f;
   characterMinX=NULL;
   characterMaxX=NULL;
   characterSpacing = 2;

   {
       int i;
       for (i=0;i<MAX_CHARACTERS;i++)
           numberOfPoints[i]=0;
   }
   
   LoadHersheyFontFromMemory (aFontFileName);
   //   LoadHersheyFont (aFontFileName);
}

CHersheyFont::~CHersheyFont()
{
    delete characterMinX;
    delete characterMaxX;
}





void CHersheyFont::LoadHersheyFontFromMemory (PlatCharPtr fontname)
{
    int character,n;
    int c;
    int xadjust = fontAdjustment (fontname);
    int pos=0;
    
    // loop through the characters in the file ...
    character = 0;

    // while we have not processed all of the characters
    while (true)
    {
        // if we cannot read the next field
        if ((n=getIntFromMemory (fontname,&pos, 5)) < 1)
        {
            // we are done, set the font specification for num chars

            charactersInSet = character;

            // break the read loop
            break;
        }
        else
        {
            // get the number of vertices in this character
            n = getIntFromMemory (fontname,&pos, 3);

            // save it
            numberOfPoints[character] = n;

            // read in the vertice coordinates ...
            for (int i = 0; i < n; i++)
            {
                // if we are at the end of the line
                /*TODO weg
                 if ((i == 32) || (i == 68) || (i == 104) || (i == 140))
                {
                    // skip the carriage return
                    pos++;
                    }
                    */
                // get the next character
                c = fontname[pos++];

                // if this is a return ( we have a DOS style file )
                if (c == '#')
                {
                    // throw it away and get another
                    c = fontname[pos++];
                }

                    // get the x coordinate
                characterVectors[character][X][i] = (char) c;

                // read the y coordinate
                characterVectors[character][Y][i] = (char) fontname[pos++];
            }

            // skip the carriage return
            pos++;

            // increment the character counter
            character++;
        }
    }
    // determine the size of each character ...

    characterMinX = new int[charactersInSet];
    characterMaxX = new int[charactersInSet];

    // initialize ...
    characterSetMinY = 1000;
    characterSetMaxY = -1000;

    // loop through each character ( except the space character )
    for (int j = 1; j < charactersInSet; j++)
    {
        // calculate the size
        calculateCharacterSize (j, xadjust);
    }

    // handle the space character - if the 'a' character is defined
    if (((int) 'a' - (int) ' ') <= charactersInSet)
    {
        // make the space character the same size as the 'a'
        characterMinX[0] = characterMinX[(int) 'a' - (int) ' '];
        characterMaxX[0] = characterMaxX[(int) 'a' - (int) ' '];
    }
    else
    {
        // make the space char the same size as the last char
        characterMinX[0] = characterMinX[charactersInSet - 1];
        characterMaxX[0] = characterMaxX[charactersInSet - 1];
    }
    return;
}

int CHersheyFont::getIntFromMemory (PlatCharPtr filename, int* pos, int n)
{
    char *buf;
    int c;
    int j = 0;

    buf = new char[n+1];

    // for the specified number of characters
    int i;
    for (i = 0; i < n; i++)
      {
          c = filename[*pos]; (*pos)++;

          // get character and discard spare newlines
          while ( ((c == '\n') || (c == '\r')) &&
                  filename[*pos] != '\0')
          {
              c = filename[*pos];(*pos)++;
          }

          // if we hit end of file
          if (filename[*pos] == '\0')
          {
              // return an error
              return (-1);
          }

          // if this is not a blank
          if ((char) c != ' ')
          {
              // save the character
              buf[j++] = (char) c;
          }
      }

    buf[j++] = '\0';
    // return the decimal equivilent of the string
    int result=0;

    if (j>1)
    {
        sscanf(buf,"%d",&result);
    }

    delete[] buf;
    return result;
}





int CHersheyFont::transformX (int xoffset, int px, int minx, float mag)
{
    return ((int) (xoffset + (px - minx) * mag));
}


int CHersheyFont::transformY (int yoffset, int py, int miny, float mag)
{
    return ((int) (yoffset + (py - miny) * mag));
}

void CHersheyFont::calculateCharacterSize (int j, int xadj)
{
    characterMinX[j] = 1000;
    characterMaxX[j] = -1000;

    // for all the vertices in the character
    for (int i = 1; i < numberOfPoints[j]; i++)
    {
        // if this is not a "skip"
        if (characterVectors[j][X][i] != ' ')
        {
            // if this is less than our current minimum
            if (characterVectors[j][X][i] < characterMinX[j])
            {
                // save it
                characterMinX[j] = characterVectors[j][X][i];
            }

            // if this is greater than our current maximum
            if (characterVectors[j][X][i] > characterMaxX[j])
            {
                // save it
                characterMaxX[j] = characterVectors[j][X][i];
            }

            // if this is less than our current minimum
            if (characterVectors[j][Y][i] < characterSetMinY)
            {
                // save it
                characterSetMinY = characterVectors[j][Y][i];
            }

            // if this is greater than our current maximum
            if (characterVectors[j][Y][i] > characterSetMaxY)
            {
                // save it
                characterSetMaxY = characterVectors[j][Y][i];
            }
        }
    }

    characterMinX[j] -= xadj;
    characterMaxX[j] += xadj;
}


int CHersheyFont::fontAdjustment (PlatCharPtr fontname)
{
    int xadjust = 0;
    
    // if we do not have a script type font
    if (strstr(fontname,"scri") !=NULL)
    {
        // if we have a gothic font
        if (strstr(fontname,"goth") != NULL)
        {
            xadjust = 2;
        }
        else
        {
            xadjust = 3;
        }
    }

    return (xadjust);
}




void CHersheyFont::drawString (PlatCharPtr text, int x, int y, Graphics& g)
{
    Rectangle r;
    drawText (text,
              x,
              y,
              hersheyWidth,
              hersheyHeight,
              hersheyHorizontalAlignment,
              herhseyVerticalAlignment,
              0 /*hersheyTheta*/,
              true,
              r,
              g
             );
    return;
}

void CHersheyFont::stringLimit (Rectangle& r,PlatCharPtr text, int x, int y, Graphics& g)
{
    drawText (text,
              x,
              y,
              hersheyWidth,
              hersheyHeight,
              hersheyHorizontalAlignment,
              herhseyVerticalAlignment,
              0 /*hersheyTheta*/,
              false,
              r,
              g
             );

    r.width = r.width - r.x + 1;
    r.height = r.height - r.y + 1;
    return;
}


/*TODO
 void CHersheyFont::setRotation (double theta)
{
    hersheyTheta = theta;
    return;
}
*/

void CHersheyFont::setWidth (float width)
{
    hersheyWidth = width;
    return;
}
void CHersheyFont::setHeight (float height)
{
    hersheyHeight = height;
    return;
}
void CHersheyFont::setVerticalAlignment (int alignment)
{
    herhseyVerticalAlignment = alignment;
    return;
}

void CHersheyFont::setHorizontalAlignment (int alignment)
{
    hersheyHorizontalAlignment = alignment;
    return;
}
void CHersheyFont::setItalics (PlatBoolean flag)
{
    hersheyItalics = flag;
    return;
}
void CHersheyFont::setItalicsSlant (float slant)
{
    hersheyItalicSlant = slant;
    return;
}

void CHersheyFont::setLineWidth (int width)
{
    hersheyLineWidth = width;
    return;
}


int CHersheyFont::drawText (PlatCharPtr text,
              int xc,
              int yc,
              float width,
              float height,
              int Horizontal_Alignment,
              int Vertical_Alignment,
              double theta,
              PlatBoolean Draw,
              Rectangle& r,
              Graphics& g
             )
{

    int character;
    int len;
    int rotpx = 0, rotpy = 0;
    int xp,yp;
    PlatBoolean rotate = 0;

    float cosTheta = 1, sinTheta = 0;
    float verticalOffsetFactor = 0;

    // set the flag to true if the angle is not 0.0
    rotate = 0;

    // if we are to do a rotation
    /*TODO
     if (rotate)
    {
        // set up the rotation variables
        theta = -acos(-1.0) / 180.0 * theta;
        cosTheta = (float) cos (theta);
        sinTheta = (float) sin (theta);

        // set the position to do all rotations about
        rotpx = xc;
        rotpy = yc;
    }
        */

    // starting position
    xp = xc;

    yp = yc;

    // if we are not going to actually draw the string
    if (!Draw)
    {
        // set up to initialize the bounding rectangle
        r.x = xp;
        r.y = yp;
        r.width = xp;
        r.height = yp;
    }

    switch (Vertical_Alignment)
    {
    case VERTICAL_TOP:
        verticalOffsetFactor = 0;
        break;

    case VERTICAL_HALF:
        verticalOffsetFactor = 0.5f;
        break;

    case VERTICAL_NORMAL:     // also VERTICAL_BOTTOM

        verticalOffsetFactor = 1;
        break;

    case VERTICAL_CAP:
        verticalOffsetFactor = 0.25f;
        break;

    }

    // move the y position based on the vertical alignment
    yp = yp - (int) (verticalOffsetFactor *
                     (height * (float) (characterSetMaxY - characterSetMinY)));

    // if we have a non-standard horizontal alignment
    if ((Horizontal_Alignment != HORIZONTAL_LEFT) &&
        (Horizontal_Alignment != HORIZONTAL_NORMAL)
       )
    {
        // find the length of the string in pixels ...
        len = 0;

        int j,n=strlen(text);
        for (j = 0; j < n; j++)
        {
            // the character's number in the array ...
            character = (int) text[j] - (int) ' ';

            len += (int)((characterMaxX[character] - characterMinX[character]) * width);
        }

        // if we are center aligned
        if (Horizontal_Alignment == HORIZONTAL_CENTER)
        {
            // move the starting point half to the left
            xp -= len / 2;
        }
        else
        {
            // alignment is right, move the start all the way to the left
            xp -= len;
        }
    }

    // loop through each character in the string ...
    int j,n=strlen(text);
    for (j = 0; j < n; j++)
    {

        const char* findmap = " !\"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

        char* cptr;
        cptr=strchr(findmap,text[j]);
        if (cptr!=NULL)
        {
            character=cptr-findmap;
        }
        else
            character=255;

        // the character's number in the array ...
        if (character != 255)
        {
            // render this character
            drawCharacter (
                           xp,
                           yp,
                           rotpx,
                           rotpy,
                           width,
                           height,
                           rotate,
                           sinTheta,
                           cosTheta,
                           Draw,
                           r,
                           characterVectors[character],
                           numberOfPoints[character],
                           characterMinX[character],
                           characterSetMinY,
                           hersheyItalics,
                           hersheyItalicSlant,
                           g
                          );

            // advance the starting coordinate
            xp += (int) ((float) (characterMaxX[character] -
                                  characterMinX[character]
                                 ) * width
                        )+characterSpacing;
        }
    }                         // end for each character

    return (0);
}


void CHersheyFont::drawFontLine (int x1,
                   int y1,
                   int x2,
                   int y2,
                   int width,
                   Graphics& g
                  )
{
    // if the width is greater than one
    /*TODO@@@
     if (width > 1)
    {
        Polygon filledPolygon = new Polygon ();

        int offset = width / 2;

        // this does not generate a true "wide line" but it seems to
        // look OK for font lines

        filledPolygon.addPoint (x1 - offset, y1 + offset);
        filledPolygon.addPoint (x1 + offset, y1 - offset);
        filledPolygon.addPoint (x2 + offset, y2 - offset);
        filledPolygon.addPoint (x2 - offset, y2 + offset);

        // draw a polygon
        g.fillPolygon (filledPolygon);
    }
    else
    */
    {
        // draw a line
            g.DrawLine2d(x1, y1, x2, y2);


            /*
             g.DrawLine2d(x1-3,y1-3,x1+3,y1+3);
             g.DrawLine2d(x1+3,y1-3,x1-3,y1+3);

             g.DrawLine2d(x2-3,y2-3,x2+3,y2+3);
             g.DrawLine2d(x2+3,y2-3,x2-3,y2+3);
             */

        //System.out.println("" + x1 + " " +  x2 );
    }

    return;
}



void CHersheyFont::drawCharacter (int xp,
                    int yp,
                    int rotpx,
                    int rotpy,
                    float width,
                    float height,
                    PlatBoolean rotate,
                    float sinTheta,
                    float cosTheta,
                    PlatBoolean Draw,
                    Rectangle& r,
                    char Vectors[2][MAX_POINTS],
                    int numberOfPoints,
                    int minX,
                    int characterSetMinY,
                    PlatBoolean Italics,
                    float slant,
                    Graphics& g
                   )
{
    float xd, yd, xd2, yd2;
    int oldx = 0, oldy = 0, x, y, i;
    PlatBoolean skip = true;
    float finalSlant = height * (-slant);

    // loop through each vertex in the character
    for (i = 1; i < numberOfPoints; i++)
    {
        //System.out.print("" +  Vectors[X][i] +  Vectors[Y][i] );
        // if this is a "skip"
        if (Vectors[X][i] == (int) ' ')
        {
            // set the skip flag
            skip = true;
        }
        else
        {
            // calculate italics offset if necessary
            x = (int) ((Italics)
                       ? ((Vectors[Y][i] -
                           characterSetMinY
                          ) * finalSlant
                         )
                       : 0
                      ) +
                // add italics offset to the "normal" point transformation
                transformX (xp, Vectors[X][i], minX, width);

            // calculate the y coordinate
            y = transformY (yp, Vectors[Y][i], characterSetMinY, height);

            // if we are doing a rotation
            if (rotate)
            {
                // apply the rotation matrix ...

                // transform the coordinate to the rotation center point
                xd = (float) (x - rotpx);
                yd = (float) (y - rotpy);

                // rotate
                xd2 = xd * cosTheta - yd * sinTheta;
                yd2 = xd * sinTheta + yd * cosTheta;

                // transform back
                x = (int) (xd2 + 0.5) + rotpx;
                y = (int) (yd2 + 0.5) + rotpy;
            }

            if (!Draw)
            {
                //System.out.println("x,y" + x + ", " + y );

                // we just want the bounding box of the string
                if (x < r.x)
                {
                    r.x = x;
                }
                if (y < r.y)
                {
                    r.y = y;
                }

                if (x > r.width)
                {
                    r.width = x;
                }
                if (y > r.height)
                {
                    r.height = y;
                }
            }

            if (!skip)
            {
                // if we are to draw the string
                if (Draw)
                {
                    drawFontLine (oldx, oldy, x, y, hersheyLineWidth, g);
                }
            }                   // end if not skip

            skip = false;

            oldx = x;
            oldy = y;

        }                      // end if skip
    }                         // end for each vertex in the character
}



/*TODO weg
void CHersheyFont::LoadHersheyFont (PlatCharPtr fontname)
{
    int character,n;
    int c;
    int xadjust = fontAdjustment (fontname);
    FILE* file  = fopen(fontname,"r");
    
    // loop through the characters in the file ...
    character = 0;

    // while we have not processed all of the characters
    while (true)
    {
        // if we cannot read the next field
        if ((n=getInt (file, 5)) < 1)
        {
            // we are done, set the font specification for num chars
            charactersInSet = character;
printf("Charset not read!\n");

            // break the read loop
            break;
        }
        else
        {
            printf("read %d\n",n);

            // get the number of vertices in this character
            n = getInt (file, 3);

printf("numpoints\%d\n",n);
            // save it
            numberOfPoints[character] = n;

            // read in the vertice coordinates ...
            for (int i = 0; i < n; i++)
            {
                // if we are at the end of the line
                    if ((i == 32) || (i == 68) || (i == 104) || (i == 140))
                    {
                        // skip the carriage return
                        fgetc(file);
                    }

                    // get the next character
                    c = fgetc(file);

                    // if this is a return ( we have a DOS style file )
                    if (c == '\n')
                    {
                        // throw it away and get another
                        c = fgetc(file);
                    }

                    // get the x coordinate
                    characterVectors[character][X][i] = (char) c;

                    // read the y coordinate
                    characterVectors[character][Y][i] = (char) fgetc(file);
            }

            // skip the carriage return
            fgetc(file);

            // increment the character counter
            character++;
        }
    }
    // determine the size of each character ...

    characterMinX = new int[charactersInSet];
    characterMaxX = new int[charactersInSet];

    // initialize ...
    characterSetMinY = 1000;
    characterSetMaxY = -1000;

    // loop through each character ( except the space character )
    for (int j = 1; j < charactersInSet; j++)
    {
        // calculate the size
        calculateCharacterSize (j, xadjust);
    }

    // handle the space character - if the 'a' character is defined
    if (((int) 'a' - (int) ' ') <= charactersInSet)
    {
        // make the space character the same size as the 'a'
        characterMinX[0] = characterMinX[(int) 'a' - (int) ' '];
        characterMaxX[0] = characterMaxX[(int) 'a' - (int) ' '];
    }
    else
    {
        // make the space char the same size as the last char
        characterMinX[0] = characterMinX[charactersInSet - 1];
        characterMaxX[0] = characterMaxX[charactersInSet - 1];
    }

    fclose(file);
    return;
}
int CHersheyFont::getInt (FILE* file, int n)
{
    char *buf;
    int c;
    int j = 0;

    buf = new char[n+1];

    // for the specified number of characters
    int i;
    for (i = 0; i < n; i++)
      {
          c = fgetc(file);

          // get character and discard spare newlines
          while ( ((c == '\n') || (c == '\r')) &&
                  !feof(file))
          {
              c = fgetc(file);
          }

          // if we hit end of file
          if (feof(file))
          {
              // return an error
              return (-1);
          }

          // if this is not a blank
          if ((char) c != ' ')
          {
              // save the character
              buf[j++] = (char) c;
          }
      }

    buf[j++] = '\0';
    // return the decimal equivilent of the string
    int result=0;

    if (j>1)
        sscanf(buf,"%d",&result);

    delete[] buf;
    return result;
}
 
 */

