
#ifndef __fixed_h__
#define __fixed_h__

#include "triagetypes.h"
#include "lispassert.h"

#define noUSE_FIXED
#ifdef USE_FIXED

#define FixedOne  0x10000
#define Fixed    PlatInt
#define FixedToInt(_n) ((_n)>>16)
#define IntToFixed(_n) ((_n)<<16)
#define FixedHalf (FixedOne>>1)
#define FixedToWeight(_n) _n

inline Fixed FixedMul(Fixed x0, Fixed x1)
{
    PlatLongLong u=x0;
    u*=x1;
    return u>>16;
}

inline PlatBoolean FixedIsZero(Fixed x)
{
    return x == 0;
}

inline Fixed FixedSqrt(Fixed x)
{
    PLATASSERT(x>=0);

    PlatLongLong xx=x;
    xx<<=16;

    if (xx<2)
        return xx;
    
    PlatLongLong l2,u,u2,v,v2,uv2,n;
    u=xx;

    l2 = 0;
    while( u!=0 )
    {
        u>>=1;
        l2++;
    }
    l2--;
    l2 >>= 1;
    
    u=1;
    u<<=l2;
    u2=u;
    u2<<=l2;
    

    while( l2-- )
    {
        // Get that bit in v, and v2 == v^2.
        v=1;
        v<<=l2;
        v2=v;
        v2<<=l2;

        // uv2 == 2*u*v
        uv2=u;
        uv2<<=(l2 + 1);

        n=u2+uv2+v2;

        if (n<=xx)
        {
            u+=v;
            u2=n;
        }
    }
    return (Fixed)u;
}

inline Fixed FixedDivide(Fixed x,Fixed y)
{
    PlatLongLong u=x;
    u<<=16;
    u/=y;
    return (Fixed)u;
}



#else
#include <math.h>
#define FixedOne  1.0
#define Fixed    double
#define FixedToInt(_n) ((int)(_n))
#define IntToFixed(_n) (_n)
#define FixedHalf 0.5
#define FixedToWeight(_n) ((int)((_n)*65536L))

inline Fixed FixedMul(Fixed x0, Fixed x1)
{
    return x0*x1;
}

inline Fixed FixedSqrt(Fixed x)
{
    return sqrt(x);
}

inline PlatBoolean FixedIsZero(Fixed x)
{
    return x == 0;
}

inline Fixed FixedDivide(Fixed x,Fixed y)
{
    return x/y;
}

#endif


#endif

