/** \file lispstring.h
 *  Defining a string class.
 */


#ifndef __lispstring_h__
#define __lispstring_h__

#include "lisptype.h"
#include "grower.h"

// class LispString: zero-terminated byte-counted string.
// Also keeps a reference count for any one interested...
class LispString : public CArrayGrower<LispChar>
{
public:
    inline LispString(LispBoolean aStringOwnedExternally=LispFalse);
    inline LispString(LispString &aString,
                      LispBoolean aStringOwnedExternally=LispFalse);
    inline LispString& operator=(LispCharPtr aString);
    inline LispString(LispCharPtr aString,
                      LispBoolean aStringOwnedExternally=LispFalse);
    inline LispCharPtr String() const;

    LispInt operator==(const LispString& aString);
    
    void SetStringCounted(LispCharPtr aString,LispInt aLength);
    void SetStringUnStringified(LispCharPtr aString);
    void SetStringStringified(LispCharPtr aString);
private:
    void SetString(LispCharPtr aString,
                   LispBoolean aStringOwnedExternally=LispFalse);
};



#define LispStringRef LispString &
#define LispStringPtr LispString *

LispInt StrEqual(LispCharPtr ptr1, LispCharPtr ptr2);



#include "lispstring.inl"
#endif


