/** \file deffile.h deffiles, which speed up loading.
 *  This module adds support for loading files which specify
 *  which script file to look for when trying to use a specific
 *  function.
 */

#ifndef __deffile_h__
#define __deffile_h__

#include "lispuserfunc.h"
#include "lisphash.h"

class LispDefFile
{
public:
    LispDefFile(LispStringPtr aFile);
    void SetLoaded();
    inline LispBoolean IsLoaded();
    inline LispStringPtr FileName();

    LispStringPtr iFileName;
    LispBoolean   iIsLoaded;
};



class LispDefFiles : public LispAssociatedHash<LispDefFile>
{
public:
    LispDefFile* File(LispStringPtr aFileName);
};

void LoadDefFile(LispEnvironment& aEnvoronment,
                 LispStringPtr aFileName);

void UseFile(); //TODO


#include "deffile.inl"

#endif
