
/*  Echo string to stdout
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "configread.h"
#include "uncgi.h"

void server_init(void)
{
    extern char *the_address;
    if (LogSocket()[0])
        the_address = LogSocket();
}

void server_process(char* buffer, int process,int*buflen)
{
    char* getpos;
    char* authpos;
    char* auth;
    char* toget;
    char* formmark;
    char logbuf[32768];

    // Get the GET command position
    getpos=strstr(buffer,"GET");

    // Get the autorization position
    authpos=strstr(buffer,"Authorization");
    
    if (getpos==NULL)
    {
        goto SENDEMPTY;
    }

    //Get the authorization
    auth=NULL;
    if (authpos != NULL)
    {
        strtok(authpos," \t\n\r"); //Init on Authorization:
        strtok(NULL," \t\n\r");    //Skip "Basic"
        auth = strtok(NULL," \t\n\r"); //Get the string
    }
    // Get the information to get
    strtok(getpos," \t\n\r");
    toget=strtok(NULL," \t\n\r");
    
    if (toget==NULL)
    {
        goto SENDEMPTY;
    }

    formmark=strchr(toget,'?');
    if (formmark != NULL)
    {
        CgiArgList arglist;
        char tempbuf[16384];
        int i;
        
        url_unescapelist(&arglist,formmark);

        if (strstr(arglist.command,".ygi")==NULL)
        {
            goto SENDEMPTY;
        }
        sprintf(logbuf,"GET %s ",arglist.command);
        for (i=0;i<arglist.nrargs;i++)
        {
            sprintf(tempbuf,"%s=\"%s\" ",arglist.variables[i],arglist.values[i]);
            strcat(logbuf,tempbuf);
        }
    }
    else
    {
        char* newtoget = toget+strlen(toget)-1;

        // find the flat file name to return
        while (newtoget>toget && newtoget[0] != '/')
        {
            newtoget--;
        }
        newtoget++;
        
        if (strstr(newtoget,".ygi")!=NULL)
        {
            sprintf(logbuf,"GET %s",newtoget);
        }
        else 
        {
            sprintf(logbuf,"GET %s",newtoget);
        }
    }


    goto DEFBUF;
SENDEMPTY:
    strcpy(logbuf,buffer);

DEFBUF:
    printf(logbuf);
    printf("\n");
    fflush(stdout);
    return;
}

/*TODO old
void server_process(char* buffer, int process,int*buflen)
{
    char *getpos, *end;
    char logbuf[16384];
    *buflen=0;

    getpos=strstr(buffer,"GET");
    if (getpos == NULL)
    {
        strcpy(logbuf,buffer);
        goto DEFBUF;
    }
    end=getpos+4;

    {
        int busy=1;
        while(busy)
        {
            switch(*end)
            {
            case '\0':
            case ' ':
            case '\t':
            case '\n':
            case '\r':
                busy=0;
                break;
            default:
                end++;
            }
        }
    }

    memcpy(logbuf,getpos,end-getpos);
    logbuf[end-getpos] = '\0';

    printf("length %d\n",(int)(end-getpos));
    
DEFBUF:
    printf(logbuf);
    printf("\n");
    fflush(stdout);
    return;
}
*/
void server_exit(void)
{
}


