/*
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#ifndef s_Table_h
#define s_Table_h

/****************************************************************
 *
 * Table widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 tableAdjHoriz	     TableAdjHoriz	Callback	NULL
 tableAdjVert	     TableAdjVert	Callback	NULL
 tableBackground     TableBackground	Pixel		XtDefaultBackground
 tableColWidth	     TableColWidth	Callback	NULL
 tableCursor	     TableCursor	Pixel		XtDefaultForeground
 tableData	     TableData		Callback	NULL
 tableDefaultHeight  TableDefaultHeight	Dimension	20
 tableDefaultWidth   TableDefaultWidth	Dimension	80
 tableForeground     TableForeground	Pixel		XtDefaultForeground
 tableFormat	     TableFormat	Callback	NULL
 tableGC	     TableGC		Callback	NULL
 tableGrid	     TableGrid		Pixel		XtDefaultForeground
 tableGridLines	     TableGridLines	Boolean		True
 tableHighlight	     TableHighlight	Pixel		XtDefaultForeground
 tableMaxCol	     TableMaxCol			1000
 tableMaxRow	     TableMaxRow			1000
 tablePointCol	     TablePointCol			0
 tablePointRow	     TablePointRow			0
 tableProtCol	     TableProtCol			1
 tableProtRow	     TableProtRow			1
 tableRedisplay	     TableRedisplay	Boolean		False
 tableRowHeight	     TableRowHeight	Callback	NULL
 tableSelectBottomRow TableSelectBottomRow		0
 tableSelectLeftCol  TableSelectLeftRow			0
 tableSelectRightCol TableSelectRightCol		0
 tableSelectTopRow   TableSelectTopRow			0
 tableText	     TableText		Callback	NULL
 tableTopCol	     TableTopCol			1
 tableTopRow	     TableTopRow			1
 tableType	     TableType		Callback	NULL
 tableVisibleCursor  TableVisibleCursor	Boolean		False
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/

/* define any special resource names here that are not in <X11/StringDefs.h> */

#define XtNtableMaxRow "tableMaxRow"
#define XtNtableMaxCol "tableMaxCol"
#define XtNtableProtRow "tableProtRow"
#define XtNtableProtCol "tableProtCol"
#define XtNtableTopRow "tableTopRow"
#define XtNtableTopCol "tableTopCol"
#define XtNtableSelectTopRow "tableSelectTopRow"
#define XtNtableSelectBottomRow "tableSelectBottomRow"
#define XtNtableSelectLeftCol "tableSelectLeftCol"
#define XtNtableSelectRightCol "tableSelectRightCol"
#define XtNtablePointRow "tablePointRow"
#define XtNtablePointCol "tablePointCol"
#define XtNtableDefaultWidth "tableDefaultWidth"
#define XtNtableDefaultHeight "tableDefaultHeight"
#define XtNtableColWidth "tableColWidth"
#define XtNtableRowHeight "tableRowHeight"
#define XtNtableType "tableType"
#define XtNtableText "tableText"
#define XtNtableFormat "tableFormat"
#define XtNtableGC "tableGC"
#define XtNtableAdjHoriz "tableAdjHoriz"
#define XtNtableAdjVert "tableAdjVert"
#define XtNtableBackground "tableBackground"
#define XtNtableForeground "tableForeground"
#define XtNtableGrid "tableGrid"
#define XtNtableCursor "tableCursor"
#define XtNtableHighlight "tableHighlight"
#define XtNtableData "tableData"
#define XtNtableRedisplay "tableRedisplay"
#define XtNtableGridLines "tableGridLines"
#define XtNtableVisibleCursor "tableVisibleCursor"

#define XtCTableMaxRow "TableMaxRow"
#define XtCTableMaxCol "TableMaxCol"
#define XtCTableProtRow "TableProtRow"
#define XtCTableProtCol "TableProtCol"
#define XtCTableTopRow "TableTopRow"
#define XtCTableTopCol "TableTopCol"
#define XtCTableSelectTopRow "TableSelectTopCol"
#define XtCTableSelectBottomRow "TableSelectBottomRow"
#define XtCTableSelectLeftCol "TableSelectLeftCol"
#define XtCTableSelectRightCol "TableSelectRightCol"
#define XtCTablePointRow "TablePointRow"
#define XtCTablePointCol "TablePointCol"
#define XtCTableDefaultWidth "TableDefaultWidth"
#define XtCTableDefaultHeight "TableDefaultHeight"
#define XtCTableColWidth "TableColWidth"
#define XtCTableRowHeight "TableRowHeight"
#define XtCTableType "TableType"
#define XtCTableText "TableText"
#define XtCTableFormat "TableFormat"
#define XtCTableGC "TableGC"
#define XtCTableAdjHoriz "TableAdjHoriz"
#define XtCTableAdjVert "TableAdjVert"
#define XtCTableBackground "TableBackground"
#define XtCTableForeground "TableForeground"
#define XtCTableGrid "TableGrid"
#define XtCTableCursor "TableCursor"
#define XtCTableHighlight "TableHighlight"
#define XtCTableData "TableData"
#define XtCTableRedisplay "TableRedisplay"
#define XtCTableGridLines "TableGridLines"
#define XtCTableVisibleCursor "TableVisibleCursor"

/* declare specific TableWidget class and instance datatypes */

typedef struct s_TableClassRec*	TableWidgetClass;
typedef struct s_TableRec*		TableWidget;

/* declare the class constant */

extern WidgetClass tableWidgetClass;

extern Pixmap table_pixmap(TableWidget);

#define TABLE_TEXT 1
#define TABLE_PIXMAP 2
#define TABLE_EMBED 3

#endif /* s_Table_h */

