/*
 * RudegridP.h - Private definitions for Rudegrid widget
 *
 * Loosely based on Ed Falk's Gridbox widget.
 */

#ifndef _RudegridP_h
#define _RudegridP_h

#include "Rudegrid.h"


typedef struct {
    XtPointer	extension ;
} RudegridClassPart;

typedef struct _RudegridClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    RudegridClassPart	rudegrid_class;
} RudegridClassRec;

extern RudegridClassRec rudegridClassRec;

typedef struct _RudegridPart {
    /* resources */
    String	x_layout, y_layout;

    /* private state */
} RudegridPart;

typedef struct _RudegridRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    RudegridPart	rudegrid;
} RudegridRec;

typedef struct _RudegridConstraintsPart {
/*
 * Constraint Resources.
 */
    Position	gridx, gridy ;	/* position in the grid			*/
    Dimension	gridWidth,	/* size in cells			*/
    		gridHeight ;
/*
 * Private contstraint resources.
 */
} RudegridConstraintsPart;

typedef struct _RudegridConstraintsRec {
    RudegridConstraintsPart	rudegrid;
} RudegridConstraintsRec, *RudegridConstraints;

#endif /* _RudegridP_h */
