;;
;; Set up the menu
;;

(add-menu "File")
(add-menu-entry "File" "New" "(new-buffer)")
(add-menu-entry "File" "Open" "(load-buffer)")
(add-menu-entry "File" "Save" "(save-buffer)")
(add-menu-entry "File" "Save As" "(save-buffer-as)")
(add-menu-entry "File" "Preview" "(preview)")
(add-menu-entry "File" "Close" "(kill-buffer 1)")
(add-menu-entry "File" "-" "-")
(add-submenu "File" "Backup Copies")
(add-submenu-entry "File" "Backup Copies" "Yes" "(make-backups 1)")
(add-submenu-entry "File" "Backup Copies" "No" "(make-backups 0)")
(add-submenu "File" "Settings")
(add-submenu-entry "File" "Settings" "Margins" "(change-margins nil)")
(add-submenu-entry "File" "Settings" "Paper Size" "(change-paper-size nil)")
(add-submenu-entry "File" "Settings" "Header and Footer" "(change-headfoot nil)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Print" "(print)")
(add-menu-entry "File" "Print Format" "(print-format)")
;(add-submenu "File" "Orientation")
;(add-submenu-entry "File" "Orientation" "Portrait"
;		   "(put-property nil \"ps_orientation\" \"portrait\")")
;(add-submenu-entry "File" "Orientation" "Landscape"
;		   "(put-property nil \"ps_orientation\" \"landscape\")")
;(add-submenu "File" "Cell Protection")
;(add-submenu-entry "File" "Cell Protection" "Respect"
;		   "(put-property nil \"ps_protection\" \"yes\")")
;(add-submenu-entry "File" "Cell Protection" "Ignore"
;		   "(put-property nil \"ps_protection\" \"no\")")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Load External" "(load-external)")
(add-menu-entry "File" "Save External" "(save-external)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Exit" "(quit-program)")

(add-menu "Edit")
(add-menu-entry "Edit" "Undo" "(undo-restore)")
(add-menu-entry "Edit" "Delete" "(delete-cell)")
(add-menu-entry "Edit" "Insert Line" "(insert-line)")
(add-menu-entry "Edit" "Remove Line" "(remove-line)")
(add-menu-entry "Edit" "Insert Column" "(insert-col)")
(add-menu-entry "Edit" "Remove Column" "(remove-col)")
(add-menu-entry "Edit" "Select All" "(select-all)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Cut" "(cut-block-to-string)")
(add-menu-entry "Edit" "Copy" "(copy-block-to-string)")
(add-menu-entry "Edit" "Paste" "(paste-block-from-string)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Find" "(search-forward)")
(add-menu-entry "Edit" "Find Backward" "(search-backward)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Label" "(edit-label)")
;;(add-menu-entry "Edit" "Expression" "(edit-expression)")
(add-menu-entry "Edit" "-" "-")
(add-submenu "Edit" "Expression")
(add-submenu-entry "Edit" "Expression" "C" "(edit-c)")
(add-submenu-entry "Edit" "Expression" "SIOD" "(edit-siod)")
(add-submenu-entry "Edit" "Expression" "Tcl" "(edit-tcl)")
(add-submenu-entry "Edit" "Expression" "Guile" "(edit-guile)")
(add-submenu-entry "Edit" "Expression" "Python" "(edit-python)")
(add-submenu "Edit" "Change Default Interpreter")
(add-submenu-entry "Edit" "Change Default Interpreter" "C" "(define *standard-interpreter* 'C)")
(add-submenu-entry "Edit" "Change Default Interpreter" "SIOD" "(define *standard-interpreter* 'SIOD)")
(add-submenu-entry "Edit" "Change Default Interpreter" "Tcl" "(define *standard-interpreter* 'Tcl)")
(add-submenu-entry "Edit" "Change Default Interpreter" "Guile" "(define *standard-interpreter* 'Guile)")
(add-submenu-entry "Edit" "Change Default Interpreter" "Python" "(define *standard-interpreter* 'Python)")
(add-submenu-entry "Edit" "Change Default Interpreter" "Other" "(change-interpreter)")
;(add-menu-entry "Edit" "Change default interpreter" "(change-interpreter)")
;; Not yet operational
;(add-menu-entry "Edit" "Enter Date" "(enter-date)")
;(add-menu-entry "Edit" "Enter Time" "(enter-time)")

(add-submenu "Edit" "Function A-F")
(add-submenu "Edit" "Function G-L")
(add-submenu "Edit" "Function M-S")
(add-submenu "Edit" "Function T-Z")
(define (function-menu grp fname)
  (add-submenu-entry "Edit"
		     (string-append "Function " grp)
		     (string-append fname "()")
		     (string-append "(interpreter-test 'C "
				    "\""
				    fname
				    "(\""
				    ")")))

(function-menu "A-F" "abs")
(function-menu "A-F" "acos")
(function-menu "A-F" "ash")
(function-menu "A-F" "asin")
(function-menu "A-F" "atan")
(function-menu "A-F" "atan2")
(function-menu "A-F" "ceil")
(function-menu "A-F" "cos")
(function-menu "A-F" "cosh")
(function-menu "A-F" "erf")
(function-menu "A-F" "erfc")
(function-menu "A-F" "exp")
(function-menu "A-F" "fabs")
(function-menu "A-F" "floor")
(function-menu "A-F" "fmod")
(function-menu "G-L" "getgid")
(function-menu "G-L" "getpgrp")
(function-menu "G-L" "getpid")
(function-menu "G-L" "getppid")
(function-menu "G-L" "getuid")
(function-menu "G-L" "hypot")
(function-menu "G-L" "j0")
(function-menu "G-L" "j1")
(function-menu "G-L" "lgamma")
(function-menu "G-L" "log")
(function-menu "G-L" "log10")
(function-menu "M-S" "max")
(function-menu "M-S" "min")
(function-menu "M-S" "pow")
(function-menu "M-S" "pow2")
(function-menu "M-S" "pow10")
(function-menu "M-S" "rand")
(function-menu "M-S" "random")
(function-menu "M-S" "realtime")
(function-menu "M-S" "sin")
(function-menu "M-S" "sinh")
(function-menu "M-S" "sqrt")
(function-menu "M-S" "srand")
(function-menu "M-S" "srandom")
(function-menu "T-Z" "tan")
(function-menu "T-Z" "tanh")
(function-menu "T-Z" "trunc")
(function-menu "T-Z" "y0")
(function-menu "T-Z" "y1")

(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Add Property" "(add-property)")
; Deprecated
;(add-menu-entry "Edit" "-" "-")
;(add-menu-entry "Edit" "Embed Object" "(embed-object)")
;(add-menu-entry "Edit" "Remove Object" "(embed-remove)")
;(add-menu-entry "Edit" "Open Object" "(embed-open)")
;(add-menu-entry "Edit" "Save Object" "(embed-save)")

(add-menu "Block")
(add-menu-entry "Block" "Set Mark" "(set-mark-command)")
(add-menu-entry "Block" "Set Block" "(set-block)")
(add-menu-entry "Block" "Unset Block" "(unset-block)")
(add-menu-entry "Block" "Copy Block" "(copy-block)")
(add-menu-entry "Block" "Delete Block" "(delete-block)")
(add-menu-entry "Block" "Fill Block" "(fill-block)")
(add-menu-entry "Block" "Smart Fill Block" "(smart-fill-block)")
(add-submenu "Block" "Sort")
(add-submenu-entry "Block" "Sort" "Rows Ascending as Text" "(sort-block 0 nil nil nil)")
(add-submenu-entry "Block" "Sort" "Rows Ascending as Numbers" "(sort-block 0 nil nil t)")
(add-submenu-entry "Block" "Sort" "Rows Descending as Text" "(sort-block 0 nil t nil)")
(add-submenu-entry "Block" "Sort" "Rows Descending as Numbers" "(sort-block 0 nil t t)")
(add-submenu-entry "Block" "Sort" "-" "-")
(add-submenu-entry "Block" "Sort" "Columns Ascending as Text" "(sort-block 0 t nil nil)")
(add-submenu-entry "Block" "Sort" "Columns Ascending as Numbers" "(sort-block 0 t nil t)")
(add-submenu-entry "Block" "Sort" "Columns Descending as Text" "(sort-block 0 t t nil)")
(add-submenu-entry "Block" "Sort" "Columns Descending as Numbers" "(sort-block 0 t t t)")

(add-menu-entry "Block" "-" "-")
(add-menu-entry "Block" "Block Sum" "(block-sum)")
(add-menu-entry "Block" "Block Minimum" "(block-min)")
(add-menu-entry "Block" "Block Maximum" "(block-max)")
(add-menu-entry "Block" "Block Average" "(block-avg)")
(add-menu-entry "Block" "-" "-")
(add-menu-entry "Block" "Borders" "(block-borders 1)")
(add-menu-entry "Block" "Grid" "(block-borders 2)")
(add-menu-entry "Block" "Underline" "(block-borders 3)")
(add-menu-entry "Block" "None" "(block-borders 0)")

(add-menu "Format")
(add-menu-entry "Format" "Margins" "(change-margins \"\")")
(add-menu-entry "Format" "Paper Size" "(change-paper-size \"\")")
(add-menu-entry "Format" "Header and Footer" "(change-headfoot \"\")")
(add-menu-entry "Format" "First Page Number" "(change-first-page \"\")")
(add-submenu "Format" "Column Width")
(add-submenu-entry "Format" "Column Width" "Set" "(set-cell-width)")
(add-submenu-entry "Format" "Column Width" "Fit Block" "(fit-block-width)")
(add-submenu-entry "Format" "Column Width" "Set Default" "(set-standard-width)")
(add-submenu "Format" "Row Height")
(add-submenu-entry "Format" "Row Height" "Set" "(set-cell-height)")
(add-submenu-entry "Format" "Row Height" "Fit Block" "(fit-block-height)")
(add-submenu-entry "Format" "Row Height" "Set Default" "(set-standard-height)")
;(add-menu-entry "Format" "Column Width" "(set-cell-width)")
;(add-menu-entry "Format" "Fit Block Width" "(fit-block-width)")
;(add-menu-entry "Format" "Set Default Width" "(set-standard-width)")
;(add-menu-entry "Format" "Row Height" "(set-cell-height)")
;(add-menu-entry "Format" "Fit Block Height" "(fit-block-height)")
;(add-menu-entry "Format" "Set Default Height" "(set-standard-height)")
(add-menu-entry "Format" "-" "-")
(add-menu-entry "Format" "Set Default Format" "(set-standard-format)")
; This no longer works, because the font selector box has been taken out.
; There should not be separate items for cell and block, but rather the
; block should be handled if point is inside it. So just a Format item.
;(add-menu-entry "Format" "Cell Format" "(set-cell-format)")
;(add-menu-entry "Format" "Block Format" "(set-block-format)")
(add-menu-entry "Format" "Font" "(new-attribute \"family\")")
(add-menu-entry "Format" "-" "-")
; Same here: don't use separate items for cell and block
;(add-menu-entry "Format" "Cell Style" "(set-cell-style)")
;(add-menu-entry "Format" "Block Style" "(set-block-style)")
(add-menu-entry "Format" "Style" "(new-attribute \"style\")")
(add-menu-entry "Format" "Define Style" "(define-style)")
(add-menu-entry "Format" "-" "-")
; Again the same. Also, these don't work.
; There should be one item to change the foreground and one to change
; the background.
(add-menu-entry "Format" "Foreground Color" "(new-attribute \"fg\")")
(add-menu-entry "Format" "Background Color" "(new-attribute \"bg\")")
;(add-menu-entry "Format" "Cell Color" "(cell-color)")
;(add-menu-entry "Format" "Block Color" "(block-color)")

(add-menu "Data")
(add-menu-entry "Data" "Edit Record" "(data-record-edit (position-row (get-point)))")
(add-menu-entry "Data" "Data Entry" "(data-entry)")
(define (siag-net p)
  (require (string-append datadir "/siag/siag-net.scm"))
  (siag-net p))
(add-menu-entry "Data" "Siag-net" "(siag-net 8080)")
(add-menu-entry "Data" "-" "-")
(add-menu-entry "Data" "Enter Date" "(enter-date)")
(add-menu-entry "Data" "Enter Time" "(enter-time)")
(add-menu-entry "Data" "-" "-")
(add-menu-entry "Data" "Identify Cell" "(what-cursor-position)")
(add-menu-entry "Data" "Recalculate" "(recalc-matrix)")

(add-menu "Window")
(add-menu-entry "Window" "Change Buffer" "(switch-to-buffer)")
(add-menu-entry "Window" "Delete Buffer" "(kill-buffer 1)")
(add-menu-entry "Window" "-" "-")
(add-menu-entry "Window" "Split Window" "(split-window-vertically)")
(add-menu-entry "Window" "Remove Window" "(delete-window)")
(add-menu-entry "Window" "One Window" "(delete-other-windows)")
(add-menu-entry "Window" "Change Window" "(other-window)")
(add-menu-entry "Window" "-" "-")
(add-menu-entry "Window" "Add Sheet" "(add-sheet)")
(add-menu-entry "Window" "Remove Sheet" "(remove-sheet)")
(add-menu-entry "Window" "Rename Sheet" "(rename-sheet)")
(add-submenu "Window" "Move Sheet")
(add-submenu-entry "Window" "Move Sheet" "Up" "(move-sheet-up)")
(add-submenu-entry "Window" "Move Sheet" "Down" "(move-sheet-down)")
(add-submenu-entry "Window" "Move Sheet" "Top" "(move-sheet-top)")
(add-submenu-entry "Window" "Move Sheet" "Bottom" "(move-sheet-bottom)")

(add-menu-entry "Window" "-" "-")
(add-menu-entry "Window" "Protect Cells" "(protect-cells)")
(add-menu-entry "Window" "Remove Protection" "(remove-protection)")
(add-submenu "Window" "Go To")
(add-submenu-entry "Window" "Go To" "Beginning of buffer" "(beginning-of-buffer)")
(add-submenu-entry "Window" "Go To" "End of buffer" "(end-of-buffer)")
(add-submenu-entry "Window" "Go To" "Top of buffer" "(top-of-buffer)")
(add-submenu-entry "Window" "Go To" "Bottom of buffer" "(bottom-of-buffer)")
(add-submenu-entry "Window" "Go To" "Cell" "(go-to)")

;(define *grid-lines* 1)
;(add-menu-entry "Window" "Grid Lines" "(grid-lines (set! *grid-lines* (- 1 *grid-lines*)))")
;(add-menu-entry "Window" "Disable Helptexts" "(tooltip-mode 0)")
(add-submenu "Window" "Grid Lines")
(add-submenu-entry "Window" "Grid Lines" "Show" "(grid-lines 1)")
(add-submenu-entry "Window" "Grid Lines" "Hide" "(grid-lines 0)")
(add-submenu "Window" "Reference Style")
(add-submenu-entry "Window" "Reference Style" "R1C1" "(a1-refs-set 0)")
(add-submenu-entry "Window" "Reference Style" "A1" "(a1-refs-set 1)")

(define (tooltip-set m)
  (set! *tooltip-mode* m)
  (tooltip-mode m))
(add-submenu "Window" "Helptexts")
(add-submenu-entry "Window" "Helptexts" "Disable" "(tooltip-set 0)")
(add-submenu-entry "Window" "Helptexts" "Label" "(tooltip-set 1)")
(add-submenu-entry "Window" "Helptexts" "Popup" "(tooltip-set 2)")
(add-submenu-entry "Window" "Helptexts" "Both" "(tooltip-set 3)")
(add-menu-entry "Window" "Save Preferences" "(save-preferences)")

(add-menu "Plot")
;(add-menu-entry "Plot" "Lines" "(plot \"lines\")")
;(add-menu-entry "Plot" "Points" "(plot \"points\")")
;(add-menu-entry "Plot" "Linespoints" "(plot \"linespoints\")")
;(add-menu-entry "Plot" "Impulses" "(plot \"impulses\")")
;(add-menu-entry "Plot" "Dots" "(plot \"dots\")")
;(add-menu-entry "Plot" "Steps" "(plot \"steps\")")
;(add-menu-entry "Plot" "Boxes" "(plot \"boxes\")")
;(add-menu-entry "Plot" "-" "-")
;(add-submenu "Plot" "Orientation")
;(add-submenu-entry "Plot" "Orientation" "Horizontal" "(define plot hplot)")
;(add-submenu-entry "Plot" "Orientation" "Vertical" "(define plot vplot)")
;(add-menu-entry "Plot" "-" "-")
(add-menu-entry "Plot" "Plugin" "(plot-plugin \"lines\")")
(add-menu-entry "Plot" "Surface" "(splot \"lines\")")
(add-menu-entry "Plot" "Wizard" "(plot-wizard)")

(add-menu "Tools")

(require (string-append datadir "/common/tools.scm"))

(add-submenu "Tools" "Applets")

; Add the web server to the menu
(define (webserver)
  (require (string-append datadir "/siag/siag-http.scm"))
  (siag-http 8080))

(add-submenu-entry "Tools" "Applets" "Webserver" "(webserver)")

; Add the mailer
(define (mailto)
  (require (string-append datadir "/siag/mailto.scm"))
  (mailto))

(add-submenu-entry "Tools" "Applets" "Mail" "(mailto)")

; The file manager
(define (filemgr)
  (require (string-append datadir "/siag/filemgr.scm"))
  (read-directory))

(add-submenu-entry "Tools" "Applets" "File Manager" "(filemgr)")

(add-submenu "Tools" "Form Test")
(add-submenu-entry "Tools" "Form Test" "Test 1" "(form-test)")
(add-submenu-entry "Tools" "Form Test" "Test 2" "(form-test2)")
(add-submenu-entry "Tools" "Form Test" "Test 3" "(form-test3)")
;(add-submenu-entry "Tools" "Form Test" "Test 4" "(form-test4)")

(add-menu "Plugin")
(add-menu-entry "Plugin" "Import" "(plugin-import nil)")
(add-menu-entry "Plugin" "Export" "(plugin-export)")
(add-menu-entry "Plugin" "Link" "(plugin-link nil)")
(add-menu-entry "Plugin" "Delete" "(plugin-delete)")
(add-menu-entry "Plugin" "Move" "(plugin-move)")
(add-menu-entry "Plugin" "Resize" "(plugin-resize)")
(add-menu-entry "Plugin" "-" "-")
(add-submenu "Plugin" "App")
(add-submenu-entry "Plugin" "App" "Xclock" "(plugin-import \"xclock.run\")")
(add-submenu-entry "Plugin" "App" "Xterm" "(plugin-import \"xterm.run\")")
(add-submenu-entry "Plugin" "App" "Xload" "(plugin-import \"xload.run\")")
(add-submenu-entry "Plugin" "App" "Siag" "(plugin-import \"PLuGiN.siag\")")
(add-submenu-entry "Plugin" "App" "PW" "(plugin-import \"PLuGiN.pw\")")
(add-submenu-entry "Plugin" "App" "Hello World" "(plugin-import \"x.hello\")")

(add-menu "Help")
(add-menu-entry "Help" "Contents" "(help-contents)")
(add-menu-entry "Help" "Search" "(help-search)")
(add-menu-entry "Help" "Copying" "(help-copyright)")
(add-menu-entry "Help" "Help for Help" "(help-for-help)")

(add-submenu "Help" "Links")

(define (help-link name url)
  (add-submenu-entry "Help"
		     "Links"
		     name
		     (string-append "(do-link \"" url "\")")))

(help-link "Siag Home" "http://siag.nu/")
(help-link "FTP Directory" "ftp://ftp.edu.stockholm.se/siag/")

(add-menu-entry "Help" "-" "-")
(add-menu-entry "Help" "About Siag" "(print-version)")

(add-pseudo-menu "Shortcuts")

(add-menu-entry "Shortcuts" "Open" "(load-buffer)")
(add-menu-entry "Shortcuts" "Save" "(save-buffer-as)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Undo" "(undo-restore)")
(add-menu-entry "Shortcuts" "Delete" "(delete-cell)")
(add-menu-entry "Shortcuts" "Label" "(edit-label)")
(add-submenu "Shortcuts" "Expression")
(add-submenu-entry "Shortcuts" "Expression" "C" "(edit-c)")
(add-submenu-entry "Shortcuts" "Expression" "SIOD" "(edit-siod)")
(add-submenu-entry "Shortcuts" "Expression" "Guile" "(edit-guile)")
(add-submenu-entry "Shortcuts" "Expression" "Tcl" "(edit-tcl)")
(add-submenu-entry "Shortcuts" "Expression" "Python" "(edit-python)")
;(add-menu-entry "Shortcuts" "Expression" "(edit-expression)")
(add-menu-entry "Shortcuts" "Command" "(exec-siod)")
(add-menu-entry "Shortcuts" "Sum" "(block-sum)")
(add-menu-entry "Shortcuts" "-" "-")
(add-submenu "Shortcuts" "Plugin")
(add-submenu-entry "Shortcuts" "Plugin" "Import" "(plugin-import)")
(add-submenu-entry "Shortcuts" "Plugin" "Export" "(plugin-export)")
(add-submenu-entry "Shortcuts" "Plugin" "Link" "(plugin-link)")
(add-submenu-entry "Shortcuts" "Plugin" "Delete" "(plugin-delete)")
(add-submenu-entry "Shortcuts" "Plugin" "Move" "(plugin-move)")
;(add-menu-entry "Shortcuts" "Import Plugin" "(plugin-import)")
;(add-menu-entry "Shortcuts" "Move Plugin" "(plugin-move)")
(add-menu-entry "Shortcuts" "Help" "(help-contents)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Quit" "(quit-program)")

