dnl aclocal.m4 generated automatically by aclocal 1.3

dnl Copyright (C) 1994, 1995, 1996, 1997, 1998 Free Software Foundation, Inc.
dnl This Makefile.in is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.


AC_DEFUN(AC_CHECK_SIAG,
[
dnl We want to use gmatch where fnmatch is not available
AC_CHECK_FUNC(fnmatch, AC_DEFINE(HAVE_FNMATCH),
	AC_CHECK_LIB(gen, gmatch)
	AC_CHECK_FUNC(gmatch, AC_DEFINE(HAVE_GMATCH)))

dnl Somehow we must be able to set NDBM even if no libdb exists (Solaris)
dnl Try named lib first, then libdb, then libgdbm, then libndbm
define(siag_CHECK_NDBM,
[AC_CHECK_LIB($MAYBE_LIBNDBM, dbm_open, LIBDB=-l$MAYBE_LIBNDBM,
	AC_CHECK_LIB(db, dbm_open, LIBDB="-ldb",
		AC_CHECK_LIB(gdbm, dbm_open, LIBDB="-lgdbm",
			AC_CHECK_LIB(ndbm, dbm_open, LIBDB="-lndbm"))))
if test "$LIBDB" != ""; then
	echo "Found ndbm in $LIBDB"
	LIBS="$LIBDB $LIBS"
fi
AC_CHECK_FUNC(dbm_dirfno, AC_DEFINE(HAVE_DBM_DIRFNO))
AC_CHECK_FUNC(dbm_pagfno, AC_DEFINE(HAVE_DBM_PAGFNO))
AC_CHECK_FUNC(dbm_rdonly, AC_DEFINE(HAVE_DBM_RDONLY))
AC_CHECK_FUNC(dbm_open, NDBM="-DNDBM")
])

AC_ARG_WITH(ndbm,
	[  --with-ndbm[=libname]   enable (named) ndbm library [default: gdbm]],
	[ case $withval in
	yes)
		MAYBE_LIBNDBM="gdbm"
		;;
	no)
		;;
	*)
		MAYBE_LIBNDBM=$withval
		;;
	esac
	
	if test "$withval" != "no"; then
		siag_CHECK_NDBM
	fi ],
dnl	[ MAYBE_LIBNDBM="gdbm"
dnl	siag_CHECK_NDBM ])
)

AC_SUBST(NDBM)

AC_CHECK_LIB(m, main)

dnl Check what math functions we have
AC_CHECK_FUNC(acosh, AC_DEFINE(HAVE_ACOSH))
AC_CHECK_FUNC(asinh, AC_DEFINE(HAVE_ASINH))
AC_CHECK_FUNC(log1p, AC_DEFINE(HAVE_LOG1P))
AC_CHECK_FUNC(expm1, AC_DEFINE(HAVE_EXPM1))
AC_CHECK_FUNC(cbrt, AC_DEFINE(HAVE_CBRT))
AC_CHECK_FUNC(drem, AC_DEFINE(HAVE_DREM))

AC_CHECK_LIB(crypt, main, [LIBSYSDEP="-lcrypt"])
if test "$LIBSYSDEP" = ""; then
	AC_CHECK_LIB(posix4, main, [LIBSYSDEP="-lposix4"])
	if test "$LIBSYSDEP" = ""; then
		LIBSYSDEP=""
	fi
fi
AC_SUBST(LIBSYSDEP)

dnl These are necessary for SIOD on Solaris and probably Irix.
AC_CHECK_LIB(nsl, main)
AC_CHECK_LIB(socket, connect)

dnl SIOD
AC_CHECK_HEADERS(sys/mode.h fnmatch.h crypt.h sys/mkdev.h fcntl.h)

AC_CHECK_FUNCS(setpwfile getrlimit getrusage fnmatch \
		usleep lchown strptime putpwent getwd)

dnl Guile and Tcl

dnl AC_CHECK_LIB(dl, main, LIBDL="-ldl")
dnl AC_SUBST(LIBDL)

dnl Empty libdl in case we are making static binaries
dnl LIBDL=""

define(siag_CHECK_TCL,
[AC_CHECK_LIB(dl, main, LIBDL="-ldl")
AC_CHECK_LIB($MAYBE_LIBTCL, Tcl_Main, LIBTCL=-l$MAYBE_LIBTCL, , $LIBMATH $LIBDL)
if test "$LIBTCL" != ""; then
	TCL="-DTCL"
fi])

AC_ARG_WITH(tcl,
	[  --with-tcl[=libname]    enable (named) tcl library [default: tcl]],
	[ case $withval in 
	yes)
		MAYBE_LIBTCL="tcl"
		;;
	no)
		;;
	*)
		MAYBE_LIBTCL=$withval
		;;
	esac

	 if test "$withval" != "no"; then
		siag_CHECK_TCL
	fi ],
)
AC_SUBST(TCL)
AC_SUBST(LIBTCL)

AC_ARG_WITH(guile,
	[  --with-guile            enable guile commands and expressions],
	[ if test "$withval" != "no"; then
		AC_CHECK_LIB(guile, gh_enter, [LIBGUILE=`guile-config link`], , `guile-config link`)
		if test "$LIBGUILE" != ""; then
			GUILE="-DGUILE"
		fi
	fi ],
)
AC_SUBST(GUILE)
AC_SUBST(LIBGUILE)
AC_SUBST(LIBDL)

AC_ARG_WITH(python,
	[  --with-python           enable python commands and expressions],
	[ if test "$withval" != "no"; then
		AC_CHECK_LIB(pthread, main)
		AC_CHECK_LIB(python1.5, PyFloat_AsDouble, [LIBPYTHON="-lpython1.5"], ,)
		if test "$LIBPYTHON" != ""; then
			PYTHON="-DPYTHON"
		fi
	fi ])
AC_SUBST(PYTHON)
AC_SUBST(LIBPYTHON)

dnl No Perl
LIBPERL=""
AC_SUBST(LIBPERL)
AC_SUBST(PERL)
AC_SUBST(PERLINC)

dnl This is insane...
ac_save_LDFLAGS="$LDFLAGS"
LDFLAGS="$LDFLAGS $X_LIBS"
AC_CHECK_LIB(Xext, main, [LIBXEXT="-lXext"], , $X_PRE_LIBS $X_EXTRA_LIBS $X_EXTRA_LIBS -lXt -lX11)
AC_SUBST(LIBXEXT)

AC_CHECK_LIB(Xmu, main, [LIBXMU="-lXmu"], , $LIBXEXT $X_PRE_LIBS $X_EXTRA_LIBS $X_EXTRA_LIBS -lXt -lX11)
AC_SUBST(LIBXMU)
AC_CHECK_LIB(X11, XCreateIC, AC_DEFINE(HAVE_XCREATEIC), , $x_libs)
LDFLAGS=$ac_save_LDFLAGS

if test "$GCC" = "yes"; then
	CFLAGS="-Wall $CFLAGS"
fi

if test "$XAWLIB" = ""; then
	XAWLIB="-lXaw3d"
fi
AC_SUBST(XAWLIB)

dnl What curses lib is available? Try in this order:
dnl 0. use termcap if available
dnl 1. ncurses
dnl 2. curses
ac_save_LDFLAGS="$LDFLAGS"
AC_CHECK_LIB(termcap, main, LIBTERMCAP="-ltermcap")
AC_CHECK_LIB(ncurses, wgetch, LIBCURSES="-lncurses $LIBTERMCAP",
	AC_CHECK_LIB(curses, wgetch, LIBCURSES="-lcurses $LIBTERMCAP", , $LIBTERMCAP),
	$LIBTERMCAP)
LDFLAGS="$LDFLAGS $LIBCURSES"
AC_CHECK_FUNCS(resizeterm beep immedok keypad)
AC_SUBST(LIBCURSES)
LDFLAGS=$ac_save_LDFLAGS

dnl Look for T1lib including its X part
AC_ARG_WITH(t1lib,
	[  --with-t1lib            enable t1lib],
	[ if test "$withval" != "no"; then
		AC_CHECK_LIB(t1, main, LIBT1="-lt1")
		if test "$LIBT1" != ""; then
			AC_DEFINE(HAVE_LIB_T1)
		fi
		AC_CHECK_LIB(t1x, main, LIBT1X="-lt1x", , $LIBT1 $X_LIBS -lX11)
		if test "$LIBT1X" != ""; then
			AC_DEFINE(HAVE_LIB_T1X)
		fi
	fi ])
AC_SUBST(LIBT1)
AC_SUBST(LIBT1X)
])

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AM_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE")
AC_DEFINE_UNQUOTED(VERSION, "$VERSION"))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])


# serial 1

AC_DEFUN(AM_PROG_INSTALL,
[AC_REQUIRE([AC_PROG_INSTALL])
test -z "$INSTALL_SCRIPT" && INSTALL_SCRIPT='${INSTALL_PROGRAM}'
AC_SUBST(INSTALL_SCRIPT)dnl
])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

