/*
 * Author:  G. Jungman
 * RCS:     $Id: source_nrm2_c.h,v 1.3 1999/10/18 00:45:12 jungman Exp $
 */

  BASE_TYPE scale = 0.0;
  BASE_TYPE ssq   = 1.0;
  size_t n;
  for(n=0; n<N; n++) {
    const BASE_TYPE axi = fabs(REAL(X,incX,n));
    const BASE_TYPE ayi = fabs(IMAG(X,incX,n));
    if(scale < axi) {
      ssq   = 1.0 + ssq*(scale/axi)*(scale/axi);
      scale = axi;
    }
    else {
      ssq += (axi/scale)*(axi/scale);
    }
    if(scale < ayi) {
      ssq   = 1.0 + ssq*(scale/ayi)*(scale/ayi);
      scale = ayi;
    }
    else {
      ssq += (ayi/scale)*(ayi/scale);
    }
  }
  return scale * sqrt(ssq);
