/* Copyright (c) 1994 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Author: Timothy Rowley */

#include <limits.h>
#include "mgP.h"
#include "mgbufP.h"

void
Xmgr_gradWrapper(unsigned char *buf, float *zbuf, int zwidth, int width,
	int height, CPoint3 *p0, CPoint3 *p1, int lwidth,
	void (*flat)(unsigned char *, float *, int, int, int, CPoint3 *,
			CPoint3 *, int, int *),
	void (*smooth)(unsigned char *, float *, int, int, int, CPoint3 *,
			CPoint3 *, int, int *))
{
    int color[3];
    
    if ((p0->vcol.r == p1->vcol.r) && (p0->vcol.g == p1->vcol.g) &&
	(p0->vcol.b == p1->vcol.b))
    {
	color[0] = 255*p0->vcol.r;
	color[1] = 255*p0->vcol.g;
	color[2] = 255*p0->vcol.b;
	flat(buf, zbuf, zwidth, width, height, p0, p1, lwidth, color);
    }
    else
	smooth(buf, zbuf, zwidth, width, height, p0, p1, lwidth, color);
}

void
oldXmgr_gradWrapper(unsigned char *buf, float *zbuf, int zwidth, int width,
	int height, CPoint3 *p0, CPoint3 *p1, int lwidth,
	void (*flat)(unsigned char *, float *, int, int, int, int, int, float,
			int, int, float, int, int *),
	void (*smooth)(unsigned char *, float *, int, int, int, CPoint3 *,
			CPoint3 *, int))
{
    int color[3];
    
    if ((p0->vcol.r == p1->vcol.r) && (p0->vcol.g == p1->vcol.g) &&
	(p0->vcol.b == p1->vcol.b))
    {
	color[0] = 255*p0->vcol.r;
	color[1] = 255*p0->vcol.g;
	color[2] = 255*p0->vcol.b;
	flat(buf, zbuf, zwidth, width, height, p0->x, p0->y, p0->z,
	     p1->x, p1->y, p1->z, lwidth, color);
    }
    else
	smooth(buf, zbuf, zwidth, width, height, p0, p1, lwidth);
}

#define NAME Xmgr_polyscan
#include "MGRpolyscan.h"

#define NAME Xmgr_Zpolyscan
#define ZBUFFER
#include "MGRpolyscan.h"

#define NAME Xmgr_Graypolyscan
#define GOURAUD
#include "MGRpolyscan.h"

#define NAME Xmgr_GrayZpolyscan
#define ZBUFFER
#define GOURAUD
#include "MGRpolyscan.h"

#define NAME Xmgr_Gpolyscan
#define GOURAUD
#define COLOR
#include "MGRpolyscan.h"

#define NAME Xmgr_GZpolyscan
#define GOURAUD
#define COLOR
#define ZBUFFER
#include "MGRpolyscan.h"
