/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
   Celeste Fowler */

#include "hpoint3.h"
#include "point3.h"
#include "quadP.h"

Quad *
QuadTransform( q, T )
     Quad *q;
     Transform T;
{
  int i;
  for (i = 0; i < q->maxquad; i++)
    HPt3TransformN(T, q->p[i], q->p[i], 4);
  if (q->flag & QUAD_N)
    for (i = 0; i < q->maxquad; i++)
      NormalTransformN(T, q->n[i], q->n[i], 4);
  return(q);
}

Quad *
QuadTransformTo( q, T )
     Quad *q;
     Transform T;
{
  return(QuadTransform(q, T));
}

