/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors:  Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
   Celeste Fowler */

#include "point3.h"
#include "polylistP.h"

PolyList *
PolyListTransform( p, T )
     PolyList *p;
     Transform T;
{
  int i;
  for (i = 0; i < p->n_verts; i++)
    HPt3Transform(T, &p->vl[i].pt, &p->vl[i].pt);
  if (p->flags & PL_HASVN)
    for (i = 0; i < p->n_verts; i++)
      NormalTransform(T, &p->vl[i].vn, &p->vl[i].vn);
  if (p->flags & PL_HASPN)
    for (i = 0; i < p->n_polys; i++)
      NormalTransform(T, &p->p[i].pn, &p->p[i].pn);
  return p;
}

PolyList *
PolyListTransformTo( p, T )
     PolyList *p;
     Transform T;
{
  return(PolyListTransform(p, T));
}


