/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/* $Header: /usr8/geom/devel/ngrap/src/lib/gprim/polylist/RCS/plcopy.c,v 1.10 1992/01/31 16:15:23 mbp Exp $ */

/*
 * Geometry object routines
 *
 * Copy a PolyList.
 */


#include "polylistP.h"

PolyList *
PolyListCopy(polylist)
	register PolyList *polylist;
{
	PolyList *newpl;
	Poly *newp;
	Vertex *newvl;
	register int i, j;
	register Poly *op, *np;

	if(polylist == NULL) return NULL;

	newvl = OOGLNewNE(Vertex, polylist->n_verts, "PolyList verts");
	newp = OOGLNewNE(Poly, polylist->n_polys, "PolyList polygons");
	newpl = OOGLNewE(PolyList, "PolyList");
	*newpl = *polylist;
	newpl->p = newp;
	newpl->vl = newvl;
	memcpy(newvl, polylist->vl, polylist->n_verts * sizeof(Vertex));
	memcpy(newp, polylist->p, polylist->n_polys * sizeof(Poly));

	for(i = polylist->n_polys, op = polylist->p, np = newp;
			--i >= 0;
			op++, np++) {
	   np->v = OOGLNewNE(Vertex *, op->n_vertices, "PolyList vert list");
	   for(j = op->n_vertices; --j >= 0; )
	      np->v[j] = &newvl[ op->v[j] - polylist->vl ];
	}
	return (newpl);
}
