/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "ndmeshP.h"

static int ndmeshfield(int copy, int amount,
		void **fieldp, void *value, char *name);

static int ndmeshsize(NDMesh *m)
{
    int i, s;
    for(i = m->meshd, s = 1; --i >= 0; ) s *= m->mdim[i];
    return s;
}

static void tosspoints(NDMesh *m)
{
    int n;
    HPointN **p;
    if(m->mdim && m->p) {
	for(n = ndmeshsize(m), p = m->p; --n >= 0; p++)
	    if(*p) HPtNDelete( *p );
    }
}

static void tossmesh(register NDMesh *m)
{
    int n;
    HPointN **p;

    tosspoints(m);
    if(m->p) OOGLFree(m->p);
    if(m->c) OOGLFree(m->c);
    if(m->u) OOGLFree(m->u);
    m->p = NULL;
    m->c = NULL;
    m->u = NULL;
}


NDMesh *
NDMeshCreate (exist, classp, a_list)
NDMesh *exist;
GeomClass *classp;
va_list a_list;
{
    register NDMesh *m;
    int		attr, copy = 1, fourd = 0;
    int		i;
    int		npts;
    HPoint3	*p;
    Point3 	*n, *u, *p3;
    ColorA	*c;

    p = NULL; n = NULL; u = NULL; c = NULL; p3 = NULL;

    if (exist == NULL) {
	m = OOGLNewE(NDMesh, "NDMeshCreate mesh");
	memset(m, 0, sizeof(NDMesh));
	GGeomInit (m, classp, NDMESHMAGIC, NULL);
	m->flag = 0;
	m->meshd = 2;
	m->mdim = OOGLNewNE(int, m->meshd, "NDMesh dim");
	memset(m->mdim, 0, m->meshd * sizeof(int));
    } else {
	/* Check that exist is a NDMesh... */
	m = exist;
    }

    npts = ndmeshsize( m );

    while (attr = va_arg (a_list, int)) switch (attr) {
	case CR_FLAG:
	    m->flag = va_arg (a_list, int);
	    break;

	case CR_MESHDIM:
	    i = va_arg (a_list, int);
	    if(i <= 0 || i >= 1000) {
		OOGLError(1, "Incredible NDMesh dimension %d", i);
		return NULL;
	    }
	    m->meshd = i;
	    OOGLFree(m->mdim);
	    m->mdim = OOGLNewNE(int, m->meshd, "NDMesh dim");
	    memset(m->mdim, 0, m->meshd * sizeof(int));
	    tossmesh(m);
	    npts = 0;
	    break;

	case CR_MESHSIZE:
	    memcpy(m->mdim, va_arg (a_list, int *), m->meshd*sizeof(int));
	    tossmesh(m);
	    npts = ndmeshsize(m);
	    break;

	case CR_DIM:
	    m->pdim = va_arg(a_list, int);
	    break;

	case CR_POINT:
	case CR_POINT4:
	    tosspoints(m);
	    ndmeshfield(copy, npts*sizeof(HPointN *), (void **)&m->p,
		(void *)va_arg (a_list, HPointN **), "ND mesh points");
	    break;

	case CR_U:
	    m->flag = (m->flag & ~MESH_U) |
		(MESH_U & ndmeshfield(copy, npts*sizeof(Point3),
				(void **)&m->u,
				(void *)va_arg (a_list, Point3 *),
				"ndmesh texture coords"));
	    break;

	case CR_COLOR:
	    m->flag = (m->flag & ~MESH_C) |
		(MESH_C & ndmeshfield(copy, npts*sizeof(ColorA),
				(void **)&m->c,
				(void *)va_arg (a_list, ColorA *),
				"ndmesh colors"));
	    break;

	default:
	    if (GeomDecorate (m, &copy, attr, &a_list)) {
		GeomError (0, "NDMeshCreate: Undefined option: %d", attr);
		OOGLFree (m);
		return NULL;
	    }
    }
    return m;
}

static int
ndmeshfield(int copy, int amount, void **fieldp, void *value, char *name)
{
    if(value) {
	if(copy) {
	    if(*fieldp == NULL)
		*fieldp = OOGLNewNE(char, amount, name);
	    memcpy(*fieldp, value, amount);
	} else {
	    if(*fieldp)
		OOGLFree(*fieldp);
	    *fieldp = value;
	}
	return ~0;
    } else {
	if(*fieldp)
	    OOGLFree(*fieldp);
	*fieldp = NULL;
	return 0;
    }
}

NDMesh *
NDMeshDelete(NDMesh *m)
{
    if (m)
    {
	tossmesh(m);
	OOGLFree(m->mdim);
	OOGLFree(m);
    }
    return NULL;
}
