/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
   Celeste Fowler */

#include "hpoint3.h"
#include "point3.h"
#include "meshP.h"

Mesh *
MeshTransform( m, T )
     Mesh *m;
     Transform T;
{
  m->flag &= ~MESH_Z;
  HPt3TransformN(T, m->p, m->p, m->nu * m->nv);
  if (m->flag & MESH_N)
    NormalTransformN(T, m->n, m->n, m->nu * m->nv);
  return m;
}

Mesh *
MeshTransformTo( m, T )
     Mesh *m;
     Transform T;
{
  return(MeshTransform(m, T));
}

