/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/*
 * Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Nathaniel Thurston
 */

/*
 * Save an Comment in a file.
 */
#include <stdio.h>
#include "commentP.h"

Comment *
CommentFSave( comment, file, fname )
    register Comment *comment;
    FILE *file;
    char *fname;
{
    if(comment == NULL || file == NULL)
	return NULL;

    fprintf(file, "COMMENT %s %s", comment->name, comment->type);
    if (comment->length == 0)
	fprintf(file, " {%s}\n", comment->data);
    else {
    	fprintf(file, " %d ", comment->length);
	fwrite(comment->data, comment->length, 1, file);
	fprintf(file, "\n");
    }
    return comment;
}

Comment *
CommentSave( comment, name )
    register Comment *comment;
    char *name;
{
    FILE *file;

    file = fopen( name, "w" );
    if( file == NULL ) {
	perror( name );
	return NULL;
    }
    comment = CommentFSave( comment, file, name );
    fclose(file);

    return comment;
}

