/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/*
 * Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Nathaniel Thurston
 */

/*
 * Comment creation, editing, retrieval and deletion.
 */

#include "commentP.h"
#include "transobj.h"

void
CommentDelete( comment )
    Comment *comment;
{
    if( comment ) {
	if (comment->name) OOGLFree(comment->name);
	if (comment->type) OOGLFree(comment->type);
	if (comment->data) OOGLFree(comment->data);
    }
}

Comment *
CommentCopy( Comment *comment ) 
{
  register Comment *nc;
  int datalength = comment->length;

  if (datalength == 0) datalength = strlen(comment->data)+1;
  nc = OOGLNewE(Comment, "CommentCopy: Comment");
  GGeomInit(nc, comment->Class, comment->magic, NULL);
  nc->name = OOGLNewNE(char, strlen(comment->name)+1, "Comment name");
  nc->type = OOGLNewNE(char, strlen(comment->type)+1, "Comment type");
  nc->data = OOGLNewNE(char, datalength, "Comment data");
  strcpy(nc->name, comment->name);
  strcpy(nc->type, comment->type);
  nc->length = comment->length;
  strcpy(nc->data, comment->data);
  return(nc);
}

Comment *
CommentCreate ( Comment *exist, GeomClass *classp, va_list a_list )
{
    register Comment *comment;
    int attr;
    int fourd = 0;
    int copy = 1;
    float *f;
    Transform *t;
    Geom *g;
    Handle *h;

    if (exist == NULL) {
	comment = OOGLNewE(Comment, "CommentCreate comment");
	GGeomInit (comment, classp, COMMENTMAGIC, NULL);
	comment->name = NULL;
	comment->type = NULL;
	comment->length = 0;
	comment->data = NULL;
    } else {
	/* Check that exist is an comment. */
	comment = exist;
    }

    while (attr = va_arg (a_list, int)) {
	switch(attr) {
	default:
	    if(GeomDecorate(comment, &copy, attr, &a_list)) {
		OOGLError (0, "CommentCreate: Undefined option: %d", attr);
		if(exist == NULL) GeomDelete ((Geom *)comment);
		return NULL;
	    }
	}
    }

    return comment;
}
