/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bezierP.h"

BBox *
BezierBound( bezier, T )
    register Bezier *bezier;
    Transform T;
{
    register float *p;
    register int v, n;
    HPoint3 min, max;

    /* only support 3 and 4 dimn patches */
    if(bezier->dimn == 4) {
	/* It may not make sense to find the bbox of these 4-D control points.
	 * Dice it into a real mesh and take the bbox of that.
	 */
	if(bezier->flag & BEZ_REMESH ||
	   bezier->mesh == NULL || bezier->mesh->p == NULL) {
	    if(BezierReDice(bezier) == NULL)
		return NULL;		/* Oh no */
	}
	return MeshBound( bezier->mesh, T );
    }

    if (bezier->dimn != 3) {
       GeomError(0,"BezierBound: invalid dimension %d",bezier->dimn);
       return(NULL);
    }

    n = (bezier->degree_u + 1) * (bezier->degree_v + 1);

    p = bezier->CtrlPnts;
    Pt3Transform( T, p, &min );
    min.w = 1;
    max = min;
    for( v = n; --v > 0; ) {
	Point3 t;

	p += 3;
	Pt3Transform( T, p, &t );
	if(min.x > t.x) min.x = t.x;
	else if(max.x < t.x) max.x = t.x;
	if(min.y > t.y) min.y = t.y;
	else if(max.y < t.y) max.y = t.y;
	if(min.z > t.z) min.z = t.z;
	else if(max.z < t.z) max.z = t.z;
    }

    return (BBox *) GeomCCreate (NULL, BBoxMethods(), CR_MIN, &min, CR_MAX, &max, NULL);
}
