/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

/*-----------------------------------------------------------------------
 * Function:	Tm3Tetrad
 * Description:	create a matrix with given vectors as rows
 * Args:	T: the created matrix (OUTPUT)
 *		x: row 1 (INPUT)
 *		y: row 2 (INPUT)
 *		z: row 3 (INPUT)
 *		w: row 4 (INPUT)
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 13:06:48 1991
 * Notes:	
 */
void
Tm3Tetrad( Transform3 T, HPoint3 *x, HPoint3 *y, HPoint3 *z, HPoint3 *w )
{
    T[TMX][TMX] = x->x;
    T[TMX][TMY] = x->y;
    T[TMX][TMZ] = x->z;
    T[TMX][TMW] = x->w;

    T[TMY][TMX] = y->x;
    T[TMY][TMY] = y->y;
    T[TMY][TMZ] = y->z;
    T[TMY][TMW] = y->w;

    T[TMZ][TMX] = z->x;
    T[TMZ][TMY] = z->y;
    T[TMZ][TMZ] = z->z;
    T[TMZ][TMW] = z->w;

    T[TMW][TMX] = w->x;
    T[TMW][TMY] = w->y;
    T[TMW][TMZ] = w->z;
    T[TMW][TMW] = w->w;
}

void
Tm3Tetrad3( Transform3 T, Point3 *x, Point3 *y, Point3 *z, Point3 *w )
{
    T[TMX][TMX] = x->x;
    T[TMX][TMY] = x->y;
    T[TMX][TMZ] = x->z;
    T[TMX][TMW] = 0;

    T[TMY][TMX] = y->x;
    T[TMY][TMY] = y->y;
    T[TMY][TMZ] = y->z;
    T[TMY][TMW] = 0;

    T[TMZ][TMX] = z->x;
    T[TMZ][TMY] = z->y;
    T[TMZ][TMZ] = z->z;
    T[TMZ][TMW] = 0;

    T[TMW][TMX] = w->x;
    T[TMW][TMY] = w->y;
    T[TMW][TMZ] = w->z;
    T[TMW][TMW] = 1;
}
