/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

/*-----------------------------------------------------------------------
 * Function:	Tm3Conjugate
 * Description:	conjugate one transform by another
 * Args:	T: one transform ("conjugatee") (INPUT)
 *		Tcon: another transform ("conjugater") (INPUT)
 *		Tres: the result
 * Returns:	nothing
 * Author:	mbp
 * Date:	Thu Aug  8 15:42:41 1991
 * Notes:	Sets Tres = Inverse[Tcon} * T * Tcon
 */
void
Tm3Conjugate( T, Tcon, Tres )
    Transform3 T, Tcon, Tres;
{
    Transform3 Tconinv;

    /* We actually use adjoint instead of inverse, because the det
       factors would cancel out anyway */
    Tm3Adjoint( Tcon, Tconinv );
    Tm3Concat( Tconinv, T, Tres );
    Tm3Concat( Tres, Tcon, Tres );
}
