/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

void
Tm3AlignX( Transform3 T, Point3 *axis )
{
    Tm3Align( T, axis, &TM3_XAXIS );
}

void
Tm3AlignY( Transform3 T, Point3 *axis )
{
    Tm3Align( T, axis, &TM3_YAXIS );
}

void
Tm3AlignZ( Transform3 T, Point3 *axis )
{
    Tm3Align( T, axis, &TM3_ZAXIS );
}

void
Tm3Align( Transform3 T, Point3 *axis, Point3 *newaxis )
{
    Transform3 Tr;
    Transform3 Tinv;
    Point3 o, zaxis, yaxis, newyaxis;
    
    o.x = o.y = o.z = 0.;

    Pt3Cross( axis, newaxis, &zaxis );

    Pt3Cross( &zaxis, axis, &yaxis );
    Pt3Cross( &zaxis, newaxis, &newyaxis );

    Pt3Unit(axis);
    Pt3Unit(&yaxis);
    Pt3Unit(&zaxis);

    Tm3Tetrad3( T, axis, &yaxis, &zaxis, &o );
    Tm3Invert( T, Tinv );

    Pt3Unit(newaxis);
    Pt3Unit(&newyaxis);

    Tm3Tetrad3( Tr, newaxis, &newyaxis, &zaxis, &o );

    Tm3Concat(Tinv, Tr, T);
}
