/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

/* pre-multiply a matrix by scale
 *
 *       ( sx  0  0  0 )      
 *       (  0 sy  0  0 )      
 * [a] = (  0  0 sz  0 ) * [a]
 *       (  0  0  0  1 )      
 */
void
Ctm3Scale( Transform3 T, float sx, float sy, float sz )
{
    register Tm3Coord *aptr;

    aptr=T[0];

    /* row 1 */
    *aptr++ *= sx;
    *aptr++ *= sx;
    *aptr++ *= sx;
    *aptr++ *= sx;

    /* row 2 */
    *aptr++ *= sy;
    *aptr++ *= sy;
    *aptr++ *= sy;
    *aptr++ *= sy;

    /* row 3 */
    *aptr++ *= sz;
    *aptr++ *= sz;
    *aptr++ *= sz;
    *aptr++ *= sz;

    /* row 4 is unchanged */
}
