/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "color.h"

void
MergeIn( ColorA *f, ColorA *b,ColorA * t )
{
    register float a = b->a;

    t->r = a * f->r;
    t->g = a * f->g;
    t->b = a * f->b;
    t->a = a * f->a;
}

void
MergeInN( ColorA *f,ColorA * b,ColorA * t,int n )
{
    register float a;
    
    while( n-- ) {
        a = b->a;
	t->r = a * f->r;
	t->g = a * f->g;
	t->b = a * f->b;
	t->a = a * f->a;
	f++;
	b++;
	t++;
    }
}
