#include <stdio.h>
#include <string.h>
#include "geom.h"
#include "lisp.h"
#include "pickfunc.h"
#include "crayola.h"
#include "ui.h"

Lake *lake;

static Geom *undoGeom = NULL;
static char *undoID = NULL;

static char msg[] = "callbacks.c";

#define PICK_YES		"(interest (pick self))"
#define PICK_NO			"(uninterest (pick self))"

void SetUndo(Geom *g, char *name) {
  if (undoGeom != NULL) GeomDelete(undoGeom);
  if (undoID != NULL) OOGLFree(undoID);
  undoGeom = GeomCopy(g);
  undoID = OOGLNewNE(char, strlen(name) + 1, msg);
  strcpy(undoID, name);
}

Geom *GetObject(char *name) {
  printf("(echo \"{\")");
  printf("(write geometry - %s bare)", name);
  printf("(echo \"}\")");
  fflush(stdout);
  return GeomFLoad(stdin, NULL);
}

Geom *GetTarget() {
  return GetObject("targetgeom");
}

void ReplaceObject(Geom *g, char *name) {
  if (g == NULL) return;
  printf("(geometry %s ", name);
  GeomFSave(g, stdout, NULL);
  printf(")");
  printf("(redraw allcams)");
  fflush(stdout);
}

void ReplaceTarget(Geom *g) {
  ReplaceObject(g, "targetgeom");
}

void freeze() {
  uiFreeze();
  printf(PICK_NO);
  fflush(stdout);
}

void thaw() {
  printf("(echo \"(ack)\\n\")");
  fflush(stdout);
}

LDEFINE(ack, LVOID,
	 "(ack)\n\
Command sent back from Geomview indicating that everything has been\n\
processed")
{
  LDECLARE(("ack", LBEGIN,
	    LEND));
  printf(PICK_YES);
  fflush(stdout);
  uiThaw();
  return Lt;
}

DEFPICKFUNC("(pick COORDSYS GEOMID G V E F P VI EI FI)",
	    coordsys,
	    id,
	    point, pn,
	    vertex, vn,
	    edge, en,
	    face, fn, 10,
	    ppath, ppn, 50,
	    vi,
	    ei, ein,
	    fi,
{
  Geom *g;
  ColorA color;
  int setcolor = 0;
  int vcolor;
  int fcolor;  

  if (!pn) return Lt;
  freeze();
  g = GetObject(id);
  if (uiSet() || uiSetAll()) {
    if (crayHasColor(g, ppath)) {
      setcolor = 1; 
      vcolor = fcolor = 0;
    }
    else {
      vcolor = crayCanUseVColor(g, ppath);
      fcolor = crayCanUseFColor(g, ppath);
      if ((vcolor || fcolor) && 
	  !uiQuery("Object currently has no color", 
		   "information.  Would you",
		   "like to add color information to it?", "yes", "no")) {
	if (vcolor && fcolor) {
	  vcolor = uiQuery("Would you like to color the",
			   "object by face or", "by vertex?", 
			   "By Face", "By Vertex");
	  fcolor = vcolor ? 0 : 1;
	}
	setcolor = 1;
      }
    }
    if (setcolor) {
      uiCurrentColor(&color);
      SetUndo(g, id);
      if (vcolor) crayUseVColor(g, &crayDefColor, ppath);
      else if (fcolor) crayUseFColor(g, &crayDefColor, ppath);
      if (uiSetAll()) craySetColorAll(g, &color, ppath);
      else craySetColorAt(g, &color, vi, fi, ei, ppath, &vertex);
      ReplaceObject(g, id);
    }
  }
  else if (uiGet() && crayGetColorAt(g, &color, vi, fi, ei, ppath, &vertex))
    uiChangeColor(&color);
  else if (uiEliminateColor()) {
    SetUndo(g, id);
    if (crayEliminateColor(g, ppath)) ReplaceObject(g, id);
  }
  GeomDelete(g);
  thaw();
  return Lt;
})

void init() {
       
       crayolaInit();
     
     LInit();
     LDefun("pick", Lpick, Hpick);
     LDefun("ack", Lack, Hack);
     lake = LakeDefine(stdin, stdout, NULL);
     printf(PICK_YES);
     fflush(stdout);

     uiChangeColor(&crayDefColor);

}

void dopipes() {
  LObject *lit, *val;
  lit = LSexpr(lake);
  val = LEval(lit);
  LFree(lit);
  LFree(val);
}

void checkpipes() {
  if (async_fnextc(stdin, 0) != NODATA) dopipes();
  else {
    static struct timeval tenth = { 0, 100000 };
    select(0, NULL, NULL, NULL, &tenth);
  }
}

int undo() {
       if (undoGeom != NULL) {
	 ReplaceObject(undoGeom, undoID);
	 return 1;
       } else return 0;
   }
     

void quit() {
       if (undoGeom != NULL) GeomDelete(undoGeom);
     if (undoID != NULL) OOGLFree(undoID);
  exit(0);
}

