/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "material.h"
#include "3d.h"

/***********************************************************************
 * a surf is a primitive bit of surface, conveys the geometrical
 * information about an intersection
 ***********************************************************************/

#define SURF_NEEDS_SET(p, n, s)	((n)&(p) && !((s)&(p)))
#define SURF_SET(p, f)		((f) |= (p))

#define	SURF_NONE	0x0
#define SURF_P  	0x1
#define SURF_N  	0x2
#define SURF_NG		0x4
#define SURF_DPDU  	0x8
#define SURF_DPDV  	0x10
#define SURF_UV  	0x20
#define SURF_DUDV  	0x40
#define SURF_ST  	0x80
#define SURF_I  	0x100
#define SURF_CS  	0x200
#define SURF_OS  	0x400

typedef struct surf {
	int	flag ;		/* copied mostly from Renderman */
	Point3	P ;		/* location of the point 	*/
	Point3	dPdu ;		/* derivatives 			*/
	Point3	dPdv ;
	Point3	N ;		/* shading normal vector	*/
	Point3	Ng ;		/* geometric normal		*/
	Point2	uv ;		/* location on the surface	*/
	Point2	dudv ;		/* derivatives of u, v		*/
	Point2	st ;		/* texture coordinates 		*/
	Point3	I ;		/* incident ray direction	*/
	Material mat;
	Transform3 T;
	Geom     *geom;
} Surf ;
