/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef NDMESHPDEF
#define NDMESHPDEF

#include "geomclass.h"
#include "hpointn.h"
#include "ndmesh.h"

struct NDMesh {
	GEOMFIELDS
	int	flag;
	int 	seq;
	int	meshd;		/* mesh dimension */
	int	*mdim;		/* mesh size, indexed 0..meshd-1 */
	int	pdim;		/* dimension of space where mesh points live */
	HPointN	**p;		/* N-D vertices; dim[0] axis varies fastest */
	ColorA	*c;		/* vertex colors, indexed likewise */
	Point3	*u;		/* texture coordinates, should we need any */
};

/* NOTE that these meshes may have missing vertices; some of the p[]
 * and c[] entries may be NULL.
 */


/*
 * mesh indexing:
 *  given a mesh index vector (of length 'meshd') i[0] i[1] ... i[meshd-1]
 * the corresponding index into the p[] and c[] arrays is given by
 *  index = 0;  size = 1;
 *  for(k = 0; k < meshd; k++) { index += size*i[k];  size *= dim[k]; }
 */

#endif /* ! NDMESHPDEF */
