/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef CR_DEF
#define CR_DEF

#include <stdarg.h>	/* So we only have to do it once, here. */

	/* Generic attributes */
#define	CR_END		0	/* Marks end of create list (any object) */
#define CR_COPY		1	/* no argument  (any object)		*/
#define CR_NOCOPY	2	/* no argument  (any object)		*/
#define CR_HANDLE	3	/* Handle *	(any object)		*/

	/* Generic Geom attributes */
#define CR_APPEAR	8	/* marks beginning of Appearance create list) */

#define CR_POINT	9	/* Point3 []	(any Geom with vertices) */
#define CR_POINT4	18	/* HPoint3 []	(any Geom with 4D vertices) */
#define CR_NORMAL	10	/* Point3 []	(any Geom w/per-vtx normals) */
#define CR_COLOR	11	/* ColorA []	(any Geom w/per-vtx colors) */
#define CR_OPACITY	12	/* XXX Not used yet XXX		*/

#define CR_FLAG		13	/* int flags	(patch,Mesh,PolyList,Quad) */
#define	CR_FLAGMERGE	14	/* int flags, int flagmask		*/
	/* Control of 'override' mask for mergeable things (Appearance)	*/
#define	CR_OVERMERGE	15	/* int override, int ovmask		*/

	/* BBox attributes */
#define CR_MAX		16	/* Point3 *	(BBox)			*/
#define CR_MIN		17	/* Point3 *	(BBox)			*/
#define CR_4MAX		1492	/* HPoint3 *	(BBox)			*/
#define CR_4MIN		1066	/* HPoint3 *	(BBox)			*/

#define CR_4D		19	/* is this object a true 4D item?	*/

	/* Hierarchy object (Inst, List, TList) attributes */
#define CR_AXIS		20	/* Transform	(Inst)			*/
#define CR_GEOM		21	/* Geom *child	(Inst,List)		*/
#define	CR_GEOMHANDLE	22	/* Handle *childname (Inst,List)	*/
#define CR_TLIST	23	/* Geom *tlist	   (Inst,TList)		*/
#define	CR_TLISTHANDLE	24	/* Handle *tlistname (Inst,TList) 	*/
#define CR_ELEM		25	/* Transform []	(TList)			*/
#define CR_NELEM	26	/* int nxforms(TList), int nquads (Quad) */
#define CR_CDR		27	/* List *	(List) (obsolescent?)	*/
#define	CR_AXISHANDLE	28	/* Handle * to TransObj (for Inst)	*/
#define CR_HANDLE_GEOM  29	/* Handle *, Geom *	(Inst, List)	*/
#define	CR_CAR		CR_GEOM	/* Geom *	(List) (obsolescent)	*/
#define	CR_UNIT		CR_GEOM /* Geom *	(Inst) (obsolescent)	*/
#define	CR_LOCATION	201	/* int		(Inst) L_LOCAL, L_CAMERA, ...*/

	/* Mesh attributes */
#define CR_NU		30	/* int nu	(Mesh)			*/
#define CR_NV		31	/* int nv	(Mesh)			*/
#define	CR_UWRAP	32	/* int uwrapped	(Mesh)			*/
#define	CR_VWRAP	33	/* int vwrapped	(Mesh)			*/
#define CR_U		34	/* Point3 texturecoords[] (Mesh)	*/

#define CR_UMIN		35	/* int umin	(Mesh) [submesh]	*/
#define CR_UMAX		36	/* int umax	(Mesh)			*/
#define CR_VMIN		37	/* int vmin	(Mesh) 			*/
#define CR_VMAX		38	/* int vmax	(Mesh)			*/

	/* Patch attributes */
#define CR_DEGU		40	/* int u_degree	(patches)		*/
#define CR_DEGV		41	/* int v_degree	(patches)		*/
#define CR_MESH		42	/* Mesh *	(patches)		*/
#define CR_DIM		43	/* int vertex_dim (= 3 or 4) (patches)	*/
#define	CR_ST		44	/* struct { float s, t; } stcoords[4];	*/
				/* (texture coords at corners (Mesh,Patch) */
#define	CR_MESHDIM	45	/* mesh surface dimension (typ. 2)	*/
#define	CR_MESHSIZE	46	/* int meshsize[meshdim] 	 	*/

	/* Vect attributes */
#define CR_NVECT	48	/* int  nvectors (Vect)			*/
#define CR_NVERT	49	/* int nvertices (Vect)			*/
#define CR_NCOLR	50	/* int ncolors  (Vect)			*/
#define CR_VECTC	51	/* short nverts_per_vector[nvect] (Vect)*/
#define CR_COLRC	52	/* short ncolors_per_vector[nvect] (Vect)*/

	/* PolyList attributes */
#define CR_NPOLY        56	/* int npolygons	(PolyList)	*/
/*      CR_NVERT	(48)	   int nvertperpol[npoly]		*/
#define CR_VERT         57	/* int vertindex[sum(nvertperpol[])]	*/
#define CR_POLYNORMAL   58	/* Point3 facenormal[npoly]		*/
#define CR_POLYCOLOR    59	/* ColorA facecolor[npoly]		*/

	/* Sphere attributes */
#define CR_CENTER		60	/* HPoint3 *center		*/
#define CR_RADIUS		61	/* float  radius		*/
#define CR_SPACE		64	/* Space - TM_EUCLIDEAN is default */
#define CR_NENCOMPASS_POINTS	65	/* int - Number of points to be
					 * put inside sphere */
#define CR_ENCOMPASS_POINTS	66	/* Hpoint3 * - points to be inside
					 * sphere (for bounding spheres */
/*      CR_AXIS			20	Transform to apply to points before
					making bounding sphere */

/* tokens for Camera moved to camera.h */

/* tokens for Appearances, Lights, Materials moved to shade/appearance.h */

#define	CR_POLICE	62	/* enforce strong checking on input data? */
#define	CR_NOPOLICE	63	/* enforce strong checking on input data? */



#endif
