/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef	BBOXDEF
#define BBOXDEF

#include "geom.h"

#define BBOXMAGIC GeomMagic ('x', 1)

typedef struct BBox BBox;

extern GeomClass *BBoxMethods( void );
extern char	*BBoxName( void );
extern BBox	*BBoxBound( BBox *, Transform );
extern BBox	*BBoxDraw( BBox * );
extern BBox	*BBoxTransform( BBox *, Transform );	/* Overwrites input! */
extern BBox	*BBoxMinMax( BBox *, HPoint3 *min, HPoint3 *max );
extern BBox	*BBoxUnion( BBox *, BBox * );
extern BBox	*BBoxUnion3( BBox *b1, BBox *b2, BBox *result );

#ifdef GEOM_SM
extern int	 BBoxShare( Geom *obj, GeomSMRegion *sm );
extern BBox	*BBoxPrivate();
#endif

#endif
