static char rcsid[] = "$Id: signal.c,v 1.5 1997/07/18 20:05:56 dhb Exp $";

/*
** $Log: signal.c,v $
** Revision 1.5  1997/07/18 20:05:56  dhb
** Changes from PSC: T3E support
**
** Revision 1.4  1995/06/13  20:51:32  dhb
** SetSignals() now causes SIGPIPE to be ignored.  ClearSignals() returns
** to the default SIGPIPE behavior.
**
** Revision 1.3  1995/03/21  01:07:58  venkat
** Added Linux ifdef for signal SIGFPE in SetSignals()
**
** Revision 1.2  1993/09/17  20:49:59  dhb
** Solaris compatability.
**
** Revision 1.1  1992/12/11  19:05:36  dhb
** Initial revision
**
*/

#include <stdio.h>
#include <math.h>
#include <signal.h>

/* mds3 changes */
/*
** Multiple casts to 'void*' made in calls to 'signal()'
*/

extern int harmless_sig();
extern int restore_context();
extern int sig_msg_restore_context();

SetSIGQUIT()
{

    signal(SIGQUIT,(void*)sig_msg_restore_context);
}

SetSignals()
{

    signal(SIGINT,(void*)restore_context);
    SetSIGQUIT();
    signal(SIGQUIT,SIG_IGN);
    signal(SIGSEGV,(void*)sig_msg_restore_context);
    signal(SIGILL,(void*)sig_msg_restore_context);
#ifdef Linux
    signal(SIGFPE,sig_msg_restore_context);
#endif
    signal(SIGBUS,(void*)sig_msg_restore_context);
    signal(SIGTRAP,(void*)sig_msg_restore_context);
    signal(SIGPIPE,SIG_IGN);
}

ClearSignals()
{
    signal(SIGINT,SIG_DFL);
    signal(SIGQUIT,SIG_DFL);
    signal(SIGSEGV,SIG_DFL);
    signal(SIGILL,SIG_DFL);
    signal(SIGFPE,SIG_DFL);
    signal(SIGBUS,SIG_DFL);
    signal(SIGPIPE,SIG_DFL);
}

harmless_sig(sig,code)
int sig,code;
{
	switch(sig){	
	case SIGSEGV :
		printf("segmentation violation\n");
		break;
	case SIGFPE :
		printf("floating point exception. code = %d\n",code);
		break;
	case SIGILL :
		printf("illegal instructio. code = %d\n",code);
		signal(SIGILL,(void*)harmless_sig);
		break;
	}
}

CoreRequest()
{
        if (IsBatchMode())    /* added by Greg Hood, PSC, May 1996 */
         abort(); 

	printf("core dump (y/n) n? ");
	normal_tty();
	if(getchar() == 'y'){
	    signal(SIGQUIT,SIG_DFL);
	    kill(getpid(),SIGQUIT);
	}
	tset();
}

#ifdef Solaris
sig_msg(sig,code)
int           sig,code;
{
long clock;
char *name;

    switch(sig){
    case SIGSEGV :
          printf("segmentation violation\n");
          CoreRequest();
          break;
    case SIGILL :
          printf("illegal instruction. code = %d\n",code);
          signal(SIGILL,(void*)sig_msg_restore_context);
          CoreRequest();
          break;
    case SIGFPE :
          printf("floating point exception. code = %d\n",code);
          CoreRequest();
          break;
    case SIGBUS :
          printf("bus error\n");
          CoreRequest();
          break;
    case SIGTRAP :
          printf("trace trap\n");
          CoreRequest();
          signal(SIGTRAP,(void*)sig_msg_restore_context);
          break;
    default:
          printf("Fatal error *** sig %d : code %d\n",sig,code);
          CoreRequest();
          break;
    }
    printf("exit program (y/n) n? ");
    normal_tty();
    if(getchar() == 'y'){
#ifdef T3E
      globalexit(0);
#else
      exit(0);
#endif
    }
    tset();
}
#else
sig_msg(sig,code,scp)
int		sig,code;
struct sigcontext *scp;
{
long clock;
char *name;

    switch(sig){	
    case SIGSEGV :
	    printf("segmentation violation\n");
	    CoreRequest();
	    break;
    case SIGILL :
	    printf("illegal instruction. code = %d\n",code);
	    signal(SIGILL,(void*)sig_msg_restore_context);
	    CoreRequest();
	    break;
    case SIGFPE :
	    printf("floating point exception. code = %d\n",code);
	    CoreRequest();
	    break;
    case SIGBUS :
	    printf("bus error\n");
	    CoreRequest();
	    break;
    case SIGTRAP :
	    printf("trace trap\n");
	    CoreRequest();
	    signal(SIGTRAP,(void*)sig_msg_restore_context);
	    break;
    default:
	    printf("Fatal error *** sig %d : code %d\n",sig,code);
	    CoreRequest();
	    break;
    }
    printf("exit program (y/n) n? ");
    normal_tty();
    if(getchar() == 'y'){
#ifdef T3E
        globalexit(0);
#else
	exit(0);
#endif
    }
    tset();
}
#endif
