static char rcsid[] = "$Id: hash.c,v 1.1 1992/12/11 19:05:29 dhb Exp $";

/*
** $Log: hash.c,v $
** Revision 1.1  1992/12/11 19:05:29  dhb
** Initial revision
**
*/

#include <stdio.h>
#include <math.h>
#ifdef IRIS
#include <strings.h>
#else
#include <string.h>
#endif
#include "hash.h"
/* mds3 changes */
#include "system_deps.h"

/*
** put in wraparound during the hash entry and search
*/

hash_function(key,table)
char *key;
HASH *table;
{
int val = 0;

	while(*key != '\0'){
		val += (*key | *(key+1) << 8);
		key++;
	}
	return(val % table->size);
}

HASH *hash_create(size)
int size;
{
HASH *hash_table;

	hash_table = (HASH *)calloc(size,sizeof(HASH));
	hash_table->size = size;
	hash_table->entry = (ENTRY *)calloc(size+1,sizeof(ENTRY));
	return(hash_table);
}

ENTRY *hash_find(key,table)
char *key;
HASH *table;
{
int size;
ENTRY *hash_ptr;
ENTRY *start_ptr;

	if(key == NULL || table == NULL) return(NULL);
	start_ptr = hash_ptr = table->entry + hash_function(key,table);
	size = table->size;
	while(hash_ptr->key){
		if(strcmp(key,hash_ptr->key) == 0){
			return(hash_ptr);
		}
		if(++hash_ptr >= table->entry + size) hash_ptr = table->entry;
		if(hash_ptr == start_ptr){
			return(NULL);
		}
	}
	return(NULL);
}

ENTRY *hash_enter(item,table)
ENTRY *item;
HASH *table;
{
int size;
ENTRY *hash_ptr;
ENTRY *start_ptr;
char *key;

	if(item == NULL || table == NULL) return(NULL);
	/*
	** look for the next available spot
	*/
	key = item->key;
	start_ptr = hash_ptr = table->entry + hash_function(key,table);
	size = table->size;
	while(hash_ptr->key){
		/*
		** copy over existing keys if they exist
		*/
		if(strcmp(key,hash_ptr->key) == 0){
			break;
		}
		if(++hash_ptr >= table->entry + size) hash_ptr = table->entry;
		if(hash_ptr == start_ptr){
			return(NULL);
		}
	}
	/*
	** leave the last entry empty to identify the end of the table
	*/
	bcopy(item,hash_ptr,sizeof(ENTRY));
	return(hash_ptr);
}

