/* $Id: synaptic_event.h,v 1.2 1997/08/12 22:22:26 dhb Exp $
** $Log: synaptic_event.h,v $
** Revision 1.2  1997/08/12 22:22:26  dhb
** Removed short qulaified from bitfield declatations in synaptic_event.
** This is an over specification which some compilers complain about.
**
** Revision 1.1  1995/01/11 23:09:02  dhb
** Initial revision
**
*/

/* 
 * The synaptic event structure is defined here rather than in the struct.h
 * file because the use of bit fields causes problems otherwise.
 * The alloced field designates whether or not this node
 * was the first node in a malloc'ed group of nodes.  This is used
 * in freeing the nodes later.
 */

typedef struct SynapticEvent_type SynapticEvent;

struct SynapticEvent_type {
    unsigned       alloced:1;   
    unsigned       syn_num:15;
    unsigned int   time;
    SynapticEvent *next;
};

extern void FreeSynapticEventLists();
extern int  AllocateSynapticEventNodes();

