static char rcsid[] = "$Id: hines_solve.c,v 1.1 1997/05/28 23:11:50 dhb Exp $";

/* Version EDS21e 97/05/05, Erik De Schutter, Caltech & BBF-UIA 4/92-5/97 */

/*
** $Log: hines_solve.c,v $
** Revision 1.1  1997/05/28 23:11:50  dhb
** Initial revision
**
*/

/* Contains the second loops executed when chanmode>1:
** - a loop which executes the funcs array (do_crank_hsolve or
**     do_euler_hsolve): solve 13.18 of Mascagni. 
** in case of chanmode==2, a last loop updates Vm values (do_vm_update)
** First loop is in hines_chip.c
*/

#include "hines_ext.h"

/* trivial function that just loops over the funcs array and
** performs the ops. */
/* performs also final Crank-Nicolson interpolation */
/* interlaces parallel communication with loop */
do_crank_hsolve(hsolve)
    Hsolve  *hsolve;
{
    register int     *funcs=hsolve->funcs;
    register double  temp,resultval,diaval;
    register double  *results=hsolve->results;
    register double  *ravals=hsolve->ravals;
    register double  *vm,*resultvalue;
    register int     op;

    vm = hsolve->vm + hsolve->ncompts;
    resultvalue=results;
    resultval=*resultvalue;
    /* first instruction is SET_DIAG, combined with initialization */
    diaval=*(resultvalue+1);

    while(1) {
        op= *funcs++;
        if (op == ARRAY_ELIM){	/* FORWARD_ELIM and BACKWARD_ELIM */
            results[*funcs++] -= *ravals++ * temp;
        } else if (op == SCALE){
            temp = *ravals++ / diaval;
            results[*funcs++] -= resultval * temp;
        } else if (op == CALC_RESULTS){
            temp = *resultvalue / *(resultvalue+1);
            resultvalue-=2;
	    vm--;
	    *vm = temp + temp - *vm;
        } else if (op == SET_DIAG){
            resultvalue+=2;
	    resultval=*resultvalue;
	    diaval=*(resultvalue+1);
        } else if (op == FINISH){
            break;
        }
    }
}

/* Simple function for putting data values back into elements,
** when the chip array is being used */
do_vm_update(hsolve)
	Hsolve	*hsolve;
{
	register struct compartment_type **compts;
	register int	*elmnum;
	register double	*vm;

	compts = (struct compartment_type **)(hsolve->compts);
	elmnum = hsolve->elmnum;
	vm = hsolve->vm;

	/* update all comp values */
	for(vm=hsolve->vm;vm<&(hsolve->vm[hsolve->ncompts]);vm++) {
		compts[*elmnum++]->Vm = *vm;
	}
}

/* trivial function that just loops over the funcs array and
** performs the ops. */
/* performs also final Euler storage */
/* interlaces parallel communication with loop */
do_euler_hsolve(hsolve)
    Hsolve  *hsolve;
{
    register int     *funcs=hsolve->funcs;
    register double  temp,resultval,diaval;
    register double  *results=hsolve->results;
    register double  *ravals=hsolve->ravals;
    register double  *vm,*resultvalue;
    register int     op;

    vm = hsolve->vm + hsolve->ncompts;
    resultvalue=results;
    resultval=*resultvalue;
    /* first instruction is SET_DIAG, combined with initialization */
    diaval=*(resultvalue+1);

    while(1) {
        op= *funcs++;
        if (op == ARRAY_ELIM){  /* FORWARD_ELIM and BACKWARD_ELIM */
            results[*funcs++] -= *ravals++ * temp;
        } else if (op == SCALE){
            temp = *ravals++ / diaval;
            results[*funcs++] -= resultval * temp;
        } else if (op == CALC_RESULTS){
            vm--;
            *vm = temp = *resultvalue / *(resultvalue+1);
            resultvalue-=2;
        } else if (op == SET_DIAG){
            resultvalue+=2;
            resultval=*resultvalue;
            diaval=*(resultvalue+1);
        } else if (op == FINISH){
            break;
        }
    }
}

