/*********************************************************************

** This library uses the netcdf - version 2.4.3 which is
** Copyright 1993-1997 University Corporation for Atmospheric Research/Unidata

** The netcdf library is provided as per the terms of the
** UCAR/Unidata license

** See netcdf-2.4.3/COPYRIGHT for the full notice

********************************************************************/
/* $Id: absff_utilfunc.c,v 1.2 1997/07/26 00:15:24 venkat Exp $ */
/* $Log: absff_utilfunc.c,v $
 * Revision 1.2  1997/07/26 00:15:24  venkat
 * Added-Copyright-notice-and-RCS-headers
 * */

#include <stdio.h>
#include <malloc.h>
#include <sys/types.h>

#include "netcdf_ext.h"

void * Netcdf_AllocValues(type, size)
 Abs_Type type;
 int size;
{
 nc_type ntype;
 void *retval;

 ntype = nc_type_To_Abs_Type(type);
 retval = NULL;

 switch (ntype){

        case NC_BYTE:
                        retval = (char*) malloc(size * sizeof(char));
                        break;
        case NC_SHORT:
                        retval = (short*) malloc(size * sizeof(short));
                        break;

        case NC_LONG:
                        retval = (nclong*) malloc(size * sizeof(nclong));
 			break;

        case NC_FLOAT:
                        retval = (float*) malloc(size * sizeof(float));
                        break;

        case NC_DOUBLE:

                        retval = (double*) malloc(size * sizeof(double));
                        break;
        case NC_CHAR:

                        retval = (char*) malloc(size * sizeof(char));
                        break;
        default:

                        break;
 }

 return retval;

}

void * Netcdf_ReallocValues(val, type, size)
 void *val;
 Abs_Type type;
 int size;
{
 nc_type ntype;

 if(val == NULL) return val;
 ntype = nc_type_To_Abs_Type(type);

 switch (ntype){

        case NC_BYTE:
                        val = (char*) realloc(val, size * sizeof(char));
                        break;
        case NC_SHORT:
                        val = (short*) realloc(val, size * sizeof(short));
                        break;


	case NC_LONG:
                        val = (nclong*) realloc(val, size * sizeof(nclong));
                        break;

        case NC_FLOAT:
                        val = (float*) realloc(val, size * sizeof(float));
                        break;

        case NC_DOUBLE:

                        val = (double*) realloc(val, size * sizeof(double));
                        break;
        case NC_CHAR:

                        val = (char*) realloc(val, size * sizeof(char));
                        break;
        default:

                        break;
 }

 return val;

}

Abs_Varshape * Absff_ConstructDefaultShape(domainname)
 char *domainname;
{
  Abs_Varshape *shape;
 
        shape = (Abs_Varshape *) malloc(1*sizeof(Abs_Varshape));
        shape->ndomains = 1;
        shape->domainname = (char **) malloc(1*sizeof(char*));
        shape->domainname[0] = Absff_CopyString(domainname);
        shape->domaintype = (byte *) malloc(1*sizeof(byte));
        shape->domaintype[0] = DYNAMICSIZECOMPONENT;
        shape->domainsize = (long *) malloc(1*sizeof(long));
        shape->domainsize[0] = 0;

        return shape;
}
                                                                  
void Absff_DestructDefaultShape(pshape)
 Abs_Varshape **pshape;
{
        free((*pshape)->domaintype);
        free((*pshape)->domainsize);
        Absff_FreeString((*pshape)->domainname[0]);
        free((*pshape)->domainname);
        free(*pshape);
}


void *Netcdf_Convert_To_nc_type(vals, type, size)
 void *vals;
 Abs_Type type;
 int size;
{
 nc_type ntype;
 void *retvals;

 nclong *nclong_retvals;
 int *int_vals;
 int i, sz;

 if(vals == NULL) return NULL;

 ntype = Abs_Type_To_nc_type(type);
 sz = (size == 0)? 1: size; 

 switch (ntype){
	case NC_LONG:
		int_vals = (int *)vals;
		retvals = (nclong *) malloc(sz * sizeof(nclong));
		nclong_retvals = (nclong *)retvals;
		for(i=0; i<sz; i++)
			nclong_retvals[i] = int_vals[i];
		break;

	case NC_INVALID:
		retvals = NULL;
		break;
	
	default:
		retvals = vals;
		break;
 }
		
 return retvals;	
}

nc_type Abs_Type_To_nc_type(type)
 Abs_Type type;
{
 return netcdf_type[(int)type];
}  

Abs_Type nc_type_To_Abs_Type(ntype)
 nc_type ntype;
{
 switch (ntype){
	
	case NC_BYTE:
			return abs_int8;
			break;
	case NC_SHORT:
			return abs_int16;
			break;

	case NC_LONG:
			return abs_int32;
			break;
	
	case NC_FLOAT:
			return abs_float32;
			break;

	case NC_DOUBLE:

			return abs_float64;
			break;
	case NC_CHAR:

			return abs_char8;	
			break;
	default:

			return (Abs_Type)-1;
			break;
 }
}


char* Absff_CopyString(str)
 char *str;
{
 char *ret;
 int len;

 if(str == NULL) return NULL;

 len = strlen(str)+1;
 ret = (char *) malloc(len*sizeof(char));
 strcpy(ret, str);
 return ret;
}

void Absff_FreeString(str)
 char *str;
{
 if(str == NULL) return;
 free(str);
}

float Absff_Atof(s)
 char *s;
{
 float f;
 if(sscanf(s, "%f", &f) > 0)
	return f;
 else
	return 0.0;
}

double Absff_Atod(s)
 char *s;
{
 double d;
 if(sscanf(s, "%lf", &d) > 0)
	return d;
 else
	return 0.0; 
}

long Absff_Atol(s)
 char *s;
{
 long l;
 if(sscanf(s, "%ld", &l) > 0)
	return l;
 else
	return 0.0;
}
