/* $Id */
/* $Log: xo_cmds.c,v $
 * Revision 1.12.1.2  1997/07/16 21:26:43  dhb
 * Changed getopt() name to avoid conflicts with unix version
 *
 * Revision 1.12.1.1  1997/06/28 00:07:40  venkat
 * Defined functions xoIsNestedForm() and xoIsNestedOptionSet() that
 * determine if a form is embedded or not.
 *
 * Revision 1.12  1995/08/03  01:04:27  venkat
 * Added function xogetstat() for the xgetstat command and avoided initializing
 * Xodus in xinit() if genesis was invoked with -nox
 *
 * Revision 1.11  1995/05/02  22:00:06  venkat
 * xocolorscale() returns with error message if DISPLAY is not set.
 *
 * Revision 1.10  1995/04/12  18:19:07  venkat
 * Hiding and showing forms also gives the problem of floating forms.
 * So introduced the hack in the CREATE and SET actions for the form
 * in xo_show_on_top() too.
 *
 * Revision 1.9  1995/03/21  01:17:37  venkat
 * Checked for color being supported before attempting to allocate
 * colorscales in xocolorscale()
 *
 * Revision 1.8  1994/12/15  17:33:06  dhb
 * Changed xoFindParentForm() and xoFindParentDraw() which check the
 * object type of an element to check the BaseObject() type of the
 * element.  This allows extended xform and xdraw based objects.
 *
 * Revision 1.7  1994/12/07  18:13:03  venkat
 * Same as 1.6; Just entering log
 * Fixed xmap and xtextload core dumps
 *
 * Revision 1.6  1994/12/06  00:36:04  dhb
 * Nov 8 1994 changes from Upi Bhalla
 *
 * Revision 1.5  1994/05/26  13:49:09  bhalla
 * Added ResizeDraws to the xupdate command so it forces a reprojection
 * of the contents of the draw
 *
 * Revision 1.4  1994/02/08  22:24:44  bhalla
 * Added xoFullName utility func to return element name with index if
 * nonzero, for giving widgets sensible names during create
 *
 * Revision 1.3  1994/02/02  20:26:05  bhalla
 * *** empty log message ***
 * */

#include <string.h>
#include "sim_ext.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "xo_ext.h"
#include "widg/widg_struct.h"
#include <Widg/Form.h>
#include <Draw/CoreDraw.h>
/* 
 * Commands.  Most of these are frontends to the corresponding Xg functions
 */

xinit_defunct()
{
 fprintf(stderr, "xinit is no longer necessary in GENESIS 2.0\n");
}

/* @@SECTION xinit */
xinit (argc, argv)
     int argc;
     char **argv;
{
  extern int GENOPT_NoX;
 if (!GENOPT_NoX)
   XgInitialize();
  /* Add the xodus actions to GENESIS*/
  /* Spiff: I wish I knew what these actions mean. */

    AddAction("B1DOWN",B1DOWN);
    AddAction("B2DOWN",B2DOWN);
    AddAction("B3DOWN",B3DOWN);
    AddAction("ANYBDOWN",ANYBDOWN);
  
    AddAction("B1UP",B1UP);
    AddAction("B2UP",B2UP);
    AddAction("B3UP",B3UP);
    AddAction("ANYBUP",ANYBUP);
  
    AddAction("B1DOUBLE",B1DOUBLE);
    AddAction("B2DOUBLE",B2DOUBLE);
    AddAction("B3DOUBLE",B3DOUBLE);
    AddAction("ANYBDOUBLE",ANYBDOUBLE);
  
    AddAction("NOBMOVE",NOBMOVE);
    AddAction("B1MOVE",B1MOVE);
    AddAction("B2MOVE",B2MOVE);
    AddAction("B3MOVE",B3MOVE);
    AddAction("ANYBMOVE",ANYBMOVE);
  
    AddAction("NOBENTER",NOBENTER);
    AddAction("B1ENTER",B1ENTER);
    AddAction("B2ENTER",B2ENTER);
    AddAction("B3ENTER",B3ENTER);
    AddAction("ANYBENTER",ANYBENTER);
  
    AddAction("NOBLEAVE",NOBLEAVE);
    AddAction("B1LEAVE",B1LEAVE);
    AddAction("B2LEAVE",B2LEAVE);
    AddAction("B3LEAVE",B3LEAVE);
    AddAction("ANYBLEAVE",ANYBLEAVE);
  
    AddAction("KEYPRESS",KEYPRESS);
    AddAction("UPDATEFIELDS",UPDATEFIELDS);
  
    AddAction("XUPDATE",XUPDATE);
    AddAction("XODRAG",XODRAG);
    AddAction("XODROP",XODROP);
    AddAction("XOWASDROPPED",XOWASDROPPED);
    AddAction("XOCOMMAND",XOCOMMAND);
}

/* @@SECTION xverify */

/* This is private and should not be accessed by scripts */
/* utility function to go through the arg checking */
struct xwidg_type *xverify(argc,argv)
     int argc;
     char **argv;
{
	struct xwidg_type	*widg;

	initopt(argc, argv, "widget-element");
	if (G_getopt(argc, argv) != 0) {
		printoptusage(argc, argv);
		return((struct xwidg_type *)NULL);
	}


	widg = (struct xwidg_type *)GetElement(argv[1]);
	if (!widg) {
		printf("error in %s: could not find widget-element %s\n",	
			argv[0],argv[1]);
		return((struct xwidg_type *)NULL);
	}

	/* Check to see if the object is of the widget class */
	if (!CheckClass(widg,ClassID("widget"))) {
		printf("error in %s: element %s is not a widget\n",	
			argv[0],argv[1]);
		return((struct xwidg_type *)NULL);
	}
	return(widg);
}

/* @@SECTION xoraise	 */
xoraise(argc,argv)
     int argc;
     char **argv;
{
	struct xwidg_type	*widg;
	Widget w;
	Boolean xoIsNestedForm(), xoIsNestedOptionSet();
	
	if (widg=xverify(argc,argv)) {
		w=(Widget)(widg->widget);
		if (XtIsSubclass(w,formWidgetClass) && ! (xoIsNestedForm(widg) && xoIsNestedOptionSet(widg)) )
			w=XtParent(XtParent(XtParent(XtParent(w))));
		else
			w=XtParent(w);
		XRaiseWindow(XtDisplay(w),XtWindow(w));
	}
}

/* @@SECTION xolower */
xolower(argc,argv)
     int argc;
     char **argv;
{
	struct xwidg_type	*widg;
	Widget w;
	Boolean xoIsNestedForm(), xoIsNestedOptionSet();
	
	if (widg=xverify(argc,argv)) {
		w=(Widget)(widg->widget);
		if (XtIsSubclass(w,formWidgetClass) && !(xoIsNestedForm(widg) &&xoIsNestedOptionSet(widg)))
			w=XtParent(XtParent(XtParent(XtParent(w))));
		else
			w=XtParent(w);
		XLowerWindow(XtDisplay(w),XtWindow(w));
	}
}

xoshow_on_top(argc,argv)
     int argc;
     char **argv;
{
	struct xwidg_type	*widg;
	struct xform_type	*form;
	Widget w;
	Boolean xoIsNestedForm(), xoIsNestedOptionSet();
	
	if (widg=xverify(argc,argv)) {
		w=(Widget)(widg->widget);
		if (XtIsSubclass(w,formWidgetClass) && !(xoIsNestedForm(widg) && xoIsNestedOptionSet(widg))){
			form = (struct xform_type *) widg;
			xoGetGeom(form);
			XoWMPositionHack((Widget)form->shell,(Position) atoi(form->xgeom),(Position)atoi(form->ygeom));
			w=XtParent(XtParent(XtParent(XtParent(w))));
		}	
		else
			w=XtParent(w);
		XRaiseWindow(XtDisplay(w),XtWindow(w));
		XtMapWidget(w);
	}
}

/* Extend this so it sets the pixflags for a child pix */
xoshow(argc,argv)
     int argc;
     char **argv;
{
	struct xwidg_type	*widg;
	Widget w;
	Boolean xoIsNestedForm(), xoIsNestedOptionSet();
	
	if (widg=xverify(argc,argv)) {
		w=(Widget)(widg->widget);
		if (XtIsSubclass(w,formWidgetClass) && !(xoIsNestedForm(widg) && xoIsNestedOptionSet(widg)))
			w=XtParent(XtParent(XtParent(XtParent(w))));
		else
			w=XtParent(w);
		XtMapWidget(w);
	}
}

/* Extend this so it sets the pixflags for a child pix */
xohide(argc,argv)
     int argc;
     char **argv;
{
	struct xwidg_type	*widg;
	Widget w;
	Boolean xoIsNestedForm(), xoIsNestedOptionSet();
	
	if (widg=xverify(argc,argv)) {
		w=(Widget)(widg->widget);
		if (XtIsSubclass(w,formWidgetClass) && !(xoIsNestedForm(widg) && xoIsNestedOptionSet(widg)))
			w=XtParent(XtParent(XtParent(XtParent(w))));
		else
			w=XtParent(w);
		XtUnmapWidget(w);
	}
}

 
xocolorscale(argc,argv)
     int argc;
     char **argv;
{
    char    *name;
    char    *value;
 
    if(argc < 2){
        fprintf(stderr, "usage: %s colorscale\n",argv[0]);
        fprintf(stderr, "   colorscales : hot rainbow grey\n");
        return;
    }

    if(!XgDisplay()){
	fprintf(stderr, "Xodus cannot be supported in this display\n");
	fprintf(stderr, "Check DISPLAY env variable and restart genesis\n");
	return;
    }	

    if(!XoColorSupported()){
	fprintf(stderr, "Color not supported in this display\n");
	fprintf(stderr,"Not loading colorscale: %s\n", argv[1]);
        return;
    } 
    XoMakeCmap(argv[1]);
}
 
xoupdate(argc,argv)
     int argc;
     char **argv;
{
    struct xwidg_type   *widg;
    Widget w;
 
    if (widg=xverify(argc,argv)) {
        w=(Widget)(widg->widget);
        if (XtIsSubclass(w,coredrawWidgetClass)) {
			/* The core_class is not recognized - I need headers */
			/*  (*XtClass(w)->core_class.resize)(w); */
			ResizeDraws(w);
        }
        XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
    }
}
 
xops(argc,argv)
     int argc;
     char **argv;
{
    XoSetPSparms(argc,argv);
}
 
xoflushevents(argc,argv)
     int argc;
     char **argv;
{
    /* Just call the event loop to get rid of the backlogs */
    XgEventLoop();
}


Widget xoFindParentForm(elm)
	Element	*elm;
{
	Element *parent;

	for(parent = elm->parent; parent ;parent = parent->parent) {
		if (strcmp(BaseObject(parent)->name, "xform") == 0) {
			return((Widget)((struct xwidg_type *)parent)->widget);
		}
	}
	XgError("Could not find any ancestor of type xform");
	return((Widget)NULL);
}

Boolean xoIsNestedForm(elm)
 Element *elm;
{
	Element *parent;

        for(parent = elm->parent; parent != NULL ;parent = parent->parent) {
                if (strcmp(BaseObject(parent)->name, "xform") == 0) {
                        return(True);
                }
        }
        return(False);
}

Boolean xoIsNestedOptionSet(elm)
        Element *elm;
{
        register struct xform_type *form = (struct xform_type *)elm;
        return(form->nested?True:False);
}

 
Widget xoFindParentDraw(elm)
    Element *elm;
{
    Element *parent;
    for(parent = elm; parent ;parent = parent->parent) {
        if (strcmp(BaseObject(parent)->name, "xcoredraw") == 0 ||
            strcmp(BaseObject(parent)->name, "xdumbdraw") == 0 ||
            strcmp(BaseObject(parent)->name, "xdraw") == 0 ||
            strcmp(BaseObject(parent)->name, "xgraph") == 0) {
            Widget w=(Widget)((struct xwidg_type *)parent)->widget;
            if (XtIsSubclass(w,coredrawWidgetClass)) {
                return(w);
            }
        }
    }
    XgError("Could not find any ancestor subclassed from CoreDraw");
    return((Widget)NULL);
}
 
xoUpdateParentDraw(elm)
    Element *elm;
{
    Widget w = xoFindParentDraw(elm);
    if (w)
        XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}


/* This function handles the <widget> syntax for backwards
** compatibility. This syntax should be considered deprecated and its
** use is discouraged */
xoParseScriptArg(elm,cur_arg,value)
	Element	*elm;
	char	*cur_arg;
	char	*value;
{
	static char	newval[200];
	char	*temp,*temp2;

	if ((temp =strstr(value,"<widget>")) == NULL) {
		DirectSetElement(elm,cur_arg,value);
	} else {
		strcpy(newval,value);
		temp2=Pathname(elm);
		sprintf(&(newval[temp-value]),
			"%s%s",temp2,temp+strlen("<widget>"));
		free(temp2);
		DirectSetElement(elm,cur_arg,newval);
	}
}

xoRedraw(elm)
	Element	*elm;
{
	struct xwidg_type *widg = (struct xwidg_type *)elm;
	Widget w;

	if (!CheckClass(widg,ClassID("widget"))) {
		printf("error in xoRedraw: element %s is not a widget\n",	
			Pathname(elm));
			return;
	}
	w = (Widget)widg->widget;
	if (w)
		XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

int xogetstat()
{
 extern int GENOPT_NoX;
 if(GENOPT_NoX || XgDisplay()==NULL)
	return(0);
 else
	return(1);
}

char *xoFullName(elm)
	Element *elm;
{
	static char	str[100];
	if (!elm)
		return("default");
	if (elm->index != 0)
		sprintf(str,"%s[%d]",elm->name,elm->index);
	else
		sprintf(str,"%s",elm->name);
	return(str);
}
