//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/
/* This is the kinetic simulation builder */

if (!{exists /kinetics})
	
	include PARMS.g
	include ksim.g
	/* load in the user preferences or the automatically saved ones */
	if (DO_X)
		include xaboutkkit.g
		make_xabout
		xshow /about
		xflushevents
		include xinterface.g
		/*
		if (DO_PSEARCH)
			include psearch/psearch.g
		end
		*/
		include xaxis.g
		include xgraphs.g
		include xsave.g
	else
		include batch_interface.g
	end
		
	/* These files must be organized as functions only, which handle
	** the DO_X option correctly */
	include xgroup.g
	include xpool.g
	include xreac.g
	include xenz.g
	include xstim.g
	include xtab.g
	include xchan.g
	
	function make_sim
		str name
	
		ce /
	
		setclock {FASTCLOCK} {FASTDT}
		setclock {SIMCLOCK} {SIMDT}
		setclock {CONTROLCLOCK} {CONTROLDT}
		setclock {PLOTCLOCK} {PLOTDT}
		// setclock {TABLECLOCK} {TABLEDT} Not used any more

		/* calling the assorted builder functions */
		kbegin
		if (DO_X)
			xbegin
			/* Graph specific creation funcs */
			make_xgraphs
		else
			make_batch_interface
		end
		
		// initializing the interface components
		init_xgroup
		init_xpool
		init_xreac
		init_xenz
		init_xstim
		init_xtab
		init_xchan
	
		if (DO_X)
			/* parameter search stuff */
			/*
			if (DO_PSEARCH)
				pbegin
			end
			*/

			xend
		end
		// swap out the current simulation context for dumps so
		// that loading in a model will not overwrite it.
		swapdump
		reset
	end
	make_sim
	maxerrors 100
end
