/* cp_remote_library.c	 Standard routines for remote routines run by
CirclePack					1/98 

	gcc cp_remote_library.c -o cp_lib -g -lm

*/

#include "cp_remote.h"

#define FG_COLOR 201

char buf[4096],msgbuf[4096];	/* utility buffers for strings. */
struct Pathlist *pathlist=NULL;		/* storage for paths */
int pathlength=0;
extern float toler,okerr;
extern float radius();
extern void choose_alpha(),choose_beta(),choose_gamma(),free_overlaps();

msg(msg) /* sends message to parent. */
char *msg;
{
	int tl;

	if ((tl=strlen(msg)-1)<0) return;
	if (msg[tl]!='\n') printf("msg: %s\n",msg);
	else printf("msg: %s",msg);
	fflush(stdout);
}

emsg(msg) /* sends error message to parent. */
char *msg;
{
	int tl;

	if ((tl=strlen(msg)-1)<0) return;
	if (msg[tl]!='\n') printf("emsg: %s\n",msg);
	else printf("emsg: %s",msg);
	fflush(stdout);
}

cmsg(msg) /* sends command message to parent. */
char *msg;
{
	int tl;

	if ((tl=strlen(msg)-1)<0) return;
	if (msg[tl]!='\n') printf("command:\n%s\n",msg);
	else printf("command:\n%s",msg);
	fflush(stdout);
}

dmsg(msg) /* sends data request to parent. */
char *msg;
{
	int tl;

	if ((tl=strlen(msg)-1)<0) return;
	if (msg[tl]!='\n') printf("data:\n%s\n",msg);
	else printf("data:\n%s",msg);
	fflush(stdout);
}

int
lock_set(p) /* order parent to block pack p and await acknowledge. */
int p;
{
	sprintf(buf,"lock %d\n",p);
	fputs(buf,stdout);
	fflush(stdout);
	*buf='\n';
	while (*buf=='\n') fgets(buf,1024,stdin); 
	sscanf(buf,"%s",msgbuf);
	if (strncmp(msgbuf,"failed",6)==0) return 0; 
		/* can add more analysis of return message */
	return 1;
} /* lock_set */

int
unlock(p) /* order parent to block pack p and await acknowledge. */
int p;
{
	sprintf(buf,"unlock %d\n",p);
	fputs(buf,stdout);
	fflush(stdout);
	*buf='\n';
	while (*buf=='\n') fgets(buf,1024,stdin); 
	sscanf(buf,"%s",msgbuf);
	if (strncmp(msgbuf,"failed",6)==0) return 0; 
		/* can add more analysis of return message */
	return 1;
} /* unlock */

int 
pack_read(p,pnum,opt) /* order parent to send pack pnum, 
await ack'ge, return nodecount. opt gives level of data desired:
opt 0=combinatorics, 1=minimal, 2=standard,3=complete. */
struct p_data *p;
int pnum,opt;
{
	int n,size;

	sprintf(buf,"get pack %d %d\n",pnum,opt);
	fputs(buf,stdout);
	fflush(stdout);
	*buf='\n';
	while (*buf=='\n') fgets(buf,1024,stdin); 
	sscanf(buf,"%s",msgbuf);
	if (strcmp(msgbuf,"failed")==0 
	   || sscanf(buf,"%s %s %d %d",msgbuf,msgbuf,&n,&size)!=4
	   || n!=pnum) 
		return 0;
	return size;
} /* pack_read */

int 
pack_write(p,q,opt) /* ask parent to accept pack p data into its pack q 
and await acknowledge. */
struct p_data *p;
int q,opt;
{
	if (p->nodecount<=0)
		return 0;
	sprintf(buf,"sending pack %d %d\n",q,p->nodecount);
	fputs(buf,stdout);
	fflush(stdout);
	*buf='\n';
	while (*buf=='\n') fgets(buf,1024,stdin); 
	sscanf(buf,"%s",msgbuf);
	if (strcmp(msgbuf,"ready")!=0) return 0; 
		/* can add more analysis of return message */
	if (!writepack(p,stdout,opt)) return 0; /* opt controls the
		amount of data that is written on the pack. */
	*buf='\n';
	while (*buf=='\n') fgets(buf,1024,stdin); 
	sscanf(buf,"%s",msgbuf);
	if (strncmp(msgbuf,"failed",6)==0) return 0;
		/* can add more analysis of return message */
	return 1;
} /* pack_write */

int 
path_read() /* order parent to send current path */
{
	sprintf(buf,"get path\n");
	fputs(buf,stdout);
	fflush(stdout);
	return (readpath(stdin)); 
} /* path_read */

int 
path_write() /* send path to parent */
{
	if (pathlist==NULL || pathlength<=0) return 0;
	sprintf(buf,"sending path\n");
	fputs(buf,stdout);
	fflush(stdout);
	writepath(stdout);
	*buf='\n';
	while (*buf=='\n') fgets(buf,1024,stdin); 
	sscanf(buf,"%s",msgbuf);
	if (strncmp(msgbuf,"failed",6)==0) return 0;
		/* can add more analysis of return message */
	return 1;
} /* path_write */

done_signal()
{
	sprintf(buf,"done\n");
	fputs(buf,stdout);
	fflush(stdout);
	*buf='\n';
	while (*buf=='\n') fgets(buf,1024,stdin); 
	sscanf(buf,"%s",msgbuf);
	if (strcmp(msgbuf,"bye")!=0) return 0; 
	return 1;
} /* done_signal */

int
get_pack_size(p,fp) 
struct p_data *p;
FILE *fp;
{
	int size=0;
	char command[64];

	while ( (fscanf(fp,"%63s",command)!=EOF)
		&& (strcmp(command,"NODECOUNT:"))
		&& (strcmp(command,"CHECKCOUNT:"))
		&& (strcmp(command,"END")) );
	if (!strcmp(command,"NODECOUNT:")
	   || !strcmp(command,"CHECKCOUNT:") )
		fscanf(fp,"%d",&size);
	if (size<0) size=0;
	return size;
} /* get_pack_size */

int
readpack(p,fp) /* read pack to pack p of this program. Return 1 if okay. */
struct p_data *p;
FILE *fp;
{
	int i,j,k,count,new_flag=0,name_flag=0,K_flag=0;
	int angsum_flag=0,aim_flag=0,rad_flag=0,cent_flag=0;
	float dum;
	char command[64],geometry[64],filename[NAME_MAX],*name;
	struct K_data *pK_ptr;
	struct R_data *pR_ptr;
	extern void fillcurves();
	extern int alloc_pack_space();

	pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
	while ( (fscanf(fp,"%63s",command)!=EOF)
		&& (strcmp(command,"NODECOUNT:")!=0)
		&& (strcmp(command,"CHECKCOUNT:")!=0)
		&& (strcmp(command,"END")!=0) )
	 {		/* in case PACKNAME apprears first */
		if (strcmp(command,"PACKNAME:")==0)
		 {
		      fgets(buf,1024,fp);
		      sscanf(buf,"%127s",filename);
		      name_flag=strlen(filename);
		 }
	 }
	if (strcmp(command,"")==0) return -1; /* no data */
	if (strcmp(command,"NODECOUNT:")==0) /* new packing */
	 {
		new_flag=1;
		p->hes=0; /* default */
		if (fscanf(fp,"%d",&count)!=1
			|| count<3 || !alloc_pack_space(p,count,0) )
		 {
			sprintf(msgbuf,"Read aborted: out of memory");
			emsg(msgbuf); 
			return -1;
		 }
		pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr; /* update ptr's */
		p->nodecount=count;
	 }
	else if (strcmp(command,"CHECKCOUNT:")==0) /* partial data */
	 {
		if (!p->status || fscanf(fp,"%d",&count)!=1 
			|| count!=p->nodecount)
		 {
			sprintf(msgbuf,
			   "Read aborted: CHECKCOUNT=NODECOUNT failed.");
			emsg(msgbuf); 
			return -1;
		 }
	 }
	else return -1; /* unrecognized stuff */
	while ( (fscanf(fp,"%63s",command)!=EOF) 
		&& (strcmp(command,"END")!=0) )
	 {
		if (strcmp(command,"ALPHA/BETA/GAMMA:")==0)
		 		fscanf(fp,"%d %d %d",&p->alpha,
				&p->beta,&p->gamma);
		else if (strcmp(command,"GEOMETRY:")==0)
		 {
		 	fscanf(fp,"%63s",geometry);
		 	if (toupper(geometry[0])=='H') p->hes=-1;
			else if (toupper(geometry[0])=='E') p->hes=0;
			else if (toupper(geometry[0])=='S') p->hes=1;
			else 
			 {
				dum=atof(geometry);
				if (dum>okerr) p->hes=1;
				else if (dum<(-1.0)*okerr) p->hes=-1;
				else p->hes=0;
			 }
		 }
		else if (strcmp(command,"FLOWERS:")==0)
		 {
		      K_flag=1;
		      if (!new_flag) 
		       {
			   sprintf(msgbuf,
			     "Read aborted: FLOWERS given w/o NODECOUNT.");
			   emsg(msgbuf);
			   return (0);
		       }
		      for (i=1;i<=count && new_flag;i++)
		       {
		         if (!fscanf(fp,"%d",&k)) new_flag=0;
			 if ( !fscanf(fp,"%d",&pK_ptr[k].num)
			    || pK_ptr[k].num>MAX_PETALS ) 
				new_flag=0;
			 if (pK_ptr[k].flower) free(pK_ptr[k].flower);
			 pK_ptr[k].flower=(int *)
			   calloc((size_t)(pK_ptr[k].num+1),sizeof(int));
		         for (j=0;new_flag && j<=pK_ptr[k].num;j++)
			   if (!fscanf(fp,"%d",&pK_ptr[k].flower[j])) 
				new_flag=0;
			 if ( new_flag 
			    && (pK_ptr[k].bdry_flag=(int)(pK_ptr[k].flower[0]
			    !=pK_ptr[k].flower[pK_ptr[k].num])) 
			    && pK_ptr[k].num>(MAX_PETALS-1) ) 
			 	new_flag=0; 
		       }
		      if (!new_flag)
		       {
			   sprintf(msgbuf,
			     "Read aborted: error in reading complex, v%d.",
			     k);
			   emsg(msgbuf);
			   return (0);
		       }
		      free_overlaps(p);
		 }
		else if (strcmp(command,"PACKNAME:")==0)
		 {
		      fgets(buf,1024,fp);
		      sscanf(buf,"%127s",filename);
		      name_flag=strlen(filename);
		 }
		else if (strcmp(command,"RADII:")==0)
		 {
		      rad_flag=1;
		      if (p->hes<0) for (i=1;i<=count;i++)
		       {
				fscanf(fp,"%lf",&dum);
				if (dum>0) pR_ptr[i].rad=exp(-dum);
				else pR_ptr[i].rad=dum;
		       }
		      else for (i=1;i<=count;i++)
			 fscanf(fp,"%lf",&pR_ptr[i].rad);
		 }
			/* old method for aims: all */
		else if (strcmp(command,"AIMS:")==0) 
		 {
		      aim_flag=1;
		      for (i=1;i<=count;i++)
			 fscanf(fp,"%lf",&pR_ptr[i].aim);
		 }
			/* new method: design'd aims (vert, aim) */
		else if (strcmp(command,"ANGLE-AIMS:")==0)
		 {
			set_aim_default(p);
			aim_flag=1;
			while ((fscanf(fp,"%d %lf",&i,&dum)==2)
				&& i>0 && i<=count) 
				pR_ptr[i].aim=dum;
		 }
		else if (strcmp(command,"OVERLAPS:")==0) 
			/* old version, read all. NOTE: depends on FLOWERS */
		 {
		      if (alloc_overlaps(p))
		       {
		    	  for (i=1;i<=count && (fscanf(fp,"%d",&j)==1);i++)
			   {
			     		/* read but disregard j */
		  	     for (j=0;j<=pK_ptr[i].num 
				&& (fscanf(fp,"%lf",&dum)==1);j++)
				set_overlap(p,i,j,dum);
			   }
		       }
		 }
		else if (strcmp(command,"INV_DISTANCES:")==0) 
			/* new version. NOTE: depends on FLOWERS */
		 {
			if (alloc_overlaps(p))
			 {
				k=1;
				while (fscanf(fp,"%d %d",&i,&k)==2 
				   && (j=nghb(p,i,k))>=0
				   && fscanf(fp,"%lf",&dum) )
					set_overlap(p,i,j,dum);
			 }
		 }
		else if (strcmp(command,"CENTERS:")==0)
		 {
		      cent_flag=1;
		      for (i=1;i<=count;i++)
			 fscanf(fp,"%lf %lf",
				&pR_ptr[i].center.re,&pR_ptr[i].center.im);
		 }
		else if (strcmp(command,"ANGLESUMS:")==0)
    	            {
		      angsum_flag=1;
		      for (i=1;i<=count;i++)
			 fscanf(fp,"%lf",&pR_ptr[i].curv);
		 }
		else if ( strcmp(command,"CIRCLE-COLORS:")==0) 
		 {
			while (fscanf(fp,"%d %d",&i,&j)==2
				&& i>0 && i<=count
				&& j>=0 && j<=255)
				pK_ptr[i].color=j;
		 }
		else if ( strcmp(command,"FACE-COLORS:")==0) 
		 {
			while (fscanf(fp,"%d %d",&i,&j)==2
				&& i>0 && i<=p->facecount
				&& j>=0 && j<=255)
				p->faces[i].color=j;
		 }
	} /* end of while */
	if (new_flag)
	 {
		if (!K_flag)
		 {
		   sprintf(msgbuf,"Read aborted: no FLOWERS given.");
		   emsg(msgbuf);
		   return (0);
		 }
		if (!rad_flag) for (i=1;i<=count;i++) pR_ptr[i].rad=0.5;
		if (!cent_flag) for (i=1;i<=count;i++) 
			pR_ptr[i].center.re=pR_ptr[i].center.im=0.0;
	 }	
	if (name_flag)
	 {
		i=strlen(filename);
		while (i>0 && filename[i-1]!='/') i--;
		name=filename+i;  /* cut off any directory names */
		strcpy(p->file_name,name);
		sprintf(buf,"%s",p->file_name);
		if (p->hes<0) strcat(buf," (hyp)\0");
		else if (p->hes==0) strcat(buf," (eucl)\0");
		else strcat(buf," (sph)\0");
	 }
	choose_alpha(p);choose_beta(p);choose_gamma(p);
	if (new_flag)
	 {
/*		facedraworder(p,NULL); */
		if (!angsum_flag) fillcurves(p);
		if (!aim_flag) set_aim_default(p);
	 }
	p->active_node=p->beta;
	return (1);
} /* readpack */

int
writepack(p,fp,act) /* write pack p data to pack in parent. 
Return 1 if okay. "act" tells how much data: > 99 means only partial. 
act=0 should give only combinatorics */
struct p_data *p;
FILE *fp;
int act;
{
	int i,j,k,n,count,flag,colorflag,jj;
	float angle;
	struct K_data *pK_ptr;
	struct R_data *pR_ptr;

	pK_ptr=p->packK_ptr;
	pR_ptr=p->packR_ptr;
	count=p->nodecount;
	fprintf(fp,"NODECOUNT:   %d\n\n",count);
	if (act>2)
	 {
		buf[0]='\0';
		sscanf(p->file_name,"%s",buf);
		stripsp(buf);
		if (strlen(buf)==0)
			sprintf(buf,"NoName ");
		fprintf(fp,"PACKNAME: %s\n\n",buf);
	 }
	if (act>=0)
	 {
		fprintf(fp,"ALPHA/BETA/GAMMA:   %d  %d  %d\n\n",
		p->alpha,p->beta,p->gamma);
		if (p->hes<(-1.0)*okerr) sprintf(buf,"hyperbolic\n");
		else if (p->hes>okerr) sprintf(buf,"spherical\n");
		else sprintf(buf,"euclidean\n");
		fprintf(fp,"GEOMETRY:   %s\n",buf);
	 }
	fprintf(fp,"FLOWERS: \n");
	for (n=1;n<=count;n++)
	 {
        	fprintf(fp,"\n%d  %d     ",n,pK_ptr[n].num);
		for (i=0;i<=pK_ptr[n].num;i++) 
			fprintf(fp,"%d  ",pK_ptr[n].flower[i]);
	 }
	fprintf(fp,"\n\n");
	if (act>0)
	 {
		if (p->overlap_status)
		 {
	   		fprintf(fp,"INV_DISTANCES:\n");
	   		for (i=1;i<=count;i++)
			   for (j=0;j<(pK_ptr[i].num+pK_ptr[i].bdry_flag);j++)
			     if (i<(k=pK_ptr[i].flower[j])
				&& (angle=pK_ptr[i].overlaps[j]) == 1.0)
				   fprintf(fp,"\n%d %d  %.6e ",
					i,k,angle);
			fprintf(fp,"\n  (done)\n\n");
		 }
		flag=0;
		for (i=1;i<=count;i++)
		 {
		   if (pK_ptr[i].bdry_flag 
			&& pR_ptr[i].aim>=0.0) flag++;
		   else if ( !pK_ptr[i].bdry_flag 
			&& ( (pR_ptr[i].aim-2.0*M_PI)>toler 
			|| (2.0*M_PI-pR_ptr[i].aim)>toler ) ) flag++;
		 }
		if (flag)
		 {
		   jj=j=0;
		   for (i=1;i<=count && jj==0;i++) 
		    {
			if ( (pK_ptr[i].bdry_flag && pR_ptr[i].aim>=0) 
			   || (!pK_ptr[i].bdry_flag 
			   && (pR_ptr[i].aim<(2.0*M_PI+okerr)
			   || pR_ptr[i].aim>(2.0*M_PI-okerr))) )
				jj++;
		    }
		   if (jj>0) /* at least one non-default aim */
		    {
			fprintf(fp,"ANGLE-AIMS:\n");
		     	for (i=1;i<=count;i++)
			   if ( (pK_ptr[i].bdry_flag && pR_ptr[i].aim>=0) 
			     || (!pK_ptr[i].bdry_flag 
			     && (pR_ptr[i].aim<(2.0*M_PI-okerr)
			     || pR_ptr[i].aim>(2.0*M_PI+okerr))) )
			    {
			       fprintf(fp," %d % .10e  ",i,pR_ptr[i].aim);
			       j++;
			       if ((j % 3)==0) fprintf(fp,"\n");
			    }
		    }
		   fprintf(fp,"\n  (done)\n\n");
		 }
	 }
	if (act>1)
	 {
		fprintf(fp,"RADII: \n");
		for (i=1;i<=count;i++)
		 {
		   fprintf(fp,"% .10e  ",radius(p,i));
		   if ((i % 4)==0) fprintf(fp,"\n");
		 }
		fprintf(fp,"\n\n");
		fprintf(fp,"CENTERS:\n");
		for (i=1;i<=count;i++)
		 {
		   fprintf(fp,"  % .6e % .6e  ",pR_ptr[i].center.re,
			pR_ptr[i].center.im);
		   if ((i % 2)==0) fprintf(fp,"\n");
		 }
		fprintf(fp,"\n\n");
	 }
	if (act>2) 
	 {
		fprintf(fp,"ANGLESUMS: \n");
		for (i=1;i<=count;i++)
		 {
                	fprintf(fp," %.6e  ",pR_ptr[i].curv);
			if ((i % 5)==0) fprintf(fp,"\n");
		 }
		fprintf(fp,"\n\n");
		colorflag=0;
		for (i=1;i<=count && colorflag==0;i++) 
			if (pK_ptr[i].color != FG_COLOR) colorflag++;
		if (colorflag) /* found some non-default colors */
		 {
			fprintf(fp,"CIRCLE-COLORS:\n");
			j=0;
			for (i=1;i<=count;i++)
			 {
				if (pK_ptr[i].color!=FG_COLOR)
				 {
					fprintf(fp," %d %d  ",
						i,pK_ptr[i].color);
					j++;
				 }
				if ((j % 10)==0) fprintf(fp,"\n");
			 }
			fprintf(fp,"\n  (done)\n\n");
		 }
		colorflag=0;
		for (i=1;i<=p->facecount && colorflag;i++) 
			if (p->faces[i].color != FG_COLOR) colorflag++;
		if (colorflag) /* found some non-default colors */
		 {
			fprintf(fp,"FACE-COLORS:\n");
			j=0;
			for (i=1;i<=p->facecount;i++)
			 {
				if (p->faces[i].color!=FG_COLOR)
				 {
					fprintf(fp," %d %d  ",
						i,p->faces[i].color);
					j++;
				 }
				if ((j % 10)==0) fprintf(fp,"\n");
			 }
			fprintf(fp,"\n  (done)\n\n");
		 }
	 }
	fprintf(fp,"END\n");fflush(fp);
	return 1;
} /* writepack */

int
readpath(fp) /* assume file open for reading path */
FILE *fp;
{
	int count=0;
	float xx,yy;
	char command[50];
	struct Pathlist *trace;

	while ( (fscanf(fp,"%s",command)!=EOF) && (strcmp(command,"PATH")!=0) 
		&& (strcmp(command,"END")!=0) );
	if (strcmp(command,"END")==0 || fscanf(fp,"%lf %lf",&xx,&yy)!=2) 
		return 0; /* no points */
	path_free(&pathlist); /* free the pathlist */
	pathlength=0;
	if ( (pathlist=(struct Pathlist *)calloc(1,sizeof(struct Pathlist)))
		!=NULL ) 
	 {
		pathlist->x=xx;pathlist->y=yy;
		count++;
	 }
	else return 0; 
	trace=pathlist;
	while 
	   ( fscanf(fp,"%lf %lf",&xx,&yy)==2 && count<2000
	  	 && ((trace->next=(struct Pathlist *)calloc(1,sizeof
		 (struct Pathlist)))!=NULL ) )
	 {
		trace=trace->next;
		trace->x=xx;trace->y=yy;
		count++;
	 }
	if (count<3)	/* didn't get enough points */
	 {path_free(&pathlist); pathlength=0;return 0;} 
	trace=pathlist;
	while (trace->next!=NULL) trace=trace->next;
	if (trace->x!=pathlist->x || trace->y!=pathlist->y)
	 {
		trace->next=(struct Pathlist *)calloc
			(1,sizeof(struct Pathlist));
		trace->next->x=pathlist->x;
		trace->next->y=pathlist->y;
		count++;
	 } /* make sure path closes up */
	pathlength=count;
	return count;
} /* readpath */


int
writepath(fp) /* assume file open for writing path */
FILE *fp;
{
	int count=0;
	struct Pathlist *trace;

	fprintf(fp,"PATH\n");
	trace=pathlist;
	while (trace!=NULL)
	 {
		fprintf(fp,"%lf %lf \n",trace->x,trace->y);
		trace=trace->next;
		count++;
	 }
	fprintf(fp,"END\n");
	return count;
} /* writepath */

float
radius(p,v) /* give radius. In hyp case, converts s-rad to usual hyp rad.  */
struct p_data *p;
int v;
{
	if ( (p->hes<0) && (p->packR_ptr[v].rad > 0) ) 
		return (-log(p->packR_ptr[v].rad));
	return (p->packR_ptr[v].rad);
} /* radius */

set_aim_default(p) /* put 2pi aim in for interior and -1 for bdry.*/
struct p_data *p;
{
	int i;

	for (i=1;i<=p->nodecount;i++) 
	 {
		if (p->packK_ptr[i].flower[0]!=
		   p->packK_ptr[i].flower[p->packK_ptr[i].num])
			p->packR_ptr[i].aim=-1;
		else p->packR_ptr[i].aim=2.0*M_PI;
	 }
} /* set_aim_default */

path_free(pathlist)
struct Pathlist **pathlist;
{
	struct Pathlist *trace,*clobber;

	if (*pathlist==NULL) return;
	trace=*pathlist;
	while (trace!=NULL)
	 {
		clobber=trace;
		trace=trace->next;
		free(clobber);
	 }
	*pathlist=NULL;
} /* path_free */

edge_free(edgelist)
struct Edgelist **edgelist;
{
	struct Edgelist *trace,*clobber;

	if (*edgelist==NULL) return;
	trace=*edgelist;
	while (trace!=NULL)
	 {
		clobber=trace;
		trace=trace->next;
		free(clobber);
	 }
	*edgelist=NULL;
} /* edge_free */

vert_free(vertlist)
struct Vertlist **vertlist;
{
	struct Vertlist *trace,*clobber;

	if (*vertlist==NULL) return;
	trace=*vertlist;
	while (trace!=NULL)
	 {
		clobber=trace;
		trace=trace->next;
		free(clobber);
	 }
	*vertlist=NULL;
} /* vert_free */

int
nghb(p,v,w) /* return -1 if w is not neighbor of v, else returns index of
w in flower of v. */
int v,w;
struct p_data *p;
{
	int j;
	struct K_data *pK_ptr;

	pK_ptr=p->packK_ptr;
	if (v<1 || v>p->nodecount || w<1 || w>p->nodecount) return -1;
	for (j=0;j<=pK_ptr[v].num;j++)
		if (pK_ptr[v].flower[j]==w) return j;
	return (-1);
} /* nghb */

int
bdry_comp_count(p,v) /* retrn count of edges in bdry component of v. 
0 if v not bdry or some comb error. */
struct p_data *p;
int v;
{
	int next,count=1,maxcount;

	if (!p->packK_ptr[v].bdry_flag) return 0;
	maxcount=p->nodecount-p->intnode;
	next=v;
	while ((next=p->packK_ptr[next].flower[0])!=v 
		&& count<= maxcount) count++;
	if (count>maxcount) return 0;
	return count;
} /* bdry_comp_count */

int
cross_edge_vert(p,v,k) /* Return vert across edge from v. Edge is that 
from flower[k] to flower[k+1]. Return 0 on failure. */
struct p_data *p;
int v,k;
{
	int N,ind,w;
	struct K_data *pK_ptr;
	extern int nghb();

	pK_ptr=p->packK_ptr;
	if (v<1 || v>p->nodecount || k<0 || k>(N=pK_ptr[v].num)
	   || (k==N && pK_ptr[v].bdry_flag) ) return 0;
	w=pK_ptr[v].flower[k];
	ind=nghb(p,w,v);
	if (pK_ptr[w].bdry_flag)
	 {
		if (ind<2) return 0;
		else return (pK_ptr[w].flower[ind-2]);
	 }
	return (pK_ptr[w].flower[(ind+pK_ptr[w].num-2)%(pK_ptr[w].num)]);
} /* cross_edge_vert */

void
choose_alpha(p) /* Choose new alpha if needed. */
struct p_data *p;
{
	int flag=0,i;
	struct K_data *pK_ptr;

	pK_ptr=p->packK_ptr;
	i=p->alpha;
	if (i>0 && i<=p->nodecount && !pK_ptr[i].bdry_flag) 
		/* alpha okay already */
	 {
		if (p->alpha==p->gamma) p->gamma=pK_ptr[p->alpha].flower[0];
		return;
	 }
	i=0;
	do
	 {
		i++;
		if (pK_ptr[i].flower[0]==pK_ptr[i].flower[pK_ptr[i].num])
			flag=1;
	 }
	while (i<p->nodecount && !flag);
	if (flag) p->alpha=i;
	else if (p->beta!=1) p->alpha=1;
	else p->alpha=pK_ptr[p->beta].flower[0];
	if (p->gamma==p->alpha) 
		p->gamma=pK_ptr[p->alpha].flower[0];
	return;
} /* choose_alpha */

void
choose_beta(p) /* when need to choose new beta; avoid alpha */
struct p_data *p;
{
	int i;
	struct K_data *pK_ptr;

	pK_ptr=p->packK_ptr;
	i=p->beta;
	if (i>0 && i<=p->nodecount && pK_ptr[i].bdry_flag) return; /* okay */
	i=1;
	while (pK_ptr[i].bdry_flag==0 && i<p->nodecount) i++;
	if (i==p->alpha) i=pK_ptr[i].flower[0];
	p->beta=i;
}/*choose_beta*/

void
choose_gamma(p) /* avoid alpha */
struct p_data *p;
{
	int i;

	i=p->gamma;
	if (i>0 && i<p->nodecount && i!=p->alpha) return; /* okay */
	if (p->alpha==1) p->gamma=p->packK_ptr[1].flower[0];
	else p->gamma=1;
	return;
}

int
set_overlap(p,v,j,angle) /* set overlap or inv. dist value in all
approp places. Return 0 on error or if space not allocated. */
struct p_data *p;
int v,j;
float angle;
{
	int w,indx;
	struct K_data *pK_ptr;
	extern int nghb();

	pK_ptr=p->packK_ptr;
	if (!p->overlap_status) return 0;
	w=p->packK_ptr[v].flower[j];
	indx=nghb(p,v,w);
	pK_ptr[v].overlaps[indx]=angle;
	if (indx==0 && !pK_ptr[v].bdry_flag) 
		pK_ptr[v].overlaps[pK_ptr[v].num]=angle;
	indx=nghb(p,w,v);
	pK_ptr[w].overlaps[indx]=angle;
	if (indx==0 && !pK_ptr[w].bdry_flag) 
		pK_ptr[w].overlaps[pK_ptr[w].num]=angle;
} /* set_overlap */	


int
grab_next(ptr,next) /* get next string of <256 non-space, non-semicolon
characters from ptr, put in next, reset ptr. 
Return 1 if next not empty. Note: changes ptr in calling routine, but not
contents it originally pointed to.*/
char **ptr,*next;
{
	int i=0;

	if (*ptr==NULL) return 0;
	while (**ptr == ' ' || **ptr == '\n' || **ptr == '\t' 
		|| **ptr == '\r')
		(*ptr)++;
	if (**ptr=='\0') return 0;
	while (*((*ptr)+i)!='\0' && *((*ptr)+i)!=' ' 
		&& *((*ptr)+i)!='\n' && *((*ptr)+i)!='\r' 
		&& *((*ptr)+i)!=';' && *((*ptr)+i)!='\t' && i<255)
	 {
		*(next+i)=*((*ptr)+i);
		i++;
	 }
	*(next+i)='\0';
	*ptr += i;
	return i;
} /* grab_next */


stripsp(datastr) /* strip initial 'space' chars, shift rest down. */
char *datastr;
{
	int i=0;
	char *ptr;

	ptr=datastr;
	while (*ptr==' ' || *ptr=='\n' || *ptr=='\r' || *ptr=='\t') ptr++;
	if (ptr==datastr) return;
	if (*ptr=='\0') 
	 {
		*datastr='\0';
		return;
	 }
	do {*(datastr+i)=*(ptr+i); i++;}
	while (*(ptr+i-1)!='\0');
	return;
} /* stripsp */

int
adjoin(p1,p2,v1,v2,n,Oldnew) /* adjoin the pack p2 to p1, starting with
vertex v2 of p2 to vertex v1 of p1, and proceeding n additional vertices
about the boundary of p1 in the negative (clockwise) direction. Put
results in p1. If p1!=p2, then p2 should remain unchanged.
return 1 if successful. Lose overlap data. oldnew returns
conversions of indices for possible use. */
int v1,v2,n,**Oldnew;
struct p_data *p1,*p2;
{
	int i,ii,jj,j,k,kk,ll,m,mm,nn,node,newnode,endvertex,endnode;
	int b1,b2,count,dist,w,indx;
	int next,v,old_vert,new_vert;
	int *oldnew=NULL,*oldnewflag=NULL,*newflower;
	struct K_data *pK_ptr1,*pK_ptr2;
	struct R_data *pR_ptr1,*pR_ptr2;
	extern void delete(),choose_gamma(),choose_beta();
	extern int bdry_comp_count(),alloc_pack_space();

	pK_ptr2=p2->packK_ptr;pR_ptr2=p2->packR_ptr;
	pK_ptr1=p1->packK_ptr;pR_ptr1=p1->packR_ptr;
	if 
	 ( !p1->status
	   || !p2->status
	   || n<1 || v1<=0 || v2<=0 
	   || v1>p1->nodecount || v2>p2->nodecount
	   || (b1=bdry_comp_count(p1,v1))<n
	   || (b2=bdry_comp_count(p2,v2))<n
	   || p1->locks
	 )
		return 0;
/* fixup ??: could try to save overlaps */
	free_overlaps(p1); 
	if (p1!=p2) /* procedure for adjoining distinct packs */
 {
	oldnew=(int *)malloc((p2->nodecount+2)*sizeof(int));
	oldnewflag=(int *)calloc((size_t)(p2->nodecount+2),sizeof(int));

/* store new indices */
	node=v1;
	newnode=v2;
	for (i=1;i<=n;i++)
	 {
		oldnewflag[newnode]=1;
		oldnew[newnode]=node;
		node=pK_ptr1[node].flower[pK_ptr1[node].num];
		newnode=pK_ptr2[newnode].flower[0];
	 }
	endvertex=newnode; 	/* last p2 vertex */
	endnode=node; 		/* last p1 vertex */
	if (b2>n) 
	 {
		oldnewflag[endvertex]=1;
		oldnew[endvertex]=endnode;
	 }
		
	 	/* get rest of new indices */
	newnode=p1->nodecount+1;
	for (i=1;i<=p2->nodecount;i++)
	   if (!oldnewflag[i])
	    {oldnew[i]=newnode;newnode++;}
	if (!alloc_pack_space(p1,newnode+2,1)) return 0;
	pK_ptr1=p1->packK_ptr;pR_ptr1=p1->packR_ptr; /* updata ptr's */
	p1->nodecount=newnode-1;

/* fix up flowers */

	for (i=1;i<=p2->nodecount;i++)
	 {
		j=oldnew[i];

		if (i==endvertex)  /* special measures for last vertex */
		 {
		   if ((b1 > n) && (b2 > n)) 
				/* flower begins with nghbs in p2 */
		    {
			ll=pK_ptr2[i].num;
			m=pK_ptr1[j].num;
			newflower=(int *)malloc((ll+m+1)*sizeof(int));
			for (k=1;k<=m;k++) 
				newflower[ll+m-k+1]=
				pK_ptr1[j].flower[m-k+1];
			for (k=0;k<=ll;k++) 
				newflower[k]=
				oldnew[pK_ptr2[i].flower[k]]; 
			free(pK_ptr1[j].flower);
			pK_ptr1[j].flower=newflower;
 			pK_ptr1[j].num=ll+m;
		    }
		   else if ((b1==n) && (b2>n)) 
				/* identify endnode and v1 in p1;
				use parts of three flowers;
				endnode to be deleted later. */
		    {
			for (ii=0;ii<=pK_ptr1[endnode].num;ii++)
				/* remove references to endnode in p1 */
			 {
				w=pK_ptr1[endnode].flower[ii];
				indx=nghb(p1,w,node);
				if (indx==0 && !pK_ptr1[w].bdry_flag)
				   pK_ptr1[w].flower[0]=
					pK_ptr1[w].flower[pK_ptr1[w].num]=v1;
				else if (indx>=0) pK_ptr1[w].flower[indx]=v1;
			 }
			ll=pK_ptr2[endvertex].num;
			mm=pK_ptr1[v1].num;
			nn=pK_ptr2[v2].num;
			newflower=(int *)malloc((ll+mm+nn+1)*sizeof(int));
			for (k=0;k<ll;k++)
			   newflower[k]=oldnew[pK_ptr2[endvertex].flower[k]];
			for (k=ll;k<=(ll+mm);k++)
			   newflower[k]=pK_ptr1[v1].flower[k-ll];
			for (k=(ll+mm+1);k<=(ll+mm+nn);k++)
			   newflower[k]=oldnew[pK_ptr2[v2].flower[ll+mm-k]];
			free(pK_ptr1[v1].flower);
			pK_ptr1[v1].flower=newflower;
 			pK_ptr1[v1].num=ll+mm+nn;
		    }
		   else if (b1==n && b2==n)
				/* whole bdrys; all become interior */
		    {
			ll=pK_ptr2[v2].num;
			mm=pK_ptr1[v1].num;
			newflower=(int *)malloc((ll+mm+1)*sizeof(int));
			for (k=0;k<ll;k++)
			   newflower[k]=oldnew[pK_ptr2[v2].flower[k]];
			for (k=ll;k<=(ll+mm);k++)
			   newflower[k]=pK_ptr1[v1].flower[k-ll];
			free(pK_ptr1[v1].flower);
			pK_ptr1[v1].flower=newflower;
 			pK_ptr1[v1].num=ll+mm;
		    }
		 }

/* rest of flowers are more routine */

		else if (oldnewflag[i])
		 {
			ll=pK_ptr2[i].num;
			mm=pK_ptr1[j].num;
			newflower=(int *)malloc((ll+mm+1)*sizeof(int));
			for (k=0;k<=mm;k++)
				newflower[k]=pK_ptr1[j].flower[k];
			for (k=mm+1;k<=ll+mm;k++)
				newflower[k]=oldnew[pK_ptr2[i].flower[k-mm]];
			if (j>p1->nodecount) free(pK_ptr1[j].flower);
			pK_ptr1[j].flower=newflower;
			pK_ptr1[j].num = ll+mm;
		 }
		else
		 {
			pR_ptr1[j].center=pR_ptr2[i].center;
			pR_ptr1[j].rad=pR_ptr2[i].rad;
			pK_ptr1[j].num=pK_ptr2[i].num;
			newflower=(int *)
			   malloc((pK_ptr2[i].num+1)*sizeof(int));
			for (k=0;k<=pK_ptr2[i].num;k++)
				newflower[k]=
				oldnew[pK_ptr2[i].flower[k]];
			if (j>p1->nodecount) free(pK_ptr1[j].flower);
			pK_ptr1[j].flower=newflower;
		 }
	 } /* end of for loop */
	if (b1>n && b2==n) delete(p1,endnode);
		/* use all bdry comp of p2, not p1; causes identification
		of endnode and v1 in p1. References to endnode
		have been changed. */
 } /* done with case of different packs */


	else /* adjoin pack to itself */
 {
	node=p1->nodecount;
/* first check if everything is compatable. */
	next=v1;
	if (!(count=bdry_comp_count(p1,v1))) return 0;
	dist=1;
	while ((next=pK_ptr1[next].flower[0])!=v2 
		&& dist<=count) dist++;
		/* dist counts edges to v2, if on same bdry comp */
	if (count>=p1->nodecount || count<2 /* error in combinatorics */
		|| dist==1			/* leave self-id'd edge */
		|| n>count			/* not enough edges */
		|| (dist<count && ((2*n)>(count-dist)||(2*n)==(count-dist-1)))
		|| (v1==v2 && (2*n==(count-1) || 2*n>count))
					/* leave self-id'd edge or
					conflicting ident's */
		) return 0;
	if ((dist=count-dist)==2*n) /* will be same as zip from vert 
		half way tween v1 and v2; indicate by setting v2=v1. */
	 {
		dist=n;
		while (dist>0)
		 {
			v1=pK_ptr1[v2].flower[0];
			v2=v1;
			dist--;
		 }
	 }
	if (count==dist && v1!=v2) 	/* v1, v2 on separate bdry comps*/
	 {
		next=v2;
		if (!(dist=bdry_comp_count(p1,v2))
			|| dist<3 		/* error in complex */
			|| n > dist		/* not long enough */
			|| (n==count && n!=dist) || (n==dist && n!=count)
				/* conflict on whether comps close up */
		) return 0;
	 }
/* now handle various possibilities */
	oldnew=(int *)malloc((node+2)*sizeof(int));
	for (kk=1;kk<=node;kk++) oldnew[kk]=kk;
	next=pK_ptr1[v1].flower[pK_ptr1[v1].num];
	v=pK_ptr1[v2].flower[0];
	if (next==v && v1!=v2) /* verts v2, next, v1 along edge */
	 {
		old_vert=pK_ptr1[next].flower[0]; /* v1 */
		new_vert=pK_ptr1[next].flower[pK_ptr1[next].num]; /* v2 */
		if (!close_up(p1,next)) return 0;
		for (kk=1;kk<=node;kk++)
		 {
			if (oldnew[kk]==old_vert) oldnew[kk]=new_vert;
			else if (oldnew[kk]>old_vert) oldnew[kk] -= 1;
		 }
	 }
	else if (v1==v2) /* zip up n edges */
	 {
	   next=v1;
	   for (j=1;j<=n;j++) 
	    {
		old_vert=pK_ptr1[next].flower[0];
		new_vert=pK_ptr1[next].flower[pK_ptr1[next].num];
		if (old_vert!=new_vert) 
		 {
			if (!close_up(p1,next)) return 0;
			for (kk=1;kk<=node;kk++)
			 {
				if (oldnew[kk]==old_vert) oldnew[kk]=new_vert;
				if (oldnew[kk]>old_vert) oldnew[kk] -= 1;
			 }
			if (new_vert>old_vert) new_vert--;
		 	next=new_vert;
		 }
		else {pK_ptr1[next].bdry_flag=1;j=n+1;}
	    }
	 }
	else  
	 {
			/* attach first edge */
/* fix up v1 (will remove v2) */
		ll=pK_ptr1[v1].num;
		mm=pK_ptr1[v2].num;
		newflower=(int *)malloc((ll+mm+1)*sizeof(int));
		for (i=0;i<=ll;i++) newflower[i]=pK_ptr1[v1].flower[i];
		for (i=ll+1;i<=(ll+mm);i++) 
			newflower[i]= pK_ptr1[v2].flower[i-ll];
		free(pK_ptr1[v1].flower);
		pK_ptr1[v1].flower=newflower;
		pK_ptr1[v1].num = ll+mm;
/* fix up 'next', clockwise from v1 (will remove ctrclk'w nghb v of v2) */
		ll=pK_ptr1[v].num;
		mm=pK_ptr1[next].num;
		newflower=(int *)malloc((ll+mm+1)*sizeof(int));
		for (i=0;i<=ll;i++) newflower[i]=pK_ptr1[v].flower[i];
		for (i=ll+1;i<=(ll+mm);i++) 
			newflower[i]= pK_ptr1[next].flower[i-ll];
		free(pK_ptr1[next].flower);
		pK_ptr1[next].flower=newflower;
		pK_ptr1[next].num = ll+mm;
/* fix up things pointed to v (which is to be removed) */
		for (i=0;i<=pK_ptr1[v].num;i++)
		 {
			ii=pK_ptr1[v].flower[i];
			for (j=0;j<=pK_ptr1[ii].num;j++)
			 {
				jj=pK_ptr1[ii].flower[j];
				if (jj==v) pK_ptr1[ii].flower[j]=next;
			 }
		 }
/* fix up things pointed to v2 (which is to be removed )*/
		for (i=0;i<=pK_ptr1[v2].num;i++)
		 {
			ii=pK_ptr1[v2].flower[i];
			for (j=0;j<=pK_ptr1[ii].num;j++)
			 {
				jj=pK_ptr1[ii].flower[j];
				if (jj==v2) pK_ptr1[ii].flower[j]=v1;
			 }
		 }
/* now to remove v and v2, replaced by next and v1, respectively. 
Old names should no longer be in any flowers.*/
		delete(p1,v);
		for (kk=1;kk<=node;kk++)
		 {
			if (oldnew[kk]==v) oldnew[kk]=next;
			if (oldnew[kk]>v) oldnew[kk]--;
		 }
		if (v2>v) v2--;
		if (next>v) next--;
		if (v1>v) v1--;
		delete(p1,v2);
		for (kk=1;kk<=node;kk++)
		 {
			if (oldnew[kk]==v2) oldnew[kk]=v1;
			if (oldnew[kk]>v2) oldnew[kk]--;
		 }
		if (next>v2) next--;
/* now zip up chain of edges for rest of attachments */
	   if (n>1) for (j=1;j<=n-1;j++) 
	    {
		old_vert=pK_ptr1[next].flower[0];
		new_vert=pK_ptr1[next].flower[pK_ptr1[next].num];
		if (old_vert!=new_vert) 
		 {
			if (!close_up(p1,next)) return 0;
			for (kk=1;kk<=node;kk++)
			 {
				if (oldnew[kk]==old_vert) oldnew[kk]=new_vert;
				if (oldnew[kk]>old_vert) oldnew[kk]--;
			 }
			if (new_vert>old_vert) new_vert--;
		 	next=new_vert;
		 }
		else {pK_ptr1[next].bdry_flag=1;j=n+1;}
	    }
	 }
 } /* done with case of self-adjoin. */

/* finish up */
	for (i=1;i<=p1->nodecount;i++) /* set bdry_flag data */
	 {
		if (pK_ptr1[i].flower[0]==pK_ptr1[i].flower[pK_ptr1[i].num])
		 {
			pK_ptr1[i].bdry_flag=0;
			if (pR_ptr1[i].rad<=0) pR_ptr1[i].rad=.7;
			/* so ones now in interior don't have infinite radius*/
		 }
		else pK_ptr1[i].bdry_flag=1;
	 }
	choose_beta(p1);choose_gamma(p1);
	if (oldnewflag) free(oldnewflag);
	*Oldnew=oldnew;
		/* size might have decreased */
	alloc_pack_space(p1,p1->nodecount+1,1); 
	return 1;
} /* adjoin */


int
close_up(p,vert) /* identify edges/vert on opposite sides of 
bdry vert 'vert'. */
int vert;
struct p_data *p;
{
	int next,v,i,ii,j,jj,w,*newflower,newnum,hold;
	float vert_next_angle,next_w_angle,*newoverlaps;
	struct K_data *pK_ptr;
	extern void delete();

	pK_ptr=p->packK_ptr;
/* fix up 'next', vertex after vert */
	if (pK_ptr[vert].num<3) return 0; /* too few faces */
	v=pK_ptr[vert].flower[0];
	next=pK_ptr[vert].flower[pK_ptr[vert].num];
/* if next==v, then vert and next should be interior; nothing more to do */
	if (next==v)
	 {
		pK_ptr[vert].bdry_flag=pK_ptr[next].bdry_flag=0;
		p->packR_ptr[vert].aim=p->packR_ptr[next].aim=2*M_PI; 
		return 1;
	 } 
/* fix up vert */
	pK_ptr[vert].flower[0]=next;
	pK_ptr[vert].bdry_flag=0;
	p->packR_ptr[vert].aim=2*M_PI;
	if (p->overlap_status)
	 {
		vert_next_angle=(0.5)*(pK_ptr[vert].overlaps[0]+
			pK_ptr[vert].overlaps[pK_ptr[vert].num]);
		pK_ptr[vert].overlaps[0]=
			pK_ptr[vert].overlaps[pK_ptr[vert].num]=
				vert_next_angle;
	 }

/* if next and v share common neighbors: either <v,vert,next> or
<v,vert,next,w> is a closed bdry comp; in former case, modify w
to put in latter case (one face disappears). */

	else if (pK_ptr[v].flower[0]==next
		|| (pK_ptr[v].flower[0]==
		(w=pK_ptr[next].flower[pK_ptr[next].num])) )
	 {
		if (pK_ptr[v].flower[0]==next) remove_edge(p,v,next);
		newnum=pK_ptr[v].num+pK_ptr[next].num;
		newflower=(int *)malloc((newnum+1)*sizeof(int));
		if (p->overlap_status) 
		 {
		   newoverlaps=(float *)malloc((newnum+1)*sizeof(float));
		   next_w_angle=(0.5)*
			(pK_ptr[w].overlaps[0]+
			pK_ptr[w].overlaps[pK_ptr[w].num]);
		 }
		hold=pK_ptr[next].num;
		for (i=0;i<=pK_ptr[next].num;i++)
		 {
		   newflower[i]=pK_ptr[next].flower[i];
		   if (p->overlap_status) newoverlaps[i]=
			pK_ptr[next].overlaps[i];
		 }
		for (i=1;i<=pK_ptr[v].num;i++)
		 {
		   newflower[i+pK_ptr[next].num]=pK_ptr[v].flower[i];
		   if (p->overlap_status) newoverlaps[i+pK_ptr[next].num]=
			pK_ptr[next].overlaps[i];
		 }
		free(pK_ptr[next].flower);
		pK_ptr[next].flower=newflower;
		pK_ptr[next].num=newnum;
		if (p->overlap_status)
		 {
			free(pK_ptr[next].overlaps);
			pK_ptr[next].overlaps=newoverlaps;
			pK_ptr[next].overlaps[0]=
			   pK_ptr[next].overlaps[newnum]=vert_next_angle;
			pK_ptr[next].overlaps[hold]=next_w_angle;	
		 }
			/* fix up w */
		pK_ptr[w].flower[pK_ptr[w].num]=next;
		if (p->overlap_status)
		   pK_ptr[w].overlaps[0]=pK_ptr[w].overlaps[pK_ptr[w].num]
			= vert_next_angle;
		pK_ptr[next].bdry_flag=	pK_ptr[w].bdry_flag=0;
		p->packR_ptr[next].aim=p->packR_ptr[w].aim=2*M_PI;
	 }

/* otherwise, next remains boundary vertex */
	else
	 {
		newnum=pK_ptr[v].num+pK_ptr[next].num;
		newflower=(int *)malloc((newnum+1)*sizeof(int));
		if (p->overlap_status) 
		   newoverlaps=(float *)malloc((newnum+1)*sizeof(float));
		for (i=0;i<=pK_ptr[v].num;i++)
		 {
		   newflower[i]=pK_ptr[v].flower[i];
		   if (p->overlap_status)
			newoverlaps[i]=pK_ptr[v].overlaps[i];
		 }
		for (i=1;i<=pK_ptr[next].num;i++)
		 {
		   newflower[i+pK_ptr[v].num]=pK_ptr[next].flower[i];
		   if (p->overlap_status)
			newoverlaps[i+pK_ptr[v].num]=pK_ptr[v].overlaps[i];
		 }
		if (p->overlap_status)
			newflower[pK_ptr[v].num]=vert_next_angle;
		pK_ptr[next].flower=newflower;
		pK_ptr[next].num=newnum;
		if (p->overlap_status)
		 {
			free(pK_ptr[w].overlaps);
			pK_ptr[w].overlaps=newoverlaps;
		 }
		p->packR_ptr[next].aim=-1.0;
	 }

/* fix up things with v in their flowers (v will be removed) */
	for (i=0;i<=pK_ptr[v].num;i++)
	 {
		ii=pK_ptr[v].flower[i];
		for (j=0;j<=pK_ptr[ii].num;j++)
		 {
			jj=pK_ptr[ii].flower[j];
			if (jj==v) pK_ptr[ii].flower[j]=next;
		 }
	 }
	delete(p,v);
	return 1;
} /* close_up */

int
remove_edge(p,v1,v2) /* remove a bdry edge. Already checked that v2 is
counterclockwise neighbor of v1 and removal is okay */
int v1,v2;
struct p_data *p;
{
	int i,v,n,m,*newflower;
	float *newoverlaps;
	struct K_data *pK_ptr;
	struct R_data *pR_ptr;
	extern int facedraworder(),complex_count();

	pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
/* verify data */
	if (v1<1 || v1>p->nodecount || v2<1 || v2>p->nodecount
		|| !pK_ptr[v1].bdry_flag || !pK_ptr[v2].bdry_flag
		|| (v2!=pK_ptr[v1].flower[0] && v1!=pK_ptr[v2].flower[0]) )
	 {
		strcpy(msgbuf,"An appropriate edge was not specified.");
		emsg(msgbuf);
		return 0;
	 }
	if (v1==pK_ptr[v2].flower[0]) {n=v1;v1=v2;v2=n;}
	if (pK_ptr[v1].num<2 || pK_ptr[v2].num<2 
		|| pK_ptr[pK_ptr[v1].flower[1]].bdry_flag )
	 {
		strcpy(msgbuf,"An appropriate edge was not specified.");
		emsg(msgbuf);
		return 0;
	 }
/* fix up v1 */
	newflower=(int *)malloc(pK_ptr[v1].num*sizeof(int));
	if (p->overlap_status)
		newoverlaps=(float *)malloc(pK_ptr[v1].num*sizeof(float));
	for (i=1;i<=pK_ptr[v1].num;i++)
	 {
		newflower[i-1]=pK_ptr[v1].flower[i];
		if (p->overlap_status)
			newoverlaps[i-1]=pK_ptr[v1].overlaps[i];
	 }
	free(pK_ptr[v1].flower);
	pK_ptr[v1].flower=newflower;
	if (p->overlap_status)
	 {
		free(pK_ptr[v1].overlaps);
		pK_ptr[v1].overlaps=newoverlaps;
	 }
	pK_ptr[v1].num--;
	pK_ptr[pK_ptr[v1].flower[0]].bdry_flag=1;
	pR_ptr[v1].aim=-1;

/* fix up v2 */
	newflower=(int *)malloc(pK_ptr[v2].num*sizeof(int));
	if (p->overlap_status)
		newoverlaps=(float *)malloc(pK_ptr[v2].num*sizeof(float));
	for (i=0;i<pK_ptr[v2].num;i++)
	 {
		newflower[i]=pK_ptr[v2].flower[i];
		if (p->overlap_status)
		   newoverlaps[i]=pK_ptr[v2].overlaps[i];
	 }
	free(pK_ptr[v2].flower);
	pK_ptr[v2].flower=newflower;
	if (p->overlap_status)
	 {
		free(pK_ptr[v2].overlaps);
		pK_ptr[v2].overlaps=newoverlaps;
	 }
	pK_ptr[v2].num--;
	pR_ptr[v2].aim=-1;

/* fix up common neighbor v */
	v=pK_ptr[v1].flower[0];
	newflower=(int *)malloc(pK_ptr[v].num*sizeof(int));
	if (p->overlap_status)
		newoverlaps=(float *)malloc(pK_ptr[v].num*sizeof(float));
	n=nghb(p,v,v2);
	m=pK_ptr[v].num;
	for (i=n;i<=m;i++)
	 {
		newflower[i-n]=pK_ptr[v].flower[i];
		if (p->overlap_status)
			newoverlaps[i-n]=pK_ptr[v].overlaps[i];
	 }
	for (i=1;i<n;i++)
	 {
		newflower[m-n+i]=pK_ptr[v].flower[i];
		if (p->overlap_status)
			newoverlaps[m-n+i]=pK_ptr[v].overlaps[i];
	 }
	pK_ptr[v].num--;
	free(pK_ptr[v].flower);
	pK_ptr[v].flower=newflower;
	if (p->overlap_status)
	 {
		free(pK_ptr[v].overlaps);
		pK_ptr[v].overlaps=newoverlaps;
	 }
	pR_ptr[v].aim=-1;

/* redo pack combinatorics */
/*	complex_count(p,0);
	facedraworder(p,NULL);
*/
	return 1;
} /* remove_edge */

void	
delete(p,v) /* routine to remove vertex from pack. Assume flowers 
pointing to it already adjusted.  */
int v;
struct p_data *p;
{
	int i,k;
	struct K_data *pK_ptr;
	struct R_data *pR_ptr;

	pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
	for (i=1;i<=p->nodecount;i++)
		if (i!=v) for (k=0;k<=pK_ptr[i].num;k++)
			if (pK_ptr[i].flower[k]>v) pK_ptr[i].flower[k]--;
	if (pK_ptr[v].flower) free(pK_ptr[v].flower);
	for (i=v;i<p->nodecount;i++)
	 {
		pK_ptr[i]=pK_ptr[i+1];
		pR_ptr[i]=pR_ptr[i+1];
	 }
	pK_ptr[p->nodecount].flower=NULL;
	if (pK_ptr[p->nodecount].overlaps)
	 {
		free(pK_ptr[p->nodecount].overlaps);
		pK_ptr[p->nodecount].overlaps=NULL;
	 }
	p->nodecount--;
	if (p->active_node>=v) p->active_node--;
	if (p->alpha>v) p->alpha--;
	else if (p->alpha==v) choose_alpha(p);
	if (p->beta>v) p->beta--;
	else if (p->beta==v) choose_beta(p);
	return;
} /* delete */


int
swap_nodes(p,datastr) /* interchange two vertex numbers */
struct p_data *p;
char *datastr;
{
	int i,j,v,w,vdum=0,pet;
	struct K_data *pK_ptr,holdK;
	struct R_data *pR_ptr,holdR;
	extern int facedraworder(),complex_count();

	pK_ptr=p->packK_ptr;
	pR_ptr=p->packR_ptr;
	if (sscanf(datastr,"%d %d",&v,&w)!=2 || v<1 || w<1 
		|| v>p->nodecount || w>p->nodecount || v==w) return 0;
	 {
		holdR=pR_ptr[v];holdK=pK_ptr[v];
		pR_ptr[v]=pR_ptr[w];pK_ptr[v]=pK_ptr[w];
		pR_ptr[w]=holdR;pK_ptr[w]=holdK;
		for (i=0;i<=pK_ptr[v].num;i++)
		 {
			pet=pK_ptr[v].flower[i];
			if (pet==v) pet=w;
			for (j=0;j<=pK_ptr[pet].num;j++)
				if (pK_ptr[pet].flower[j]==w) 
					pK_ptr[pet].flower[j]=vdum;
		 }
		for (i=0;i<=pK_ptr[w].num;i++)
		 {
			pet=pK_ptr[w].flower[i];
			if (pet==vdum) pet=v;
			for (j=0;j<=pK_ptr[pet].num;j++)
				if (pK_ptr[pet].flower[j]==v) 
					pK_ptr[pet].flower[j]=w;
		 }
		for (i=0;i<=pK_ptr[v].num;i++)
		 {
			pet=pK_ptr[v].flower[i];
			for (j=0;j<=pK_ptr[pet].num;j++)
				if (pK_ptr[pet].flower[j]==vdum) 
					pK_ptr[pet].flower[j]=v;
		 }
		if (p->active_node==v) p->active_node=w;
		else if (p->active_node==w) p->active_node=v;
		if (p->alpha==v) p->alpha=w;
		else if (p->alpha==w) p->alpha=v;
		if (p->beta==v) p->beta=w;
		else if (p->beta==w) p->beta=v;
		if (p->gamma==v) p->gamma=w;
		else if (p->gamma==w) p->gamma=v;
/* fixup ?? -- try to reestablish overlap data */
/*		complex_count(p,0);
		facedraworder(p,NULL);
*/
	 }
	return 1;
} /* swap_nodes */


int 
reverse_orient(p) /* replace complex by one of reverse orientation */
struct p_data *p;
{
	int i,num,j;
	struct K_data *pK_ptr,*newK_ptr;

	pK_ptr=p->packK_ptr;
	if ( (newK_ptr=(struct K_data *)
	   calloc((size_t)(p->nodecount+1),sizeof(struct K_data)))==NULL ) 
		return 0;
	for (i=1;i<=p->nodecount;i++)
	 {
		newK_ptr[i]=pK_ptr[i];
		num=newK_ptr[i].num;
		newK_ptr[i].flower=(int *)malloc((num+1)*sizeof(int));
		for (j=0;j<=num;j++) /* change orientation */
			newK_ptr[i].flower[j]=
			   pK_ptr[i].flower[num-j];
		if (pK_ptr[i].overlaps)
		 {
			newK_ptr[i].overlaps=(float *)
				malloc((num+1)*sizeof(float));
			for (j=0;j<=num;j++) 
			   newK_ptr[i].overlaps[j]=
				pK_ptr[i].overlaps[num-j];
		 }
	 }
	for (i=1;i<=p->nodecount;i++)
	 {
		free(pK_ptr[i].flower);
		free(pK_ptr[i].overlaps);
		pK_ptr[i]=newK_ptr[i];
	 }
	free(newK_ptr);
	return 1;
} /* reverse_orient */

int
alloc_overlaps(p) /* Allocate overlaps ptr space and initialize. 
Return 1 if succeeds or already set. */
struct p_data *p;
{
	int v,i;

	if (p->overlap_status) return 1; /* already have space */
	for (v=1;v<=p->nodecount;v++)
	 {
		if ( (p->packK_ptr[v].overlaps=(float *)
		   malloc((p->packK_ptr[v].num+1)*sizeof(float)))==NULL )
		 {
		   strcpy(msgbuf,"Failed to allocate memory for edge data.");
		   emsg(msgbuf);
		   free_overlaps(p);
		   return 0;
		 }
		else for (i=0;i<=p->packK_ptr[v].num;i++)
			p->packK_ptr[v].overlaps[i]=1.0;
	 }
	p->overlap_status=1;
	return 1;
} /* alloc_overlaps */

void
free_overlaps(p) /* free pointers to overlaps */
struct p_data *p;
{
	int v;

	for (v=1;v<=p->nodecount;v++)
		if (p->packK_ptr[v].overlaps) 
		 {
			free(p->packK_ptr[v].overlaps);
			p->packK_ptr[v].overlaps=NULL;
		 }
	p->overlap_status=0;
} /* free_overlaps */

void
e_anglesum_overlap(p,v,r,c,flag) /* compute ang sum, allow overlaps. 
Radii/overlaps incompatible, flag gets set, results are not reliable. */
int v,*flag;
float r,*c;
struct p_data *p;
{
	int j1,j2,n;
	float o2,o1,ovlp,r1,r2,m1,m2;
	struct K_data *pK_ptr;
	struct R_data *pR_ptr;
	extern int nghb();
	extern float e_cos_overlap();

	pK_ptr=p->packK_ptr;
	pR_ptr=p->packR_ptr;
	*c=0; 
	*flag=0;

	j2=pK_ptr[v].flower[0];
	r2=pR_ptr[j2].rad;
	if (!p->overlap_status)
         {
           m2 = r2/(r+r2);
	   for (n=1;n<=pK_ptr[v].num;n++)
	    {
                m1 = m2;
		r2 = pR_ptr[pK_ptr[v].flower[n]].rad;
                m2 = r2/(r+r2);
		*c +=acos(1-2*m1*m2);
            }
	 }
	else
	 {
		o2=pK_ptr[v].overlaps[0];
		for (n=1;n<=pK_ptr[v].num;n++)
		 {
			j1=j2;r1=r2;o1=o2;
			j2=pK_ptr[v].flower[n];
			r2=pR_ptr[j2].rad;
			o2=pK_ptr[v].overlaps[n];
			ovlp=pK_ptr[j1].overlaps[nghb(p,j1,j2)];
			*c +=acos(e_cos_overlap(r,r1,r2,ovlp,o2,o1,flag));
		 }
	 }
} /* e_anglesum_overlap */

void
h_anglesum_overlap(p,i,s,c,flag) /* compute ang sum, allow overlaps. 
Radii/overlaps incompatible, flag gets set, results are not reliable. */
int i,*flag;
float s,*c;
struct p_data *p;
{
	int k,j2,j1;
	float s1,s2,o1,o2,o3;
	extern float h_cos_overlap(),h_comp_cos();
	struct K_data *pK_ptr;
	struct R_data *pR_ptr;
	extern int nghb();

	*flag=0;
	pK_ptr=p->packK_ptr;
	pR_ptr=p->packR_ptr;
	*c=0;
	if (s<=0) return; /* infinite radius at vertex of interest */
	j2=pK_ptr[i].flower[0];
	s2=pR_ptr[j2].rad;
	if (!p->overlap_status)
		for (k=1;k<=pK_ptr[i].num;k++)
		 {
			s1=s2;
			s2=pR_ptr[pK_ptr[i].flower[k]].rad;
			*c+=acos(h_comp_cos(s,s1,s2));
		 }
	else
	 {
		o2=pK_ptr[i].overlaps[0];
		for (k=1;k<=pK_ptr[i].num;k++)
		 {
			s1=s2;
			o1=o2;
			j1=j2;
			j2=pK_ptr[i].flower[k];
			s2=pR_ptr[j2].rad;
			o2=pK_ptr[i].overlaps[k];
			o3=pK_ptr[j1].overlaps[nghb(p,j1,j2)];
			*c+=acos(h_cos_overlap(s,s1,s2,o3,o2,o1,flag));
		 }
	 }
} /* h_anglesum_overlap */

int
s_anglesum_overlap(p,i,r,c,flag) /* compute ang sum; can't yet do 
overlaps. flag will (eventually) indicate incompatibilities. */
int i,*flag;
float r,*c;
struct p_data *p;
{
	int k,j2;
	float r1,r2;
	extern float s_comp_cos();
	struct K_data *pK_ptr;
	struct R_data *pR_ptr;

	pK_ptr=p->packK_ptr;
	pR_ptr=p->packR_ptr;
	*c=0;
	*flag=0; /* not used yet */

	if (r<=0) return 0; 
	j2=pK_ptr[i].flower[0];
	r2=pR_ptr[j2].rad;
	for (k=1;k<=pK_ptr[i].num;k++)
	 {
		r1=r2;
		r2=pR_ptr[pK_ptr[i].flower[k]].rad;
		*c+=acos(s_comp_cos(r,r1,r2));
	 }
	return 1;
} /* s_anglesum_overlap */

void
fillcurves(p) /* fill in curvatures, pack p */
struct p_data *p;
{
	int i,flag;
	struct R_data *pR_ptr;
	extern void h_anglesum_overlap(),e_anglesum_overlap();

	pR_ptr=p->packR_ptr;
	if (p->hes<0)
	   for (i=1;i<=p->nodecount;i++)
		h_anglesum_overlap(p,i,pR_ptr[i].rad,&pR_ptr[i].curv,&flag);
	else if (p->hes>0)
	   for (i=1;i<=p->nodecount;i++)
		s_anglesum_overlap(p,i,pR_ptr[i].rad,&pR_ptr[i].curv,&flag);
	else
	   for (i=1;i<=p->nodecount;i++)
		e_anglesum_overlap(p,i,pR_ptr[i].rad,&pR_ptr[i].curv,&flag);
} /* fillcurves */

int
alloc_faces_space(p) /* allocate face data space (knowing facecount) */
struct p_data *p;
{
	if (p->faces!=NULL) free(p->faces);
	p->faces=(f_data *)malloc((p->facecount+1)*sizeof(f_data));
	if ((p->faces)==NULL) return 0;
	return 1;
} /* alloc_faces_space */

int
complex_count(p,flag) /* Identify and count the no. of bdry and interior
nodes, bdry and interior components,  Euler characteristic, genus, etc,
for pack p. Stores indicators of bdry and int components in packdata (at
most MAX_COMPONENTS of each). flag means to set default color codes for
circles.*/
struct p_data *p;
int flag;
{
	int i,node,count,bcount,new_vert,num_edges,m,n;
	int comp_count,ptr,k,j,fj,icount,more_flag,next_bdry;
	int max_components=MAX_COMPONENTS;
	struct K_data *pK_ptr;

	pK_ptr=p->packK_ptr;
/* some initialization and counting */
	node=p->nodecount;
	for (i=1;i<=max_components;i++) 
		p->bdry_starts[i]=p->int_starts[i]=0;
	bcount=0;
	comp_count=0;
	for (i=1;i<=node;i++) 
	 {
		pK_ptr[i].plot_flag=0;
		if (flag) pK_ptr[i].color=FG_COLOR;
		if (pK_ptr[i].flower[0]!=pK_ptr[i].flower[pK_ptr[i].num]) 
		 {
			bcount++;
			pK_ptr[i].bdry_flag=1;
		 }
		else pK_ptr[i].bdry_flag=0;
	 }
	p->intnode=node-bcount;

/* identify bdry components, give pointers; note: index starts with 1 */
	count=0;
	new_vert=0;
	do
	 {
		new_vert++;
		if (pK_ptr[new_vert].bdry_flag && !pK_ptr[new_vert].plot_flag)
		 {
		   comp_count++;
		   if (comp_count>max_components)
		    {
			sprintf(msgbuf,
				"This complex has too many bdry components.");
			emsg(msgbuf);
			return 0;
		    }
		   p->bdry_starts[comp_count]=new_vert;
		   next_bdry=new_vert;
		   do
		    {
			pK_ptr[next_bdry].plot_flag=1;
			next_bdry=pK_ptr[next_bdry].flower[0];
			count++;
			if (count>p->nodecount)
			 {
				sprintf(msgbuf,"Problem tracing a boundary path; combinatoric error.");
				emsg(msgbuf);
				return 0;
			 }
		    }
		   while (next_bdry!=new_vert);
		 }
	 }
	while (count<bcount);
	p->num_bdry_comp=comp_count;

/* identify int components and pointers to them */
	icount=node-bcount; /* number of interiors */
	if (icount>0)
	 {
		comp_count=0;
		do
 {
	ptr=0;
	do {ptr++;}
	while (pK_ptr[ptr].plot_flag); 
		/* find smallest index not plotted (hence int node) */
	comp_count++;
	if (comp_count>max_components)
	 {
		sprintf(msgbuf,
			"This complex has too many interior components.");
		emsg(msgbuf);
		return 0;
	 }
	icount--;
	p->int_starts[comp_count]=ptr;
	pK_ptr[ptr].plot_flag=ptr;
	do
	 {
	   more_flag=0; /* will tell me whether I am still finding anything */
	   for (k=ptr;k<=node;k++)
	    {
	      if (pK_ptr[k].plot_flag==ptr)
	       {
		for (j=0;j<=pK_ptr[k].num;j++) 
		 {
			fj=pK_ptr[k].flower[j];
			if (!pK_ptr[fj].plot_flag) 
			 {
				pK_ptr[fj].plot_flag=ptr;
				icount--;
				more_flag=1;
			 }
		 }
	       }
	    }
	 } /* end of inside do */
	while (more_flag && icount>0);
 } /* end of outside do */
		while (icount>0);
		p->num_int_comp=comp_count;
	 } /* end of 'if icount' */
/* find Euler characteristic and genus */
	count=0;
	for (k=1;k<=node;k++) count += pK_ptr[k].num;
	p->facecount=count/3;
	num_edges=(count + bcount)/2;
	p->euler=node-num_edges+p->facecount;
	p->genus=(2-p->euler-p->num_bdry_comp)/2;
/* check if geom is appropriate */
	if (bcount==0 && p->genus==0 && p->hes<=0)
	 {
		strcpy(msgbuf,
		   "Note: This complex is a topological sphere.");
		msg();
	 } 
/* allocate space for face data, store ordered triples of verts. */
	if (!alloc_faces_space(p))
	 {
		sprintf(msgbuf,"Error allocating face data space for pack.");
		emsg(msgbuf);
		return 0;
	 }
	count=1;
	i=1;
	while (count<=p->facecount && i<=p->nodecount)
	{
		for (j=0;j<pK_ptr[i].num;j++)
		 {
			m=pK_ptr[i].flower[j];
			n=pK_ptr[i].flower[j+1];
			if (m>i && n>i) 
			 {
				p->faces[count].vert[0]=i;
				p->faces[count].vert[1]=m;
				p->faces[count].vert[2]=n;
				p->faces[count].color=FG_COLOR;
				count++;
			 }
		 }
		i++;
	 }
	return 1;
} /* complex_count */


int
alloc_pack_space(p,new_size,flag) /* Enlarge pack data space, step of 
5000. Allocate space for pK and pR data, free old space. 
If flag=1, adjust size of current pack, else this is new pack. 
CAUTION: after return, be sure to update any corrupted pointers, e.g.,
pK_ptr and pR_ptr. */
struct p_data *p;
int new_size,flag;
{
	int v,size,oldsize;
	struct K_data *newK,*pK_ptr;
	struct R_data *newR,*pR_ptr;
	
	if (!p) return 0;
	oldsize=p->sizelimit;
	size=((int)((new_size-1)/5000))*5000+5000;
	if (flag && size==oldsize) return 1; /* no action needed */
	if (flag && (p->nodecount > (size-1))) return 0; 
		/* pack too big for given new_size */

	pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
	p->sizelimit=size;
	if ((newK=(struct K_data *)
	   calloc((size_t)(size+1),sizeof(struct K_data)))==NULL)
		return 0;
	if ((newR=(struct R_data *)
	   malloc((size+1)*sizeof(struct R_data)))==NULL)
	 {free(newK);p->sizelimit=oldsize;return 0;}
	if (flag) for (v=1;v<=p->nodecount;v++) /* copy old data */
	 {
		newK[v]=pK_ptr[v];
		newR[v]=pR_ptr[v];
	 }
	else /* empty out pack and reset */
	 {
	 	if (p->faces) 
		 {free(p->faces);p->faces=NULL;}
		if (pK_ptr) for (v=1;v<=p->nodecount;v++)
		 {
			if (pK_ptr[v].flower) free(pK_ptr[v].flower);
			if (pK_ptr[v].overlaps) free(pK_ptr[v].overlaps);
		 }
		p->overlap_status=p->status=0;
		p->nodecount=p->first_red_face=p->status=p->locks=0;
	 }
	if (pK_ptr) free(pK_ptr);
	if (pR_ptr) free(pR_ptr);
	p->packK_ptr=newK;
	p->packR_ptr=newR;
	return 1;
} /* alloc_pack_space */

int
print_flower(p,v) /* print out flower for debugging */
struct p_data *p;
int v;
{
	int j;

	fprintf(stderr,"Flower vert=%d, num= %d :  ",
		v,p->packK_ptr[v].num);
	for (j=0;j<=p->packK_ptr[v].num && j<100;j++)
		fprintf(stderr," %d, ",p->packK_ptr[v].flower[j]);
} /* print_flower */


